/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.kamranzafar.jtar.TarInputStream;
import org.kamranzafar.jtar.TarOutputStream;
import org.unfoldingword.resourcecontainer.ContainerTools;
import org.unfoldingword.resourcecontainer.util.FileUtil;
import org.unfoldingword.resourcecontainer.util.TarUtil;

public class ResourceContainer {
    public static final int version = 7;
    public static final String fileExtension = "tsrc";
    public static final String baseMimeType = "application/tsrc";
    private static final String CONTENT_DIR = "content";
    public final File path;
    public final JSONObject info;
    public final Map config;
    public final Object toc;
    public final String slug;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceContainer(File containerDirectory, JSONObject containerInfo) throws JSONException {
        this.path = containerDirectory;
        this.info = containerInfo;
        this.slug = ContainerTools.makeSlug(containerInfo.getJSONObject("language").getString("slug"), containerInfo.getJSONObject("project").getString("slug"), containerInfo.getJSONObject("resource").getString("slug"));
        File configFile = new File(containerDirectory, "content/config.yml");
        Map tempConfig = null;
        try {
            YamlReader reader = new YamlReader((Reader)new FileReader(configFile));
            Object object = reader.read();
            tempConfig = (Map)object;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (YamlException e) {
            e.printStackTrace();
        }
        finally {
            if (tempConfig == null) {
                tempConfig = new HashMap();
            }
        }
        this.config = tempConfig;
        File tocFile = new File(containerDirectory, "content/toc.yml");
        HashMap tempToc = null;
        try {
            YamlReader reader = new YamlReader((Reader)new FileReader(tocFile));
            tempToc = reader.read();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (YamlException e) {
            e.printStackTrace();
        }
        finally {
            if (tempToc == null) {
                tempToc = new HashMap();
            }
        }
        this.toc = tempToc;
    }

    public static ResourceContainer load(File containerDirectory) throws Exception {
        if (!containerDirectory.exists()) {
            throw new Exception("The resource container does not exist");
        }
        if (!containerDirectory.isDirectory()) {
            throw new Exception("Not an open resource container");
        }
        File packageFile = new File(containerDirectory, "package.json");
        if (!packageFile.exists()) {
            throw new Exception("Not a resource container");
        }
        JSONObject packageJson = new JSONObject(FileUtil.readFileToString(packageFile));
        if (!packageJson.has("package_version")) {
            throw new Exception("Not a resource container");
        }
        if (packageJson.getInt("package_version") > 7) {
            throw new Exception("Unsupported container version");
        }
        if (packageJson.getInt("package_version") < 7) {
            throw new Exception("Outdated container version");
        }
        return new ResourceContainer(containerDirectory, packageJson);
    }

    public static ResourceContainer make(File containerDirectory, JSONObject opts) throws Exception {
        if (containerDirectory.exists()) {
            throw new Exception("Resource container directory already exists");
        }
        throw new Exception("Not implemented yet!");
    }

    public static ResourceContainer open(File containerArchive, File containerDirectory) throws Exception {
        BufferedInputStream in;
        FileInputStream fin;
        if (!containerArchive.exists()) {
            throw new Exception("Missing resource container");
        }
        File tempFile = new File(containerArchive + ".tmp.tar");
        FileOutputStream out = null;
        BZip2CompressorInputStream bzIn = null;
        try {
            int n;
            fin = new FileInputStream(containerArchive);
            in = new BufferedInputStream(fin);
            out = new FileOutputStream(tempFile);
            bzIn = new BZip2CompressorInputStream((InputStream)in);
            byte[] buffer = new byte[2048];
            while ((n = bzIn.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            FileUtil.deleteQuietly(tempFile);
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (bzIn != null) {
                bzIn.close();
            }
        }
        fin = new FileInputStream(tempFile);
        in = new BufferedInputStream(fin);
        TarInputStream tin = new TarInputStream((InputStream)in);
        try {
            containerDirectory.mkdirs();
            TarUtil.untar(tin, containerDirectory.getAbsolutePath());
        }
        catch (Exception e) {
            FileUtil.deleteQuietly(containerDirectory);
            throw e;
        }
        finally {
            tin.close();
            FileUtil.deleteQuietly(tempFile);
        }
        return ResourceContainer.load(containerDirectory);
    }

    public static File close(File containerDirectory) throws Exception {
        if (!containerDirectory.exists()) {
            throw new Exception("Missing resource container");
        }
        File tempFile = new File(containerDirectory.getAbsolutePath() + ".tmp.tar");
        try (TarOutputStream tout = new TarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(tempFile)));){
            TarUtil.tar(null, containerDirectory.getAbsolutePath(), tout);
        }
        File archive = new File(containerDirectory.getAbsolutePath() + "." + fileExtension);
        BZip2CompressorOutputStream bzOut = null;
        BufferedInputStream in = null;
        try {
            int n;
            FileInputStream fin = new FileInputStream(tempFile);
            in = new BufferedInputStream(fin);
            FileOutputStream out = new FileOutputStream(archive);
            bzOut = new BZip2CompressorOutputStream((OutputStream)out);
            byte[] buffer = new byte[2048];
            while ((n = in.read(buffer)) != -1) {
                bzOut.write(buffer, 0, n);
            }
            bzOut.close();
            in.close();
        }
        catch (Exception e) {
            FileUtil.deleteQuietly(archive);
            throw e;
        }
        finally {
            if (bzOut != null) {
                bzOut.close();
            }
            if (in != null) {
                in.close();
            }
            FileUtil.deleteQuietly(tempFile);
        }
        return archive;
    }
}

