/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.logger;

import android.util.Base64;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public abstract class Reporter {
    private final String url;
    private String authToken = null;
    private String username = null;
    private String password = null;

    public Reporter(String url) {
        this.url = url;
    }

    public void setAuthorization(String token) {
        this.authToken = token;
    }

    public void setAuthorization(String username, String password) {
        this.username = username;
        this.password = password;
    }

    private String getAuth() {
        if (this.authToken != null) {
            return "token " + this.authToken;
        }
        if (this.username != null && this.password != null) {
            String credentials = this.username + ":" + this.password;
            try {
                return "Basic " + Base64.encodeToString((byte[])credentials.getBytes("UTF-8"), (int)2);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String submit(String data) {
        try {
            int current;
            URL url = new URL(this.url);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            String auth = this.getAuth();
            if (auth != null) {
                conn.setRequestProperty("Authorization", auth);
            }
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            DataOutputStream dos = new DataOutputStream(conn.getOutputStream());
            dos.writeBytes(data);
            dos.flush();
            dos.close();
            InputStream is = conn.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((current = bis.read()) != -1) {
                baos.write((byte)current);
            }
            return baos.toString("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

