/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.logger;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import java.io.File;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.unfoldingword.tools.logger.FileUtils;
import org.unfoldingword.tools.logger.Reporter;

public class GithubReporter
extends Reporter {
    private static final int MAX_TITLE_LENGTH = 50;
    private static final String DEFAULT_CRASH_TITLE = "crash report";
    private static final String DEFAULT_BUG_TITLE = "bug report";
    private final Context context;

    public GithubReporter(Context context, String repositoryUrl, String githubOauth2Token) {
        super(repositoryUrl);
        this.setAuthorization(githubOauth2Token);
        this.context = context;
    }

    public void reportCrash(String notes, File stacktraceFile) {
        try {
            String stacktrace = FileUtils.readFileToString(stacktraceFile);
            this.reportCrash(notes, stacktrace, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reportCrash(String notes, File stacktraceFile, File logFile) {
        String log = null;
        if (logFile.exists()) {
            try {
                log = FileUtils.readFileToString(logFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            String stacktrace = FileUtils.readFileToString(stacktraceFile);
            this.reportCrash(notes, stacktrace, log);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reportCrash(String notes, String stacktrace, String log) {
        String title = GithubReporter.getTitle(notes, DEFAULT_CRASH_TITLE);
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append(GithubReporter.getNotesBlock(notes));
        bodyBuf.append(this.getEnvironmentBlock());
        bodyBuf.append(GithubReporter.getStacktraceBlock(stacktrace));
        bodyBuf.append(this.getLogBlock(log));
        String[] labels = new String[]{DEFAULT_CRASH_TITLE};
        String respose = this.submit(this.generatePayload(title, bodyBuf.toString(), labels));
    }

    public void reportBug(String notes) {
        this.reportBug(notes, "");
    }

    public void reportBug(String notes, File logFile) {
        String log = null;
        if (logFile != null && logFile.exists()) {
            try {
                log = FileUtils.readFileToString(logFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.reportBug(notes, log);
    }

    public void reportBug(String notes, String log) {
        String title = GithubReporter.getTitle(notes, DEFAULT_BUG_TITLE);
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append(GithubReporter.getNotesBlock(notes));
        bodyBuf.append(this.getEnvironmentBlock());
        bodyBuf.append(this.getLogBlock(log));
        String[] labels = new String[]{DEFAULT_BUG_TITLE};
        String respose = this.submit(this.generatePayload(title, bodyBuf.toString(), labels));
    }

    private String generatePayload(String title, String body, String[] labels) {
        JSONObject json = new JSONObject();
        try {
            json.put("title", (Object)title);
            json.put("body", (Object)body);
            JSONArray labelsJson = new JSONArray();
            for (String label : labels) {
                labelsJson.put((Object)label);
            }
            try {
                PackageInfo pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
                labelsJson.put((Object)pInfo.versionName);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            json.put("labels", (Object)labelsJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    private String getLogBlock(String log) {
        StringBuffer logBuf = new StringBuffer();
        if (log != null && !log.isEmpty()) {
            logBuf.append("Log history\n======\n");
            logBuf.append("```java\n");
            logBuf.append(log + "\n");
            logBuf.append("```\n");
        }
        return logBuf.toString();
    }

    private static String getStacktraceBlock(String stacktrace) {
        StringBuffer stacktraceBuf = new StringBuffer();
        if (stacktrace != null && !stacktrace.isEmpty()) {
            stacktraceBuf.append("Stack trace\n======\n");
            stacktraceBuf.append("```java\n");
            stacktraceBuf.append(stacktrace + "\n");
            stacktraceBuf.append("```\n");
        }
        return stacktraceBuf.toString();
    }

    private static String getNotesBlock(String notes) {
        StringBuffer notesBuf = new StringBuffer();
        if (!notes.isEmpty()) {
            notesBuf.append("Notes\n======\n");
            notesBuf.append(notes + "\n");
        }
        return notesBuf.toString();
    }

    private String getEnvironmentBlock() {
        PackageInfo pInfo = null;
        StringBuffer environmentBuf = new StringBuffer();
        environmentBuf.append("\nEnvironment\n======\n");
        environmentBuf.append("Environment Key | Value\n");
        environmentBuf.append(":----: | :----:\n");
        try {
            pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            environmentBuf.append("version | " + pInfo.versionName + "\n");
            environmentBuf.append("build | " + pInfo.versionCode + "\n");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        String udid = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        environmentBuf.append("UDID | " + udid + "\n");
        environmentBuf.append("Android Release | " + Build.VERSION.RELEASE + "\n");
        environmentBuf.append("Android SDK | " + Build.VERSION.SDK_INT + "\n");
        environmentBuf.append("Brand | " + Build.BRAND + "\n");
        environmentBuf.append("Device | " + Build.DEVICE + "\n");
        return environmentBuf.toString();
    }

    private static String getTitle(String notes, String defaultTitle) {
        String title = defaultTitle;
        if (notes.length() < 50 && !notes.isEmpty()) {
            title = notes;
        } else if (!notes.isEmpty()) {
            title = notes.substring(0, 47) + "...";
        }
        return title;
    }
}

