/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.helm.util;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"BytesPerGB", "", "BytesPerKB", "BytesPerMB", "formatDataSize", "", "bytes", "helm-plugin"})
public final class DataSizeFormatterKt {
    private static final long BytesPerKB = 1024L;
    private static final long BytesPerMB = 0x100000L;
    private static final long BytesPerGB = 0x40000000L;

    @NotNull
    public static final String formatDataSize(long bytes) {
        Object object;
        if (bytes < 1024L) {
            object = bytes + " B";
        } else if (bytes < 0x100000L) {
            float kb = (float)(bytes * (long)10 / 1024L) * 0.1f;
            String string = "%.1f KB";
            Object[] objectArray = new Object[]{Float.valueOf(kb)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        } else if (bytes < 0x40000000L) {
            float mb = (float)(bytes * (long)10 / 0x100000L) * 0.1f;
            String string = "%.1f MB";
            Object[] objectArray = new Object[]{Float.valueOf(mb)};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        } else {
            float gb = (float)(bytes * (long)10 / 0x40000000L) * 0.1f;
            String string = "%.1f GB";
            Object[] objectArray = new Object[]{Float.valueOf(gb)};
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            object = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        }
        return object;
    }
}

