/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.helm.util;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.unbrokendome.gradle.plugins.helm.util.YamlPath;
import org.unbrokendome.gradle.plugins.helm.util.YamlTransformingReaderKt;
import org.unbrokendome.gradle.pluginutils.io.DelegateReader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b \u0018\u00002\u00020\u0001:\u0006\r\u000e\u000f\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader;", "Lorg/unbrokendome/gradle/pluginutils/io/DelegateReader;", "input", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "addToMapping", "", "", "path", "Lorg/unbrokendome/gradle/plugins/helm/util/YamlPath;", "createDelegateReader", "transformScalar", "value", "Initial", "MappingState", "MappingValueState", "ParseState", "SequenceItemState", "ValueState", "helm-plugin"})
public abstract class AbstractYamlTransformingReader
extends DelegateReader {
    public AbstractYamlTransformingReader(@NotNull Reader input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super(input);
    }

    @Nullable
    protected String transformScalar(@NotNull YamlPath path, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value;
    }

    @NotNull
    protected Map<String, String> addToMapping(@NotNull YamlPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return MapsKt.emptyMap();
    }

    @NotNull
    protected Reader createDelegateReader(@NotNull Reader input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Iterable events = new Yaml().parse(input);
        Mark currentMark = null;
        ParseState state = new Initial();
        StringWriter output = new StringWriter();
        for (Event event : events) {
            if (currentMark != null && event.getStartMark().getIndex() > currentMark.getIndex()) {
                Mark mark = event.getStartMark();
                Intrinsics.checkNotNullExpressionValue((Object)mark, (String)"getStartMark(...)");
                output.write(YamlTransformingReaderKt.access$readFromBuffer(currentMark, mark));
            }
            Intrinsics.checkNotNull((Object)event);
            if (state.handleEvent(event, output) == null) break;
            currentMark = event.getEndMark();
        }
        return new StringReader(output.toString());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$Initial;", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ValueState;", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader;", "(Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader;)V", "handleEvent", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ParseState;", "event", "Lorg/yaml/snakeyaml/events/Event;", "writer", "Ljava/io/Writer;", "helm-plugin"})
    private final class Initial
    extends ValueState {
        public Initial() {
            super(CollectionsKt.emptyList());
        }

        @Override
        @Nullable
        public ParseState handleEvent(@NotNull Event event, @NotNull Writer writer) {
            ParseState parseState;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Event event2 = event;
            if (event2 instanceof StreamStartEvent ? true : event2 instanceof DocumentStartEvent) {
                YamlTransformingReaderKt.access$writeEventChars(event, writer);
                parseState = this;
            } else if (event2 instanceof StreamEndEvent) {
                YamlTransformingReaderKt.access$writeEventChars(event, writer);
                parseState = null;
            } else {
                parseState = this.handleValueEvent(event, writer, null);
            }
            return parseState;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$MappingState;", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ParseState;", "path", "", "Lorg/unbrokendome/gradle/plugins/helm/util/YamlPath$Element;", "mappingStartEvent", "Lorg/yaml/snakeyaml/events/MappingStartEvent;", "next", "(Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader;Ljava/util/List;Lorg/yaml/snakeyaml/events/MappingStartEvent;Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ParseState;)V", "handleEvent", "event", "Lorg/yaml/snakeyaml/events/Event;", "writer", "Ljava/io/Writer;", "quoteValue", "", "helm-plugin"})
    @SourceDebugExtension(value={"SMAP\nYamlTransformingReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlTransformingReader.kt\norg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$MappingState\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,254:1\n215#2,2:255\n215#2,2:257\n*S KotlinDebug\n*F\n+ 1 YamlTransformingReader.kt\norg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$MappingState\n*L\n158#1:255,2\n163#1:257,2\n*E\n"})
    private final class MappingState
    implements ParseState {
        @NotNull
        private final List<YamlPath.Element> path;
        @NotNull
        private final MappingStartEvent mappingStartEvent;
        @Nullable
        private final ParseState next;

        public MappingState(@NotNull List<? extends YamlPath.Element> path, @Nullable MappingStartEvent mappingStartEvent, ParseState next) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)mappingStartEvent, (String)"mappingStartEvent");
            this.path = path;
            this.mappingStartEvent = mappingStartEvent;
            this.next = next;
        }

        @Override
        @Nullable
        public ParseState handleEvent(@NotNull Event event, @NotNull Writer writer) {
            ParseState parseState;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Event event2 = event;
            if (event2 instanceof MappingEndEvent) {
                Map<String, String> extraEntries = AbstractYamlTransformingReader.this.addToMapping(new YamlPath(this.path));
                if (!extraEntries.isEmpty()) {
                    if (this.mappingStartEvent.isFlow()) {
                        Map<String, String> $this$forEach$iv = extraEntries;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, String> element$iv;
                            Map.Entry<String, String> entry = element$iv = iterator.next();
                            boolean bl = false;
                            String key = entry.getKey();
                            String value = entry.getValue();
                            writer.write(", " + key + ": " + this.quoteValue(value));
                        }
                    } else {
                        String indent = StringsKt.repeat((CharSequence)" ", (int)this.mappingStartEvent.getStartMark().getColumn());
                        Map<String, String> $this$forEach$iv = extraEntries;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, String> element$iv;
                            Map.Entry<String, String> entry = element$iv = iterator.next();
                            boolean bl = false;
                            String key = entry.getKey();
                            String value = entry.getValue();
                            StringsKt.appendln((Appendable)writer);
                            writer.write(indent + key + ": " + this.quoteValue(value));
                        }
                    }
                }
                YamlTransformingReaderKt.access$writeEventChars(event, writer);
                parseState = this.next;
            } else if (event2 instanceof ScalarEvent) {
                Mark mark = ((ScalarEvent)event).getStartMark();
                Intrinsics.checkNotNullExpressionValue((Object)mark, (String)"getStartMark(...)");
                Mark mark2 = ((ScalarEvent)event).getEndMark();
                Intrinsics.checkNotNullExpressionValue((Object)mark2, (String)"getEndMark(...)");
                String value = YamlTransformingReaderKt.access$readFromBuffer(mark, mark2);
                writer.write(value);
                Collection collection = this.path;
                String string = ((ScalarEvent)event).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                parseState = new MappingValueState(CollectionsKt.plus((Collection)collection, (Object)new YamlPath.Element.MappingKey(string)), this);
            } else {
                throw new YAMLException("Unexpected event: " + event);
            }
            return parseState;
        }

        private final String quoteValue(String $this$quoteValue) {
            char c = '\"';
            String string = StringsKt.replace$default((String)$this$quoteValue, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
            return c + string + "\"";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$MappingValueState;", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ValueState;", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader;", "path", "", "Lorg/unbrokendome/gradle/plugins/helm/util/YamlPath$Element;", "next", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ParseState;", "(Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader;Ljava/util/List;Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ParseState;)V", "handleEvent", "event", "Lorg/yaml/snakeyaml/events/Event;", "writer", "Ljava/io/Writer;", "helm-plugin"})
    private final class MappingValueState
    extends ValueState {
        @Nullable
        private final ParseState next;

        public MappingValueState(@Nullable List<? extends YamlPath.Element> path, ParseState next) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            super(path);
            this.next = next;
        }

        @Override
        @Nullable
        public ParseState handleEvent(@NotNull Event event, @NotNull Writer writer) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            return this.handleValueEvent(event, writer, this.next);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ParseState;", "", "handleEvent", "event", "Lorg/yaml/snakeyaml/events/Event;", "writer", "Ljava/io/Writer;", "helm-plugin"})
    private static interface ParseState {
        @Nullable
        public ParseState handleEvent(@NotNull Event var1, @NotNull Writer var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$SequenceItemState;", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ValueState;", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader;", "path", "", "Lorg/unbrokendome/gradle/plugins/helm/util/YamlPath$Element;", "index", "", "next", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ParseState;", "(Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader;Ljava/util/List;ILorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ParseState;)V", "handleEvent", "event", "Lorg/yaml/snakeyaml/events/Event;", "writer", "Ljava/io/Writer;", "helm-plugin"})
    private final class SequenceItemState
    extends ValueState {
        private final int index;
        @Nullable
        private final ParseState next;

        public SequenceItemState(List<? extends YamlPath.Element> path, @Nullable int index, ParseState next) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            super(CollectionsKt.plus((Collection)path, (Object)new YamlPath.Element.SequenceIndex(index)));
            this.index = index;
            this.next = next;
        }

        @Override
        @Nullable
        public ParseState handleEvent(@NotNull Event event, @NotNull Writer writer) {
            ParseState parseState;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            if (event instanceof SequenceEndEvent) {
                YamlTransformingReaderKt.access$writeEventChars(event, writer);
                parseState = this.next;
            } else {
                parseState = this.handleValueEvent(event, writer, new SequenceItemState(CollectionsKt.dropLast(this.getPath(), (int)1), this.index + 1, this.next));
            }
            return parseState;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J$\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ValueState;", "Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader$ParseState;", "path", "", "Lorg/unbrokendome/gradle/plugins/helm/util/YamlPath$Element;", "(Lorg/unbrokendome/gradle/plugins/helm/util/AbstractYamlTransformingReader;Ljava/util/List;)V", "getPath", "()Ljava/util/List;", "handleValueEvent", "event", "Lorg/yaml/snakeyaml/events/Event;", "writer", "Ljava/io/Writer;", "next", "helm-plugin"})
    private abstract class ValueState
    implements ParseState {
        @NotNull
        private final List<YamlPath.Element> path;

        public ValueState(List<? extends YamlPath.Element> path) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            this.path = path;
        }

        @NotNull
        public final List<YamlPath.Element> getPath() {
            return this.path;
        }

        @Nullable
        protected final ParseState handleValueEvent(@NotNull Event event, @NotNull Writer writer, @Nullable ParseState next) {
            ParseState parseState;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            if (event instanceof ScalarEvent) {
                Mark mark = ((ScalarEvent)event).getStartMark();
                Intrinsics.checkNotNullExpressionValue((Object)mark, (String)"getStartMark(...)");
                Mark mark2 = ((ScalarEvent)event).getEndMark();
                Intrinsics.checkNotNullExpressionValue((Object)mark2, (String)"getEndMark(...)");
                String value = YamlTransformingReaderKt.access$readFromBuffer(mark, mark2);
                String string = AbstractYamlTransformingReader.this.transformScalar(new YamlPath(this.path), value);
                if (string == null) {
                    string = value;
                }
                String transformed = string;
                writer.write(transformed);
                parseState = next;
            } else {
                YamlTransformingReaderKt.access$writeEventChars(event, writer);
                Event event2 = event;
                parseState = event2 instanceof MappingStartEvent ? (ParseState)new MappingState(this.path, (MappingStartEvent)event, next) : (event2 instanceof SequenceStartEvent ? (ParseState)new SequenceItemState(this.path, 0, next) : next);
            }
            return parseState;
        }
    }
}

