/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.helm.command.tasks;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.unbrokendome.gradle.plugins.helm.command.HelmCommandSupportKt;
import org.unbrokendome.gradle.plugins.helm.command.HelmExecSpec;
import org.unbrokendome.gradle.plugins.helm.command.tasks.AbstractHelmCommandTask;
import org.unbrokendome.gradle.plugins.helm.command.tasks.AbstractHelmInstallationCommandTask;
import org.unbrokendome.gradle.plugins.helm.model.Release;
import org.unbrokendome.gradle.plugins.helm.model.ReleaseStatus;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\tH\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/command/tasks/HelmInstallOrUpgrade;", "Lorg/unbrokendome/gradle/plugins/helm/command/tasks/AbstractHelmInstallationCommandTask;", "()V", "historyMax", "Lorg/gradle/api/provider/Property;", "", "getHistoryMax", "()Lorg/gradle/api/provider/Property;", "replace", "", "getReplace", "resetValues", "getResetValues", "reuseValues", "getReuseValues", "installOrUpgrade", "", "shouldUseInstallReplace", "helm-plugin"})
@SourceDebugExtension(value={"SMAP\nHelmInstallOrUpgrade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmInstallOrUpgrade.kt\norg/unbrokendome/gradle/plugins/helm/command/tasks/HelmInstallOrUpgrade\n+ 2 ObjectFactoryExtensions.kt\norg/unbrokendome/gradle/pluginutils/ObjectFactoryExtensionsKt\n*L\n1#1,113:1\n17#2:114\n17#2:115\n17#2:116\n17#2:117\n*S KotlinDebug\n*F\n+ 1 HelmInstallOrUpgrade.kt\norg/unbrokendome/gradle/plugins/helm/command/tasks/HelmInstallOrUpgrade\n*L\n27#1:114\n40#1:115\n53#1:116\n67#1:117\n*E\n"})
public class HelmInstallOrUpgrade
extends AbstractHelmInstallationCommandTask {
    @NotNull
    private final Property<Boolean> replace;
    @NotNull
    private final Property<Boolean> resetValues;
    @NotNull
    private final Property<Boolean> reuseValues;
    @NotNull
    private final Property<Integer> historyMax;

    public HelmInstallOrUpgrade() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.javaObjectType)");
        Property property2 = property.convention((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"convention(...)");
        this.replace = property2;
        ObjectFactory objectFactory2 = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"getObjects(...)");
        ObjectFactory $this$property$iv2 = objectFactory2;
        boolean $i$f$property2 = false;
        Property property3 = $this$property$iv2.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.javaObjectType)");
        this.resetValues = property3;
        ObjectFactory objectFactory3 = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory3, (String)"getObjects(...)");
        $this$property$iv2 = objectFactory3;
        $i$f$property2 = false;
        Property property4 = $this$property$iv2.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(T::class.javaObjectType)");
        this.reuseValues = property4;
        ObjectFactory objectFactory4 = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory4, (String)"getObjects(...)");
        $this$property$iv2 = objectFactory4;
        $i$f$property2 = false;
        Property property5 = $this$property$iv2.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(T::class.javaObjectType)");
        this.historyMax = property5;
    }

    @Internal
    @NotNull
    public final Property<Boolean> getReplace() {
        return this.replace;
    }

    @Internal
    @NotNull
    public final Property<Boolean> getResetValues() {
        return this.resetValues;
    }

    @Internal
    @NotNull
    public final Property<Boolean> getReuseValues() {
        return this.reuseValues;
    }

    @Internal
    @NotNull
    public final Property<Integer> getHistoryMax() {
        return this.historyMax;
    }

    @TaskAction
    public final void installOrUpgrade() {
        if (this.shouldUseInstallReplace()) {
            AbstractHelmCommandTask.execHelm$default(this, "install", null, (Function1)new Function1<HelmExecSpec, Unit>(this){
                final /* synthetic */ HelmInstallOrUpgrade this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull HelmExecSpec $this$execHelm) {
                    Intrinsics.checkNotNullParameter((Object)$this$execHelm, (String)"$this$execHelm");
                    $this$execHelm.args((Provider<? extends Object>)((Provider)this.this$0.getReleaseName()));
                    $this$execHelm.args((Provider<? extends Object>)((Provider)this.this$0.getChart()));
                    HelmExecSpec.flag$default($this$execHelm, "--replace", false, false, 6, null);
                }
            }, 2, null);
        } else {
            AbstractHelmCommandTask.execHelm$default(this, "upgrade", null, (Function1)new Function1<HelmExecSpec, Unit>(this){
                final /* synthetic */ HelmInstallOrUpgrade this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull HelmExecSpec $this$execHelm) {
                    Intrinsics.checkNotNullParameter((Object)$this$execHelm, (String)"$this$execHelm");
                    $this$execHelm.args((Provider<? extends Object>)((Provider)this.this$0.getReleaseName()));
                    $this$execHelm.args((Provider<? extends Object>)((Provider)this.this$0.getChart()));
                    HelmExecSpec.flag$default($this$execHelm, "--install", false, false, 6, null);
                    HelmExecSpec.flag$default($this$execHelm, "--reset-values", (Provider)this.this$0.getResetValues(), false, 4, null);
                    HelmExecSpec.flag$default($this$execHelm, "--reuse-values", (Provider)this.this$0.getReuseValues(), false, 4, null);
                    $this$execHelm.option("--history-max", (Provider<? extends Object>)((Provider)this.this$0.getHistoryMax()));
                }
            }, 2, null);
        }
    }

    private final boolean shouldUseInstallReplace() {
        Object object = this.replace.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            return true;
        }
        Release release = HelmCommandSupportKt.getHelmCommandSupport((AbstractHelmCommandTask)this).getRelease((Provider<String>)((Provider)this.getReleaseName()));
        if (release == null) {
            this.getLogger().info("Release \"{}\" does not exist. Using 'helm upgrade --install' to install it.");
            return false;
        }
        if (release.getStatus() == ReleaseStatus.FAILED) {
            this.getLogger().info("Release \"{}\" has previously failed. Using 'helm install --replace' to install it.");
            return true;
        }
        return false;
    }
}

