/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.helm.command.tasks;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.unbrokendome.gradle.plugins.helm.command.tasks.HelmDownloadClientPackage;
import org.unbrokendome.gradle.plugins.helm.util.DataSizeFormatterKt;
import org.unbrokendome.gradle.plugins.helm.util.DigestUtilsKt;
import org.unbrokendome.gradle.pluginutils.ProjectPropertiesKt;
import org.unbrokendome.gradle.pluginutils.SystemUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 .2\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\n2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010)\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020&H\u0002J\b\u0010*\u001a\u00020\u0005H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00020\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0019\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0019\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0019\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\f\u00a8\u0006/"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/command/tasks/HelmDownloadClientPackage;", "Lorg/gradle/api/DefaultTask;", "()V", "archiveFormat", "Lorg/gradle/api/provider/Provider;", "", "getArchiveFormat$helm_plugin", "()Lorg/gradle/api/provider/Provider;", "baseUrl", "Lorg/gradle/api/provider/Property;", "Ljava/net/URI;", "getBaseUrl", "()Lorg/gradle/api/provider/Property;", "destinationDir", "Lorg/gradle/api/file/DirectoryProperty;", "getDestinationDir", "()Lorg/gradle/api/file/DirectoryProperty;", "downloadUrl", "getDownloadUrl", "osClassifier", "getOsClassifier$helm_plugin", "outputFile", "Lorg/gradle/api/file/RegularFile;", "getOutputFile", "packageFileName", "getPackageFileName$helm_plugin", "sha256SumFile", "getSha256SumFile", "sha256SumFileName", "getSha256SumFileName$helm_plugin", "sha256SumUrl", "getSha256SumUrl", "version", "getVersion", "downloadClientPackage", "", "downloadClientPackageFile", "targetFile", "Ljava/io/File;", "downloadFile", "url", "downloadSha256SumFile", "readSha256DigestFromFile", "verifySha256Digest", "", "expectedDigest", "Companion", "helm-plugin"})
@SourceDebugExtension(value={"SMAP\nHelmDownloadClientPackage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmDownloadClientPackage.kt\norg/unbrokendome/gradle/plugins/helm/command/tasks/HelmDownloadClientPackage\n+ 2 ObjectFactoryExtensions.kt\norg/unbrokendome/gradle/pluginutils/ObjectFactoryExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n17#2:294\n17#2:295\n1#3:296\n*S KotlinDebug\n*F\n+ 1 HelmDownloadClientPackage.kt\norg/unbrokendome/gradle/plugins/helm/command/tasks/HelmDownloadClientPackage\n*L\n41#1:294\n49#1:295\n*E\n"})
public abstract class HelmDownloadClientPackage
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Property<String> version;
    @NotNull
    private final Property<URI> baseUrl;
    @NotNull
    private final Provider<String> osClassifier;
    @NotNull
    private final Provider<String> archiveFormat;
    @NotNull
    private final Provider<String> packageFileName;
    @NotNull
    private final Provider<String> sha256SumFileName;
    @NotNull
    private final Provider<URI> downloadUrl;
    @NotNull
    private final Provider<URI> sha256SumUrl;
    @NotNull
    private final DirectoryProperty destinationDir;
    @NotNull
    private final Provider<RegularFile> outputFile;
    @NotNull
    private final Provider<RegularFile> sha256SumFile;
    private static final int BufferSize = 10240;
    private static final int ConnectTimeoutMilliseconds = 30000;
    private static final int ReadTimeoutMilliseconds = 30000;
    private static final int ProgressChunkSize = 262144;

    public HelmDownloadClientPackage() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.javaObjectType)");
        this.version = property;
        ObjectFactory objectFactory2 = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"getObjects(...)");
        $this$property$iv = objectFactory2;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(URI.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.javaObjectType)");
        this.baseUrl = property2;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.osClassifier = ProjectPropertiesKt.providerFromProjectProperty$default((Project)project, (String)"helm.client.download.osclassifier", (String)SystemUtils.INSTANCE.getOperatingSystemClassifier(), (boolean)false, (int)4, null);
        Provider provider = this.osClassifier.map(arg_0 -> HelmDownloadClientPackage.archiveFormat$lambda$0(archiveFormat.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"map(...)");
        this.archiveFormat = provider;
        Provider provider2 = this.version.map(arg_0 -> HelmDownloadClientPackage.packageFileName$lambda$1((Function1)new Function1<String, String>(this){
            final /* synthetic */ HelmDownloadClientPackage this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(String version) {
                return "helm-v" + version + "-" + this.this$0.getOsClassifier$helm_plugin().get() + "." + this.this$0.getArchiveFormat$helm_plugin().get();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"map(...)");
        this.packageFileName = provider2;
        Provider provider3 = this.packageFileName.map(arg_0 -> HelmDownloadClientPackage.sha256SumFileName$lambda$2(sha256SumFileName.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"map(...)");
        this.sha256SumFileName = provider3;
        Provider provider4 = this.getProject().provider(() -> HelmDownloadClientPackage.downloadUrl$lambda$3(this));
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"provider(...)");
        this.downloadUrl = provider4;
        Provider provider5 = this.getProject().provider(() -> HelmDownloadClientPackage.sha256SumUrl$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"provider(...)");
        this.sha256SumUrl = provider5;
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"directoryProperty(...)");
        this.destinationDir = directoryProperty;
        Provider provider6 = this.destinationDir.file(this.packageFileName);
        Intrinsics.checkNotNullExpressionValue((Object)provider6, (String)"file(...)");
        this.outputFile = provider6;
        Provider provider7 = this.destinationDir.file(this.sha256SumFileName);
        Intrinsics.checkNotNullExpressionValue((Object)provider7, (String)"file(...)");
        this.sha256SumFile = provider7;
    }

    @Input
    @NotNull
    public final Property<String> getVersion() {
        return this.version;
    }

    @Input
    @NotNull
    public final Property<URI> getBaseUrl() {
        return this.baseUrl;
    }

    @Internal(value="Represented as part of downloadUrl")
    @NotNull
    public final Provider<String> getOsClassifier$helm_plugin() {
        return this.osClassifier;
    }

    @Internal(value="Represented as part of downloadUrl")
    @NotNull
    public final Provider<String> getArchiveFormat$helm_plugin() {
        return this.archiveFormat;
    }

    @Internal(value="Represented as part of downloadUrl and outputFile")
    @NotNull
    public final Provider<String> getPackageFileName$helm_plugin() {
        return this.packageFileName;
    }

    @Internal(value="Represented as part of sha256SumUrl and sha256SumFile")
    @NotNull
    public final Provider<String> getSha256SumFileName$helm_plugin() {
        return this.sha256SumFileName;
    }

    @Input
    @NotNull
    public final Provider<URI> getDownloadUrl() {
        return this.downloadUrl;
    }

    @Input
    @NotNull
    public final Provider<URI> getSha256SumUrl() {
        return this.sha256SumUrl;
    }

    @Internal(value="Represented as part of outputFile and sha256SumFile")
    @NotNull
    public final DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getOutputFile() {
        return this.outputFile;
    }

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getSha256SumFile() {
        return this.sha256SumFile;
    }

    @TaskAction
    public final void downloadClientPackage() {
        File sha256SumFile = this.getProject().file(this.sha256SumFile);
        File targetFile = this.getProject().file(this.outputFile);
        sha256SumFile.delete();
        targetFile.delete();
        Intrinsics.checkNotNull((Object)sha256SumFile);
        this.downloadSha256SumFile(sha256SumFile);
        try {
            String expectedDigest = this.readSha256DigestFromFile();
            File file = this.getProject().file(this.outputFile);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
            if (this.verifySha256Digest(expectedDigest, file)) {
                return;
            }
            Intrinsics.checkNotNull((Object)targetFile);
            this.downloadClientPackageFile(targetFile);
            if (!this.verifySha256Digest(expectedDigest, targetFile)) {
                throw new IllegalStateException("SHA-256 digest mismatch on downloaded file " + targetFile);
            }
        }
        catch (Exception ex) {
            this.getLogger().info("Deleting already-downloaded sha256sum file at {}", (Object)sha256SumFile);
            sha256SumFile.delete();
            if (targetFile.exists()) {
                this.getLogger().info("Deleting already-downloaded release package file at {}", (Object)targetFile);
                targetFile.delete();
            }
            throw ex;
        }
    }

    private final void downloadSha256SumFile(File sha256SumFile) {
        URI sha256SumUrl = (URI)this.sha256SumUrl.get();
        this.getLogger().info("Downloading sha256 sum file for Helm client v{} from {}", this.version.get(), (Object)sha256SumUrl);
        Intrinsics.checkNotNull((Object)sha256SumUrl);
        this.downloadFile(sha256SumUrl, sha256SumFile);
    }

    private final void downloadClientPackageFile(File targetFile) {
        URI downloadUrl = (URI)this.downloadUrl.get();
        this.getLogger().info("Downloading release package for Helm client v{} from {}", this.version.get(), (Object)downloadUrl);
        Intrinsics.checkNotNull((Object)downloadUrl);
        this.downloadFile(downloadUrl, targetFile);
    }

    private final boolean verifySha256Digest(String expectedDigest, File targetFile) {
        if (!targetFile.exists()) {
            return false;
        }
        this.getLogger().info("Calculating digest for file {}", (Object)targetFile);
        String actualDigest = DigestUtilsKt.calculateDigestHex$default(targetFile, "SHA-256", 0, 2, null);
        return StringsKt.equals((String)expectedDigest, (String)actualDigest, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadFile(URI url, File targetFile) {
        URLConnection uRLConnection;
        URLConnection $this$downloadFile_u24lambda_u245 = uRLConnection = url.toURL().openConnection();
        boolean bl = false;
        $this$downloadFile_u24lambda_u245.setConnectTimeout(30000);
        $this$downloadFile_u24lambda_u245.setReadTimeout(30000);
        $this$downloadFile_u24lambda_u245.connect();
        URLConnection connection = uRLConnection;
        long contentLength = connection.getContentLengthLong();
        targetFile.getParentFile().mkdirs();
        Closeable closeable = new BufferedOutputStream(new FileOutputStream(targetFile));
        Throwable throwable = null;
        try {
            BufferedOutputStream output = (BufferedOutputStream)closeable;
            boolean bl2 = false;
            int bufferSize = (int)Math.min(contentLength, 10240L);
            byte[] buffer = new byte[bufferSize];
            long totalBytesTransferred = 0L;
            long nextProgressThreshold = 0L;
            Closeable closeable2 = connection.getInputStream();
            Throwable throwable2 = null;
            try {
                InputStream input = (InputStream)closeable2;
                boolean bl3 = false;
                while (true) {
                    int bytesRead = input.read(buffer);
                    if (Thread.currentThread().isInterrupted()) {
                        throw new IOException("Download was interrupted");
                    }
                    if (bytesRead == -1) break;
                    output.write(buffer, 0, bytesRead);
                    if (!this.getLogger().isInfoEnabled() || (totalBytesTransferred += (long)bytesRead) < nextProgressThreshold) continue;
                    nextProgressThreshold = Math.min(contentLength, nextProgressThreshold + (long)262144);
                    double progress = (double)(totalBytesTransferred * (long)1000 / contentLength) / 10.0;
                    Logger logger = this.getLogger();
                    Object[] objectArray = new Object[3];
                    objectArray[0] = DataSizeFormatterKt.formatDataSize(totalBytesTransferred);
                    objectArray[1] = DataSizeFormatterKt.formatDataSize(contentLength);
                    String string = "%.1f";
                    Object[] objectArray2 = new Object[]{progress};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(format, *args)");
                    logger.info("Downloaded {} of {} ({})", objectArray);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String readSha256DigestFromFile() {
        File file = this.getProject().file(this.sha256SumFile);
        String targetFileName = (String)this.packageFileName.get();
        Intrinsics.checkNotNull((Object)file);
        String text = FilesKt.readText$default((File)file, null, (int)1, null);
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)text)).toString();
        Regex regex = new Regex("\\s+");
        int n = 0;
        List items = regex.split(charSequence, n);
        if (!(items.size() == 2 && ((String)items.get(0)).length() == 64)) {
            boolean $i$a$-require-HelmDownloadClientPackage$readSha256DigestFromFile$32 = false;
            String $i$a$-require-HelmDownloadClientPackage$readSha256DigestFromFile$32 = "Invalid contents of sha256sum file " + file;
            throw new IllegalArgumentException($i$a$-require-HelmDownloadClientPackage$readSha256DigestFromFile$32.toString());
        }
        if (!Intrinsics.areEqual(items.get(1), (Object)targetFileName)) {
            boolean bl = false;
            String string = "sha256sum file " + file + " does not describe target file " + targetFileName + " but a different file " + items.get(1);
            throw new IllegalArgumentException(string.toString());
        }
        return (String)items.get(0);
    }

    private static final String archiveFormat$lambda$0(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(in);
    }

    private static final String packageFileName$lambda$1(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(in);
    }

    private static final String sha256SumFileName$lambda$2(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(in);
    }

    private static final URI downloadUrl$lambda$3(HelmDownloadClientPackage this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        URI baseUrl2 = (URI)this$0.baseUrl.getOrNull();
        String packageFileName2 = (String)this$0.packageFileName.getOrNull();
        return baseUrl2 != null && packageFileName2 != null ? baseUrl2.resolve(packageFileName2) : null;
    }

    private static final URI sha256SumUrl$lambda$4(HelmDownloadClientPackage this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        URI baseUrl2 = (URI)this$0.baseUrl.getOrNull();
        String sha256SumFileName2 = (String)this$0.sha256SumFileName.getOrNull();
        return baseUrl2 != null && sha256SumFileName2 != null ? baseUrl2.resolve(sha256SumFileName2) : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/command/tasks/HelmDownloadClientPackage$Companion;", "", "()V", "BufferSize", "", "ConnectTimeoutMilliseconds", "ProgressChunkSize", "ReadTimeoutMilliseconds", "helm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

