/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.helm.command;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.jetbrains.annotations.NotNull;
import org.unbrokendome.gradle.plugins.helm.command.ConfigurableHelmServerOptions;
import org.unbrokendome.gradle.plugins.helm.command.HelmCommandsPlugin;
import org.unbrokendome.gradle.plugins.helm.command.HelmDownloadClientPlugin;
import org.unbrokendome.gradle.plugins.helm.command.internal.HelmServerOptionsKt;
import org.unbrokendome.gradle.plugins.helm.command.tasks.AbstractHelmCommandTask;
import org.unbrokendome.gradle.plugins.helm.command.tasks.AbstractHelmInstallationCommandTask;
import org.unbrokendome.gradle.plugins.helm.command.tasks.AbstractHelmServerCommandTask;
import org.unbrokendome.gradle.plugins.helm.command.tasks.AbstractHelmServerOperationCommandTask;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmDownloadClient;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmDownloadClientInternal;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmExtension;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmExtensionKt;
import org.unbrokendome.gradle.plugins.helm.dsl.Linting;
import org.unbrokendome.gradle.plugins.helm.dsl.LintingKt;
import org.unbrokendome.gradle.pluginutils.ProjectPropertiesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/command/HelmCommandsPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "helm-plugin"})
public final class HelmCommandsPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Linting linting;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HelmExtension helmExtension = HelmExtensionKt.createHelmExtension(project);
        project.getExtensions().add(HelmExtension.class, "helm", (Object)helmExtension);
        project.getRootProject().getPluginManager().apply(HelmDownloadClientPlugin.class);
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        Linting $this$apply_u24lambda_u240 = linting = LintingKt.createLinting$default(objectFactory, null, 1, null);
        boolean bl = false;
        $this$apply_u24lambda_u240.getEnabled().convention(ProjectPropertiesKt.booleanProviderFromProjectProperty((Project)project, (String)"helm.lint.enabled", (Boolean)true));
        $this$apply_u24lambda_u240.getStrict().convention(ProjectPropertiesKt.booleanProviderFromProjectProperty$default((Project)project, (String)"helm.lint.strict", null, (int)2, null));
        Intrinsics.checkNotNull((Object)helmExtension, (String)"null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        ((ExtensionAware)helmExtension).getExtensions().add(Linting.class, "lint", (Object)$this$apply_u24lambda_u240);
        HelmDownloadClient helmDownloadClient = helmExtension.getDownloadClient();
        Intrinsics.checkNotNull((Object)helmDownloadClient, (String)"null cannot be cast to non-null type org.unbrokendome.gradle.plugins.helm.dsl.HelmDownloadClientInternal");
        HelmDownloadClientInternal downloadClient = (HelmDownloadClientInternal)helmDownloadClient;
        project.getTasks().withType(AbstractHelmCommandTask.class, arg_0 -> HelmCommandsPlugin.apply$lambda$1((Function1)new Function1<AbstractHelmCommandTask, Unit>(helmExtension, downloadClient){
            final /* synthetic */ HelmExtension $helmExtension;
            final /* synthetic */ HelmDownloadClientInternal $downloadClient;
            {
                this.$helmExtension = $helmExtension;
                this.$downloadClient = $downloadClient;
                super(1);
            }

            public final void invoke(AbstractHelmCommandTask task) {
                task.getGlobalOptions$helm_plugin().set((Object)this.$helmExtension);
                Object[] objectArray = new Object[]{arg_0 -> apply.2.invoke$lambda$0(this.$downloadClient, arg_0)};
                task.dependsOn(objectArray);
                task.getDownloadedExecutable$helm_plugin().set(this.$downloadClient.getExecutable().map(arg_0 -> apply.2.invoke$lambda$1(apply.2.INSTANCE, arg_0)));
            }

            private static final Set invoke$lambda$0(HelmDownloadClientInternal $downloadClient, Task it) {
                Intrinsics.checkNotNullParameter((Object)$downloadClient, (String)"$downloadClient");
                return SetsKt.setOfNotNull((Object)$downloadClient.getExtractClientTask().getOrNull());
            }

            private static final String invoke$lambda$1(Function1 $tmp0, Object in) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(in);
            }
        }, arg_0));
        project.getTasks().withType(AbstractHelmServerCommandTask.class, arg_0 -> HelmCommandsPlugin.apply$lambda$2((Function1)new Function1<AbstractHelmServerCommandTask, Unit>(helmExtension){
            final /* synthetic */ HelmExtension $helmExtension;
            {
                this.$helmExtension = $helmExtension;
                super(1);
            }

            public final void invoke(AbstractHelmServerCommandTask task) {
                Intrinsics.checkNotNull((Object)task);
                ConfigurableHelmServerOptions configurableHelmServerOptions = task;
                HelmExtension helmExtension = this.$helmExtension;
                Intrinsics.checkNotNull((Object)helmExtension, (String)"null cannot be cast to non-null type org.unbrokendome.gradle.plugins.helm.command.ConfigurableHelmServerOptions");
                HelmServerOptionsKt.conventionsFrom(configurableHelmServerOptions, helmExtension);
            }
        }, arg_0));
        project.getTasks().withType(AbstractHelmServerOperationCommandTask.class, arg_0 -> HelmCommandsPlugin.apply$lambda$3((Function1)new Function1<AbstractHelmServerOperationCommandTask, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(AbstractHelmServerOperationCommandTask task) {
                task.getDryRun().convention(ProjectPropertiesKt.booleanProviderFromProjectProperty$default((Project)this.$project, (String)"helm.dryRun", null, (int)2, null));
                task.getNoHooks().convention(ProjectPropertiesKt.booleanProviderFromProjectProperty$default((Project)this.$project, (String)"helm.noHooks", null, (int)2, null));
                task.getRemoteTimeout().convention(ProjectPropertiesKt.durationProviderFromProjectProperty$default((Project)this.$project, (String)"helm.remoteTimeout", null, (int)2, null));
            }
        }, arg_0));
        project.getTasks().withType(AbstractHelmInstallationCommandTask.class, arg_0 -> HelmCommandsPlugin.apply$lambda$4((Function1)new Function1<AbstractHelmInstallationCommandTask, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(AbstractHelmInstallationCommandTask task) {
                task.getAtomic().convention(ProjectPropertiesKt.booleanProviderFromProjectProperty$default((Project)this.$project, (String)"helm.atomic", null, (int)2, null));
                task.getWait().convention(ProjectPropertiesKt.booleanProviderFromProjectProperty$default((Project)this.$project, (String)"helm.wait", null, (int)2, null));
                task.getWaitForJobs().convention(ProjectPropertiesKt.booleanProviderFromProjectProperty$default((Project)this.$project, (String)"helm.waitForJobs", null, (int)2, null));
            }
        }, arg_0));
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

