/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.helm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.Directory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.unbrokendome.gradle.plugins.helm.HelmPlugin;
import org.unbrokendome.gradle.plugins.helm.command.HelmCommandsPlugin;
import org.unbrokendome.gradle.plugins.helm.command.tasks.AbstractHelmInstallationCommandTask;
import org.unbrokendome.gradle.plugins.helm.command.tasks.HelmUpdateRepositories;
import org.unbrokendome.gradle.plugins.helm.dsl.Filtering;
import org.unbrokendome.gradle.plugins.helm.dsl.FilteringKt;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmChart;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmChartKt;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmExtension;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmExtensionInternal;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmRepository;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmRepositoryHandler;
import org.unbrokendome.gradle.plugins.helm.dsl.HelmRepositoryHandlerKt;
import org.unbrokendome.gradle.plugins.helm.dsl.Linting;
import org.unbrokendome.gradle.plugins.helm.dsl.LintingKt;
import org.unbrokendome.gradle.plugins.helm.dsl.credentials.CertificateCredentials;
import org.unbrokendome.gradle.plugins.helm.dsl.credentials.CredentialsContainerKt;
import org.unbrokendome.gradle.plugins.helm.dsl.credentials.PasswordCredentials;
import org.unbrokendome.gradle.plugins.helm.dsl.dependencies.ChartDependencyHandler;
import org.unbrokendome.gradle.plugins.helm.dsl.dependencies.ChartDependencyHandlerKt;
import org.unbrokendome.gradle.plugins.helm.dsl.internal.ExtensionAccessorsKt;
import org.unbrokendome.gradle.plugins.helm.rules.AddRepositoryTaskRule;
import org.unbrokendome.gradle.plugins.helm.rules.AddRepositoryTaskRuleKt;
import org.unbrokendome.gradle.plugins.helm.rules.ChartDependenciesConfigurationRule;
import org.unbrokendome.gradle.plugins.helm.rules.ChartDirArtifactRule;
import org.unbrokendome.gradle.plugins.helm.rules.ChartDirArtifactRuleKt;
import org.unbrokendome.gradle.plugins.helm.rules.ChartPackagedArtifactRule;
import org.unbrokendome.gradle.plugins.helm.rules.ChartPackagedArtifactRuleKt;
import org.unbrokendome.gradle.plugins.helm.rules.CollectChartDependenciesTaskRule;
import org.unbrokendome.gradle.plugins.helm.rules.CollectChartSourcesTaskRule;
import org.unbrokendome.gradle.plugins.helm.rules.FilterChartSourcesTaskRule;
import org.unbrokendome.gradle.plugins.helm.rules.LintTaskRule;
import org.unbrokendome.gradle.plugins.helm.rules.LintWithConfigurationTaskRule;
import org.unbrokendome.gradle.plugins.helm.rules.MainChartRule;
import org.unbrokendome.gradle.plugins.helm.rules.PackageTaskRule;
import org.unbrokendome.gradle.plugins.helm.rules.PackageTaskRuleKt;
import org.unbrokendome.gradle.plugins.helm.rules.RenderAllTaskRule;
import org.unbrokendome.gradle.plugins.helm.rules.RenderAllTaskRuleKt;
import org.unbrokendome.gradle.plugins.helm.rules.RenderTaskRule;
import org.unbrokendome.gradle.plugins.helm.rules.UpdateDependenciesTaskRule;
import org.unbrokendome.gradle.pluginutils.ProjectPropertiesKt;
import org.unbrokendome.gradle.pluginutils.ProviderExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\f\u0010\b\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\t\u001a\u00020\u0005*\u00020\u0002H\u0002J\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u0002H\u0002J\u0014\u0010\r\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0014\u0010\u000e\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u001c\u0010\u000f\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0002H\u0002J\f\u0010\u0017\u001a\u00020\u0005*\u00020\u0002H\u0002J\u0014\u0010\u0018\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/HelmPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "configureRepositories", "configureCharts", "configureFiltering", "createChartsExtension", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lorg/unbrokendome/gradle/plugins/helm/dsl/HelmChart;", "createDependenciesExtension", "createExtensions", "createFilteringExtension", "helmExtension", "Lorg/unbrokendome/gradle/plugins/helm/dsl/HelmExtension;", "createLintingExtension", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "createRepositoriesExtension", "Lorg/unbrokendome/gradle/plugins/helm/dsl/HelmRepositoryHandler;", "createRepositoriesFromProjectProperties", "createRepositoryFromProjectProperties", "name", "", "Companion", "helm-plugin"})
@SourceDebugExtension(value={"SMAP\nHelmPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmPlugin.kt\norg/unbrokendome/gradle/plugins/helm/HelmPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n766#2:308\n857#2,2:309\n1603#2,9:311\n1855#2:320\n1856#2:322\n1612#2:323\n1855#2,2:324\n1#3:321\n*S KotlinDebug\n*F\n+ 1 HelmPlugin.kt\norg/unbrokendome/gradle/plugins/helm/HelmPlugin\n*L\n269#1:308\n269#1:309,2\n270#1:311,9\n270#1:320\n270#1:322\n270#1:323\n272#1:324,2\n270#1:321\n*E\n"})
public final class HelmPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String addRepositoriesTaskName = "helmAddRepositories";
    @NotNull
    public static final String updateRepositoriesTaskName = "helmUpdateRepositories";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getPlugins().apply(HelmCommandsPlugin.class);
        this.configureRepositories(project);
        this.configureFiltering(project);
        this.configureCharts(project);
    }

    private final void configureRepositories(Project project) {
        HelmRepositoryHandler repositories = this.createRepositoriesExtension(project);
        TaskContainer taskContainer = project.getTasks();
        TaskContainer taskContainer2 = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"getTasks(...)");
        taskContainer.addRule((Rule)new AddRepositoryTaskRule(taskContainer2, (NamedDomainObjectCollection<HelmRepository>)((NamedDomainObjectCollection)repositories)));
        TaskProvider addRepositoriesTask2 = project.getTasks().register(addRepositoriesTaskName, arg_0 -> HelmPlugin.configureRepositories$lambda$0((Function1)new Function1<Task, Unit>(repositories, project){
            final /* synthetic */ HelmRepositoryHandler $repositories;
            final /* synthetic */ Project $project;
            {
                this.$repositories = $repositories;
                this.$project = $project;
                super(1);
            }

            public final void invoke(Task task) {
                task.setGroup("helm");
                task.setDescription("Registers all configured Helm repositories.");
                Object[] objectArray = new Object[]{arg_0 -> configureRepositories.addRepositoriesTask.1.invoke$lambda$1(this.$repositories, this.$project, arg_0)};
                task.dependsOn(objectArray);
            }

            /*
             * WARNING - void declaration
             */
            private static final Set invoke$lambda$1(HelmRepositoryHandler $repositories, Project $project, Task it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$repositories, (String)"$repositories");
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                Iterable $this$map$iv = (Iterable)((Object)$repositories);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void repository;
                    HelmRepository helmRepository = (HelmRepository)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    TaskContainer taskContainer = $project.getTasks();
                    Intrinsics.checkNotNull((Object)repository);
                    collection.add(taskContainer.getByName(AddRepositoryTaskRuleKt.getRegisterTaskName((HelmRepository)repository)));
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
        }, arg_0));
        TaskProvider updateRepositoriesTask2 = project.getTasks().register(updateRepositoriesTaskName, HelmUpdateRepositories.class, arg_0 -> HelmPlugin.configureRepositories$lambda$1((Function1)new Function1<HelmUpdateRepositories, Unit>((TaskProvider<Task>)addRepositoriesTask2, project, repositories){
            final /* synthetic */ TaskProvider<Task> $addRepositoriesTask;
            final /* synthetic */ Project $project;
            final /* synthetic */ HelmRepositoryHandler $repositories;
            {
                this.$addRepositoriesTask = $addRepositoriesTask;
                this.$project = $project;
                this.$repositories = $repositories;
                super(1);
            }

            public final void invoke(HelmUpdateRepositories task) {
                Object[] objectArray = new Object[]{this.$addRepositoriesTask};
                task.dependsOn(objectArray);
                task.getRepositoryNames().set(this.$project.provider(() -> configureRepositories.updateRepositoriesTask.1.invoke$lambda$0(this.$repositories)));
            }

            private static final SortedSet invoke$lambda$0(HelmRepositoryHandler $repositories) {
                Intrinsics.checkNotNullParameter((Object)$repositories, (String)"$repositories");
                return $repositories.getNames();
            }
        }, arg_0));
        project.getTasks().withType(AbstractHelmInstallationCommandTask.class, arg_0 -> HelmPlugin.configureRepositories$lambda$2((Function1)new Function1<AbstractHelmInstallationCommandTask, Unit>((TaskProvider<HelmUpdateRepositories>)updateRepositoriesTask2){
            final /* synthetic */ TaskProvider<HelmUpdateRepositories> $updateRepositoriesTask;
            {
                this.$updateRepositoriesTask = $updateRepositoriesTask;
                super(1);
            }

            public final void invoke(AbstractHelmInstallationCommandTask task) {
                Object[] objectArray = new Object[]{arg_0 -> configureRepositories.1.invoke$lambda$0(task, this.$updateRepositoriesTask, arg_0)};
                task.dependsOn(objectArray);
            }

            private static final Set invoke$lambda$0(AbstractHelmInstallationCommandTask $task, TaskProvider $updateRepositoriesTask, Task it) {
                Object object = $task.getChart().getOrElse((Object)"");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
                return StringsKt.contains$default((CharSequence)((CharSequence)object), (char)'/', (boolean)false, (int)2, null) ? SetsKt.setOf((Object)$updateRepositoriesTask.get()) : SetsKt.emptySet();
            }
        }, arg_0));
    }

    private final void configureCharts(Project $this$configureCharts) {
        NamedDomainObjectContainer<HelmChart> charts = this.createChartsExtension($this$configureCharts);
        charts.all(arg_0 -> HelmPlugin.configureCharts$lambda$3((Function1)new Function1<HelmChart, Unit>(this, $this$configureCharts){
            final /* synthetic */ HelmPlugin this$0;
            final /* synthetic */ Project $this_configureCharts;
            {
                this.this$0 = $receiver;
                this.$this_configureCharts = $receiver2;
                super(1);
            }

            public final void invoke(HelmChart chart) {
                Intrinsics.checkNotNull((Object)chart);
                HelmPlugin.access$createExtensions(this.this$0, chart, this.$this_configureCharts);
            }
        }, arg_0));
        charts.addRule((Rule)new MainChartRule($this$configureCharts, charts));
        TaskContainer $this$configureCharts_u24lambda_u244 = $this$configureCharts.getTasks();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$configureCharts_u24lambda_u244);
        $this$configureCharts_u24lambda_u244.addRule((Rule)new FilterChartSourcesTaskRule($this$configureCharts_u24lambda_u244, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        $this$configureCharts_u24lambda_u244.addRule((Rule)new CollectChartDependenciesTaskRule($this$configureCharts_u24lambda_u244, charts));
        $this$configureCharts_u24lambda_u244.addRule((Rule)new CollectChartSourcesTaskRule($this$configureCharts_u24lambda_u244, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        $this$configureCharts_u24lambda_u244.addRule((Rule)new UpdateDependenciesTaskRule($this$configureCharts_u24lambda_u244, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        $this$configureCharts_u24lambda_u244.addRule((Rule)new LintTaskRule($this$configureCharts_u24lambda_u244, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        $this$configureCharts_u24lambda_u244.addRule((Rule)new LintWithConfigurationTaskRule($this$configureCharts_u24lambda_u244, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        $this$configureCharts_u24lambda_u244.addRule((Rule)new PackageTaskRule($this$configureCharts_u24lambda_u244, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        $this$configureCharts_u24lambda_u244.addRule((Rule)new RenderTaskRule($this$configureCharts_u24lambda_u244, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        $this$configureCharts_u24lambda_u244.addRule((Rule)new RenderAllTaskRule($this$configureCharts_u24lambda_u244, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        $this$configureCharts.getTasks().register("helmPackage", arg_0 -> HelmPlugin.configureCharts$lambda$5((Function1)new Function1<Task, Unit>(charts, $this$configureCharts){
            final /* synthetic */ NamedDomainObjectContainer<HelmChart> $charts;
            final /* synthetic */ Project $this_configureCharts;
            {
                this.$charts = $charts;
                this.$this_configureCharts = $receiver;
                super(1);
            }

            public final void invoke(Task task) {
                task.setGroup("helm");
                task.setDescription("Packages all Helm charts.");
                Object[] objectArray = new Object[]{arg_0 -> configureCharts.3.invoke$lambda$1(this.$charts, this.$this_configureCharts, arg_0)};
                task.dependsOn(objectArray);
            }

            /*
             * WARNING - void declaration
             */
            private static final Set invoke$lambda$1(NamedDomainObjectContainer $charts, Project $this_configureCharts, Task it) {
                void destination$iv;
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)$charts, (String)"$charts");
                Intrinsics.checkNotNullParameter((Object)$this_configureCharts, (String)"$this_configureCharts");
                Iterable iterable = (Iterable)$charts;
                Collection collection = new LinkedHashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void chart;
                    HelmChart helmChart = (HelmChart)item$iv;
                    void var10_10 = destination$iv;
                    boolean bl = false;
                    TaskContainer taskContainer = $this_configureCharts.getTasks();
                    Intrinsics.checkNotNull((Object)chart);
                    var10_10.add(taskContainer.getByName(PackageTaskRuleKt.getPackageTaskName((HelmChart)chart)));
                }
                return (Set)destination$iv;
            }
        }, arg_0));
        $this$configureCharts.getTasks().register("helmRender", arg_0 -> HelmPlugin.configureCharts$lambda$6((Function1)new Function1<Task, Unit>(charts, $this$configureCharts){
            final /* synthetic */ NamedDomainObjectContainer<HelmChart> $charts;
            final /* synthetic */ Project $this_configureCharts;
            {
                this.$charts = $charts;
                this.$this_configureCharts = $receiver;
                super(1);
            }

            public final void invoke(Task task) {
                task.setGroup("helm");
                task.setDescription("Renders all renderings of all Helm charts.");
                Object[] objectArray = new Object[]{arg_0 -> configureCharts.4.invoke$lambda$1(this.$charts, this.$this_configureCharts, arg_0)};
                task.dependsOn(objectArray);
            }

            /*
             * WARNING - void declaration
             */
            private static final Set invoke$lambda$1(NamedDomainObjectContainer $charts, Project $this_configureCharts, Task it) {
                void destination$iv;
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)$charts, (String)"$charts");
                Intrinsics.checkNotNullParameter((Object)$this_configureCharts, (String)"$this_configureCharts");
                Iterable iterable = (Iterable)$charts;
                Collection collection = new LinkedHashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void chart;
                    HelmChart helmChart = (HelmChart)item$iv;
                    void var10_10 = destination$iv;
                    boolean bl = false;
                    TaskContainer taskContainer = $this_configureCharts.getTasks();
                    Intrinsics.checkNotNull((Object)chart);
                    var10_10.add(taskContainer.getByName(RenderAllTaskRuleKt.getRenderAllTaskName((HelmChart)chart)));
                }
                return (Set)destination$iv;
            }
        }, arg_0));
        ConfigurationContainer configurationContainer = $this$configureCharts.getConfigurations();
        ConfigurationContainer configurationContainer2 = $this$configureCharts.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer2, (String)"getConfigurations(...)");
        configurationContainer.addRule((Rule)new ChartDependenciesConfigurationRule(configurationContainer2, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        ConfigurationContainer configurationContainer3 = $this$configureCharts.getConfigurations();
        ConfigurationContainer configurationContainer4 = $this$configureCharts.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer4, (String)"getConfigurations(...)");
        TaskContainer taskContainer = $this$configureCharts.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        configurationContainer3.addRule((Rule)new ChartDirArtifactRule(configurationContainer4, taskContainer, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        ConfigurationContainer configurationContainer5 = $this$configureCharts.getConfigurations();
        ConfigurationContainer configurationContainer6 = $this$configureCharts.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer6, (String)"getConfigurations(...)");
        TaskContainer taskContainer2 = $this$configureCharts.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"getTasks(...)");
        configurationContainer5.addRule((Rule)new ChartPackagedArtifactRule(configurationContainer6, taskContainer2, (NamedDomainObjectCollection<HelmChart>)((NamedDomainObjectCollection)charts)));
        $this$configureCharts.afterEvaluate(arg_0 -> HelmPlugin.configureCharts$lambda$7((Function1)new Function1<Project, Unit>(this, charts, $this$configureCharts){
            final /* synthetic */ HelmPlugin this$0;
            final /* synthetic */ NamedDomainObjectContainer<HelmChart> $charts;
            final /* synthetic */ Project $this_configureCharts;
            {
                this.this$0 = $receiver;
                this.$charts = $charts;
                this.$this_configureCharts = $receiver2;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Project p) {
                void $this$forEach$iv;
                Intrinsics.checkNotNull((Object)p);
                HelmPlugin.access$createRepositoriesFromProjectProperties(this.this$0, p);
                this.$charts.findByName("main");
                Iterable iterable = (Iterable)this.$charts;
                Project project = this.$this_configureCharts;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HelmChart chart = (HelmChart)element$iv;
                    boolean bl = false;
                    ConfigurationContainer configurationContainer = project.getConfigurations();
                    Intrinsics.checkNotNull((Object)chart);
                    configurationContainer.findByName(ChartDirArtifactRuleKt.getDirArtifactConfigurationName(chart));
                    project.getConfigurations().findByName(ChartPackagedArtifactRuleKt.getPackagedArtifactConfigurationName(chart));
                }
            }
        }, arg_0));
    }

    private final HelmRepositoryHandler createRepositoriesExtension(Project $this$createRepositoriesExtension) {
        HelmRepositoryHandler helmRepositoryHandler;
        HelmRepositoryHandler $this$createRepositoriesExtension_u24lambda_u248 = helmRepositoryHandler = HelmRepositoryHandlerKt.helmRepositoryHandler($this$createRepositoriesExtension);
        boolean bl = false;
        HelmExtension helmExtension = ExtensionAccessorsKt.getHelm($this$createRepositoriesExtension);
        Intrinsics.checkNotNull((Object)helmExtension, (String)"null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        ((ExtensionAware)helmExtension).getExtensions().add("repositories", (Object)$this$createRepositoriesExtension_u24lambda_u248);
        return helmRepositoryHandler;
    }

    private final NamedDomainObjectContainer<HelmChart> createChartsExtension(Project $this$createChartsExtension) {
        NamedDomainObjectContainer<HelmChart> namedDomainObjectContainer;
        HelmExtension helmExtension = ExtensionAccessorsKt.getHelm($this$createChartsExtension);
        Intrinsics.checkNotNull((Object)helmExtension, (String)"null cannot be cast to non-null type org.unbrokendome.gradle.plugins.helm.dsl.HelmExtensionInternal");
        HelmExtensionInternal helm = (HelmExtensionInternal)helmExtension;
        Provider provider = (Provider)helm.getOutputDir();
        Provider provider2 = (Provider)helm.getRenderOutputDir();
        Provider provider3 = helm.getTmpDir().dir("filtered");
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"dir(...)");
        Provider provider4 = helm.getTmpDir().dir("dependencies");
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"dir(...)");
        NamedDomainObjectContainer<HelmChart> $this$createChartsExtension_u24lambda_u249 = namedDomainObjectContainer = HelmChartKt.helmChartContainer($this$createChartsExtension, (Provider<Directory>)provider, (Provider<Directory>)provider2, (Provider<Directory>)provider3, (Provider<Directory>)provider4);
        boolean bl = false;
        ((ExtensionAware)helm).getExtensions().add("charts", $this$createChartsExtension_u24lambda_u249);
        return namedDomainObjectContainer;
    }

    private final void configureFiltering(Project $this$configureFiltering) {
        Filtering filtering;
        ObjectFactory objectFactory = $this$configureFiltering.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        Filtering $this$configureFiltering_u24lambda_u2410 = filtering = FilteringKt.createFiltering$default(objectFactory, null, 1, null);
        boolean bl = false;
        $this$configureFiltering_u24lambda_u2410.getEnabled().convention(ProjectPropertiesKt.booleanProviderFromProjectProperty((Project)$this$configureFiltering, (String)"helm.filtering.enabled", (Boolean)true));
        Filtering filtering2 = filtering;
        HelmExtension helmExtension = ExtensionAccessorsKt.getHelm($this$configureFiltering);
        Intrinsics.checkNotNull((Object)helmExtension, (String)"null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        ((ExtensionAware)helmExtension).getExtensions().add(Filtering.class, "filtering", (Object)filtering2);
    }

    private final void createExtensions(HelmChart $this$createExtensions, Project project) {
        this.createFilteringExtension($this$createExtensions, project, ExtensionAccessorsKt.getHelm(project));
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        this.createLintingExtension($this$createExtensions, objectFactory, ExtensionAccessorsKt.getHelm(project));
        this.createDependenciesExtension($this$createExtensions, project);
    }

    private final void createFilteringExtension(HelmChart $this$createFilteringExtension, Project project, HelmExtension helmExtension) {
        Intrinsics.checkNotNull((Object)$this$createFilteringExtension, (String)"null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        ExtensionContainer extensionContainer = ((ExtensionAware)$this$createFilteringExtension).getExtensions();
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        extensionContainer.add(Filtering.class, "filtering", (Object)FilteringKt.createFiltering(objectFactory, ExtensionAccessorsKt.getFiltering(helmExtension)));
    }

    private final void createLintingExtension(HelmChart $this$createLintingExtension, ObjectFactory objectFactory, HelmExtension helmExtension) {
        Intrinsics.checkNotNull((Object)$this$createLintingExtension, (String)"null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        ((ExtensionAware)$this$createLintingExtension).getExtensions().add(Linting.class, "lint", (Object)LintingKt.createLinting(objectFactory, ExtensionAccessorsKt.getLint(helmExtension)));
    }

    private final void createDependenciesExtension(HelmChart $this$createDependenciesExtension, Project project) {
        Intrinsics.checkNotNull((Object)$this$createDependenciesExtension, (String)"null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        ((ExtensionAware)$this$createDependenciesExtension).getExtensions().add(ChartDependencyHandler.class, "dependencies", (Object)ChartDependencyHandlerKt.createChartDependencyHandler($this$createDependenciesExtension, project));
    }

    /*
     * WARNING - void declaration
     */
    private final void createRepositoriesFromProjectProperties(Project $this$createRepositoriesFromProjectProperties) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$createRepositoriesFromProjectProperties.getProperties().keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!StringsKt.startsWith$default((String)it, (String)"helm.repositories.", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            char[] cArray = new char[]{'.'};
            if ((String)CollectionsKt.firstOrNull((List)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)2)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String repositoryName = (String)element$iv;
            boolean bl = false;
            this.createRepositoryFromProjectProperties($this$createRepositoriesFromProjectProperties, repositoryName);
        }
    }

    private final void createRepositoryFromProjectProperties(Project $this$createRepositoryFromProjectProperties, String name) {
        String prefix = "helm.repositories." + name;
        ExtensionAccessorsKt.getRepositories(ExtensionAccessorsKt.getHelm($this$createRepositoryFromProjectProperties)).create(name, arg_0 -> HelmPlugin.createRepositoryFromProjectProperties$lambda$14((Function1)new Function1<HelmRepository, Unit>($this$createRepositoryFromProjectProperties, prefix){
            final /* synthetic */ Project $this_createRepositoryFromProjectProperties;
            final /* synthetic */ String $prefix;
            {
                this.$this_createRepositoryFromProjectProperties = $receiver;
                this.$prefix = $prefix;
                super(1);
            }

            public final void invoke(HelmRepository repository) {
                repository.getUrl().set(ProviderExtensionsKt.toUri((Provider)ProjectPropertiesKt.providerFromProjectProperty$default((Project)this.$this_createRepositoryFromProjectProperties, (String)(this.$prefix + ".url"), null, (boolean)false, (int)6, null)));
                if (this.$this_createRepositoryFromProjectProperties.hasProperty(this.$prefix + ".credentials.username")) {
                    repository.credentials(arg_0 -> createRepositoryFromProjectProperties.1.invoke$lambda$0((Function1)new Function1<PasswordCredentials, Unit>(this.$this_createRepositoryFromProjectProperties, this.$prefix){
                        final /* synthetic */ Project $this_createRepositoryFromProjectProperties;
                        final /* synthetic */ String $prefix;
                        {
                            this.$this_createRepositoryFromProjectProperties = $receiver;
                            this.$prefix = $prefix;
                            super(1);
                        }

                        public final void invoke(PasswordCredentials cred) {
                            cred.getUsername().set(ProjectPropertiesKt.providerFromProjectProperty$default((Project)this.$this_createRepositoryFromProjectProperties, (String)(this.$prefix + ".credentials.username"), null, (boolean)false, (int)6, null));
                            cred.getPassword().set(ProjectPropertiesKt.providerFromProjectProperty$default((Project)this.$this_createRepositoryFromProjectProperties, (String)(this.$prefix + ".credentials.password"), null, (boolean)false, (int)6, null));
                        }
                    }, arg_0));
                } else if (this.$this_createRepositoryFromProjectProperties.hasProperty(this.$prefix + ".credentials.certificateFile")) {
                    Intrinsics.checkNotNull((Object)repository);
                    CredentialsContainerKt.credentials(repository, Reflection.getOrCreateKotlinClass(CertificateCredentials.class), (Function1)new Function1<CertificateCredentials, Unit>(this.$this_createRepositoryFromProjectProperties, this.$prefix){
                        final /* synthetic */ Project $this_createRepositoryFromProjectProperties;
                        final /* synthetic */ String $prefix;
                        {
                            this.$this_createRepositoryFromProjectProperties = $receiver;
                            this.$prefix = $prefix;
                            super(1);
                        }

                        public final void invoke(@NotNull CertificateCredentials $this$credentials) {
                            Intrinsics.checkNotNullParameter((Object)$this$credentials, (String)"$this$credentials");
                            $this$credentials.getCertificateFile().set(ProjectPropertiesKt.fileProviderFromProjectProperty$default((Project)this.$this_createRepositoryFromProjectProperties, (String)(this.$prefix + ".credentials.certificateFile"), null, (boolean)false, (int)6, null));
                            $this$credentials.getKeyFile().set(ProjectPropertiesKt.fileProviderFromProjectProperty$default((Project)this.$this_createRepositoryFromProjectProperties, (String)(this.$prefix + ".credentials.keyFile"), null, (boolean)false, (int)6, null));
                        }
                    });
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private static final void configureRepositories$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureRepositories$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureRepositories$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureCharts$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureCharts$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureCharts$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureCharts$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createRepositoryFromProjectProperties$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$createExtensions(HelmPlugin $this, HelmChart $receiver, Project project) {
        $this.createExtensions($receiver, project);
    }

    public static final /* synthetic */ void access$createRepositoriesFromProjectProperties(HelmPlugin $this, Project $receiver) {
        $this.createRepositoriesFromProjectProperties($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/HelmPlugin$Companion;", "", "()V", "addRepositoriesTaskName", "", "updateRepositoriesTaskName", "helm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

