/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.testsets.internal;

import com.google.common.eventbus.Subscribe;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.unbrokendome.gradle.plugins.testsets.dsl.TestSet;
import org.unbrokendome.gradle.plugins.testsets.internal.events.TestSetAddedEvent;

public class EclipseClasspathListener {
    private final Project project;

    public EclipseClasspathListener(Project project) {
        this.project = project;
    }

    @Subscribe
    public void testSetAdded(TestSetAddedEvent event) {
        EclipseModel eclipseModel = (EclipseModel)this.project.getExtensions().findByType(EclipseModel.class);
        if (eclipseModel != null) {
            Configuration testSetRuntimeConfiguration;
            TestSet testSet = event.getTestSet();
            ConfigurationContainer configurations = this.project.getConfigurations();
            EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
            Configuration testSetCompileConfiguration = (Configuration)configurations.findByName(testSet.getCompileConfigurationName());
            if (testSetCompileConfiguration != null) {
                eclipseClasspath.getPlusConfigurations().add(testSetCompileConfiguration);
            }
            if ((testSetRuntimeConfiguration = (Configuration)configurations.findByName(testSet.getRuntimeConfigurationName())) != null) {
                eclipseClasspath.getPlusConfigurations().add(testSetRuntimeConfiguration);
            }
        }
    }
}

