/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.testsets.internal;

import com.google.common.eventbus.Subscribe;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.unbrokendome.gradle.plugins.testsets.dsl.TestSet;
import org.unbrokendome.gradle.plugins.testsets.internal.events.TestSetAddedEvent;

public class ArtifactListener {
    private final Project project;

    public ArtifactListener(Project project) {
        this.project = project;
    }

    @Subscribe
    public void testSetAdded(TestSetAddedEvent event) {
        final TestSet testSet = event.getTestSet();
        this.project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                if (testSet.isCreateArtifact()) {
                    Configuration artifactConfiguration = (Configuration)project.getConfigurations().maybeCreate(testSet.getArtifactConfigurationName());
                    Jar jarTask = (Jar)project.getTasks().findByName(testSet.getJarTaskName());
                    ArchivePublishArtifact artifact = new ArchivePublishArtifact((AbstractArchiveTask)jarTask);
                    artifact.setClassifier(testSet.getClassifier());
                    artifactConfiguration.getArtifacts().add((Object)artifact);
                }
            }
        });
    }
}

