/*
 * Decompiled with CFR 0.152.
 */
package org.ukiuni.monitorremotejobplugin.monitorremotejob;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.PasswordParameterValue;
import hudson.model.StringParameterValue;
import hudson.model.TextParameterValue;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.ukiuni.callOtherJenkins.CallOtherJenkins.JenkinsRemoteIF;
import org.ukiuni.callOtherJenkins.CallOtherJenkins.util.ReplaceUtil;
import org.ukiuni.callOtherJenkins.CallOtherJenkins.util.TimeParser;

public class MonitorRemoteJobBuilder
extends Builder {
    private final String hostName;
    private final String jobName;
    private final String timeBefore;
    private final String userName;
    private final String password;
    private final boolean useSSL;

    @DataBoundConstructor
    public MonitorRemoteJobBuilder(String hostName, String jobName, String timeBefore, String userName, String password, boolean useSSL) {
        this.hostName = hostName;
        this.jobName = jobName;
        this.timeBefore = timeBefore;
        this.userName = userName;
        this.password = password;
        this.useSSL = useSSL;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getTimeBefore() {
        return this.timeBefore;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        try {
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            if (null != parameters) {
                for (ParameterValue parameterValue : parameters.getParameters()) {
                    if (parameterValue instanceof TextParameterValue) {
                        parameterMap.put(parameterValue.getName(), ((TextParameterValue)parameterValue).value);
                    }
                    if (parameterValue instanceof StringParameterValue) {
                        parameterMap.put(parameterValue.getName(), ((StringParameterValue)parameterValue).value);
                    }
                    if (!(parameterValue instanceof PasswordParameterValue)) continue;
                    parameterMap.put(parameterValue.getName(), ((PasswordParameterValue)parameterValue).getValue().getPlainText());
                }
            }
            JenkinsRemoteIF jenkinsRemoteIF = new JenkinsRemoteIF(this.getHostName(), this.getJobName(), this.getUseSSL());
            if (null != this.getUserName() && !"".equals(this.getUserName())) {
                jenkinsRemoteIF.setAuthentication(ReplaceUtil.replaceParam(this.getUserName(), parameterMap), ReplaceUtil.replaceParam(this.getPassword(), parameterMap));
            }
            JenkinsRemoteIF.LastCompleteBuild lastCompleteBuild = jenkinsRemoteIF.loadLastCompleteBuild(listener.getLogger());
            listener.getLogger().println("build number " + lastCompleteBuild.number + " :success ? " + lastCompleteBuild.success);
            Date since = new Date(new Date().getTime() - TimeParser.parse(this.timeBefore));
            return since.before(lastCompleteBuild.date);
        }
        catch (Exception e) {
            e.printStackTrace(listener.getLogger());
            return false;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckTimeBefore(@QueryParameter String value) throws IOException, ServletException {
            try {
                TimeParser.parse(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Please enter number+kind like \"1d\", like \"1m\"");
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Monitor remote jenkins job";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

