/*
 * Decompiled with CFR 0.152.
 */
package org.udoo.udooblulib.utils;

import java.util.Observable;
import java.util.Observer;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.udoo.udooblulib.exceptions.UdooBluException;

public class SeqObserverQueue<T>
extends Observable
implements Runnable {
    private BlockingQueue<Callable> tBlockingDeque;
    private static final String TAG = "SeqObserverQueue";
    private ExecutorService mExecutorService;
    private AtomicBoolean mBusy;
    private Queue<Observer> observers;
    private boolean changed;
    private int mWAIT;

    public SeqObserverQueue(BlockingQueue<Callable> tBlockingQeque) {
        this.init(tBlockingQeque, 300);
    }

    public SeqObserverQueue(BlockingQueue<Callable> tBlockingQeque, int wait) {
        this.init(tBlockingQeque, wait);
    }

    private void init(BlockingQueue<Callable> tBlockingQeque, int wait) {
        this.tBlockingDeque = tBlockingQeque;
        this.mExecutorService = Executors.newSingleThreadExecutor();
        this.mBusy = new AtomicBoolean(false);
        this.observers = new ConcurrentLinkedQueue<Observer>();
        this.changed = false;
        this.mWAIT = wait;
    }

    @Override
    public void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException("observer == null");
        }
        this.observers.add(observer);
    }

    @Override
    protected void clearChanged() {
        this.changed = false;
    }

    @Override
    public int countObservers() {
        return this.observers.size();
    }

    @Override
    public synchronized void deleteObserver(Observer observer) {
        this.observers.remove(observer);
    }

    @Override
    public synchronized void deleteObservers() {
        this.observers.clear();
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyObservers(Object data) {
        int size = 0;
        SeqObserverQueue seqObserverQueue = this;
        synchronized (seqObserverQueue) {
            if (this.hasChanged()) {
                this.clearChanged();
                size = this.observers.size();
            }
        }
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.observers.poll().update(this, data);
            }
        }
    }

    public void notifyObserver(Object data) {
        this.observers.poll().update(this, data);
    }

    @Override
    protected void setChanged() {
        this.changed = true;
    }

    @Override
    public void run() {
        this.mExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        SeqObserverQueue.this.mBusy.set(true);
                        ((Callable)SeqObserverQueue.this.tBlockingDeque.take()).call();
                    }
                    catch (Exception e) {
                        SeqObserverQueue.this.setChanged();
                        SeqObserverQueue.this.notifyObserver(new UdooBluException(7));
                    }
                    SeqObserverQueue.this.waitIdle(SeqObserverQueue.this.mWAIT);
                    SeqObserverQueue.this.mBusy.set(false);
                }
            }
        });
    }

    private boolean waitIdle(int i) {
        i /= 10;
        while (--i > 0 && this.mBusy.get()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return i > 0;
    }
}

