/*
 * Decompiled with CFR 0.152.
 */
package org.udoo.udooblulib.manager;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.udoo.udooblulib.UdooBlu;
import org.udoo.udooblulib.exceptions.UdooBluException;
import org.udoo.udooblulib.interfaces.IBleDeviceListener;
import org.udoo.udooblulib.interfaces.IBluManagerCallback;
import org.udoo.udooblulib.interfaces.INotificationListener;
import org.udoo.udooblulib.interfaces.IReaderListener;
import org.udoo.udooblulib.interfaces.OnBluOperationResult;
import org.udoo.udooblulib.interfaces.OnResult;
import org.udoo.udooblulib.model.IOPin;
import org.udoo.udooblulib.scan.BluScanCallBack;
import org.udoo.udooblulib.sensor.TIUUID;
import org.udoo.udooblulib.sensor.UDOOBLE;
import org.udoo.udooblulib.sensor.UDOOBLESensor;
import org.udoo.udooblulib.service.UdooBluService;
import org.udoo.udooblulib.utils.BitUtility;
import org.udoo.udooblulib.utils.SeqObserverQueue;

public class UdooBluManager {
    private boolean mBound;
    private UdooBluService mUdooBluService;
    private HashMap<String, OnBluOperationResult<Boolean>> mOnResultMap;
    private HashMap<String, IBleDeviceListener> mDeviceListenerMap;
    private HashMap<String, IReaderListener<byte[]>> mIReaderListenerMap;
    private HashMap<String, INotificationListener<byte[]>> mINotificationListenerMap;
    private boolean isBluManagerReady;
    private Handler mHandler;
    private boolean mScanning;
    private String TAG = "BluManager";
    private IBluManagerCallback mIBluManagerCallback;
    private BlockingQueue<Callable> voidBlockingQueue = new LinkedBlockingQueue<Callable>(10);
    private SeqObserverQueue seqObserverQueue = new SeqObserverQueue(this.voidBlockingQueue, 300);
    private boolean mIsBindService;
    private static final String BLU_FILE = "blu_prefs.xml";
    private UdooBluManager mUdooBluManager;
    private static UdooBluManager sUdooBluManager;
    private HashMap<String, UdooBlu> mUdooBluConnected;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            UdooBluService.LocalBinder binder = (UdooBluService.LocalBinder)service;
            UdooBluManager.this.mUdooBluService = binder.getService();
            UdooBluManager.this.mBound = true;
            if (UdooBluManager.this.mUdooBluService.initialize()) {
                UdooBluManager.this.isBluManagerReady = true;
                if (UdooBluManager.this.mIBluManagerCallback != null) {
                    UdooBluManager.this.mIBluManagerCallback.onBluManagerReady(sUdooBluManager);
                }
            } else {
                UdooBluManager.this.isBluManagerReady = false;
            }
        }

        public void onServiceDisconnected(ComponentName arg0) {
            UdooBluManager.this.mBound = false;
        }
    };
    private final BroadcastReceiver mGattBoundReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if ("android.bluetooth.device.action.BOND_STATE_CHANGED".equals(intent.getAction())) {
                int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
                BluetoothDevice dev = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (bondState == 12) {
                    Log.i((String)UdooBluManager.this.TAG, (String)"onReceive: bonded");
                } else if (bondState == 10) {
                    Log.i((String)UdooBluManager.this.TAG, (String)"onReceive: not bonded");
                }
            }
        }
    };
    private final BroadcastReceiver mGattUpdateReceiver = new BroadcastReceiver(){

        /*
         * Enabled aggressive block sorting
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int status = intent.getIntExtra("EXTRA_STATUS", 0);
            byte[] value = intent.getByteArrayExtra("EXTRA_DATA");
            String uuidStr = intent.getStringExtra("EXTRA_UUID");
            final String address = intent.getStringExtra("EXTRA_ADDRESS");
            if ("ACTION_GATT_CONNECTED".equals(action)) {
                UdooBluManager.this.mUdooBluService.scanServices(address);
                return;
            }
            if ("ACTION_GATT_SERVICES_DISCOVERED".equals(action)) {
                if (status != 0) return;
                Log.i((String)UdooBluManager.this.TAG, (String)"onReceive: discover services");
                if (UdooBluManager.this.mDeviceListenerMap.containsKey(address)) {
                    UdooBluManager.this.mUdooBluService.bond(address);
                    UdooBluManager.this.detectSensors(address, new IReaderListener<byte[]>(){

                        @Override
                        public void oRead(byte[] value) {
                            final IBleDeviceListener iBleDeviceListener = (IBleDeviceListener)UdooBluManager.this.mDeviceListenerMap.get(address);
                            boolean[] sensorsDetected = new boolean[8];
                            for (int i = 0; i < sensorsDetected.length; ++i) {
                                sensorsDetected[i] = (value[0] & 1 << i) > 0;
                            }
                            if (iBleDeviceListener != null) {
                                final UdooBlu udooBlu = new UdooBlu(address, sensorsDetected, UdooBluManager.this.mUdooBluManager);
                                UdooBluManager.this.mUdooBluConnected.put(address, udooBlu);
                                new Handler().postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        iBleDeviceListener.onDeviceConnected(udooBlu);
                                    }
                                }, 2000L);
                            }
                        }

                        @Override
                        public void onError(UdooBluException e) {
                            IBleDeviceListener iBleDeviceListener = (IBleDeviceListener)UdooBluManager.this.mDeviceListenerMap.get(address);
                            if (iBleDeviceListener != null) {
                                iBleDeviceListener.onError(e);
                            }
                        }
                    });
                    return;
                }
                Toast.makeText((Context)context, (CharSequence)"Service discovery failed", (int)1).show();
                return;
            }
            if ("ACTION_DATA_NOTIFY".equals(action) || "ACTION_DATA_WRITE".equals(action) || "ACTION_DATA_READ".equals(action)) {
                String keySearch = address + uuidStr;
                if ("ACTION_DATA_NOTIFY".equals(action)) {
                    INotificationListener iNotificationListener = (INotificationListener)UdooBluManager.this.mINotificationListenerMap.get(keySearch);
                    if (iNotificationListener == null) return;
                    iNotificationListener.onNext(value);
                    return;
                }
                if ("ACTION_DATA_WRITE".equals(action)) {
                    if (!UdooBluManager.this.mOnResultMap.containsKey(address)) return;
                    OnBluOperationResult onResultListener = (OnBluOperationResult)UdooBluManager.this.mOnResultMap.get(address);
                    if (onResultListener == null) return;
                    if (status == 0) {
                        onResultListener.onSuccess(true);
                    } else if (status == 3) {
                        onResultListener.onError(new UdooBluException(9));
                    } else {
                        onResultListener.onError(new UdooBluException(-1));
                    }
                    UdooBluManager.this.mOnResultMap.remove(address);
                    return;
                }
                if (!"ACTION_DATA_READ".equals(action)) return;
                IReaderListener iReaderListener = (IReaderListener)UdooBluManager.this.mIReaderListenerMap.get(keySearch);
                if (iReaderListener == null) return;
                if (status == 0) {
                    iReaderListener.oRead(value);
                } else {
                    iReaderListener.onError(new UdooBluException(8));
                }
                UdooBluManager.this.mOnResultMap.remove(address);
                return;
            }
            if (!"ACTION_DESCRIPTION_WRITE".equals(action)) {
                if (!"ACTION_GATT_DISCONNECTED".equals(action)) return;
                IBleDeviceListener iBleDeviceListener = (IBleDeviceListener)UdooBluManager.this.mDeviceListenerMap.get(address);
                if (iBleDeviceListener == null) return;
                iBleDeviceListener.onDeviceDisconnect(address);
                return;
            }
            if (!UdooBluManager.this.mOnResultMap.containsKey(address)) return;
            OnBluOperationResult onResultListener = (OnBluOperationResult)UdooBluManager.this.mOnResultMap.get(address);
            if (onResultListener == null) return;
            if (status == 0) {
                onResultListener.onSuccess(true);
            } else if (status == 3) {
                onResultListener.onError(new UdooBluException(9));
            } else {
                onResultListener.onError(new UdooBluException(-1));
            }
            UdooBluManager.this.mOnResultMap.remove(address);
        }
    };

    public static void GetUdooBluManager(Context context, IBluManagerCallback bluManagerCallback) {
        if (sUdooBluManager == null) {
            sUdooBluManager = new UdooBluManager(context);
        }
        sUdooBluManager.setIBluManagerCallback(bluManagerCallback);
    }

    private UdooBluManager(Context context) {
        this.mUdooBluManager = this;
        this.init(context);
    }

    public void init(Context context) {
        this.mDeviceListenerMap = new HashMap();
        this.mIReaderListenerMap = new HashMap();
        this.mINotificationListenerMap = new HashMap();
        this.mUdooBluConnected = new HashMap();
        this.mOnResultMap = new HashMap();
        this.mIsBindService = context.bindService(new Intent(context, UdooBluService.class), this.mConnection, 1);
        context.registerReceiver(this.mGattUpdateReceiver, UdooBluManager.makeGattUpdateIntentFilter());
        context.registerReceiver(this.mGattBoundReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
        this.mHandler = new Handler(Looper.getMainLooper());
        this.seqObserverQueue.run();
    }

    public void setIBluManagerCallback(IBluManagerCallback iBluManagerCallback) {
        this.mIBluManagerCallback = iBluManagerCallback;
        if (this.isBluManagerReady && this.mIBluManagerCallback != null) {
            this.mIBluManagerCallback.onBluManagerReady(sUdooBluManager);
        }
    }

    public void scanLeDevice(boolean enable, BluScanCallBack scanCallback) {
        if (this.mIsBindService && this.isBluManagerReady) {
            this.mUdooBluService.scanLeDevice(enable, scanCallback);
        } else if (scanCallback != null) {
            scanCallback.onError(new UdooBluException(0));
        }
    }

    public void connect(String address, IBleDeviceListener iBleDeviceListener) {
        if (this.mIsBindService && this.isBluManagerReady) {
            this.mUdooBluService.connect(address, iBleDeviceListener);
            this.setIBleDeviceListener(address, iBleDeviceListener);
        } else if (iBleDeviceListener != null) {
            iBleDeviceListener.onError(new UdooBluException(0));
        }
    }

    public void setIBleDeviceListener(String address, IBleDeviceListener iBleDeviceListener) {
        this.mDeviceListenerMap.put(address, iBleDeviceListener);
    }

    public void writeLed(String address, int color, boolean enable) {
        this.writeLed(address, color, enable ? (byte)1 : 0);
    }

    public void blinkLed(String address, int color, boolean blink) {
        this.writeLed(address, color, blink ? (byte)2 : 0);
    }

    private void writeLed(String address, int color, byte func) {
        BluetoothGattService serv = null;
        BluetoothGattCharacteristic charac = null;
        serv = this.mUdooBluService.getService(address, UDOOBLE.UUID_LED_SERV);
        if (serv != null) {
            switch (color) {
                case 1: {
                    charac = serv.getCharacteristic(UDOOBLE.UUID_LED_GREEN);
                    break;
                }
                case 2: {
                    charac = serv.getCharacteristic(UDOOBLE.UUID_LED_YELLOW);
                    break;
                }
                case 3: {
                    charac = serv.getCharacteristic(UDOOBLE.UUID_LED_RED);
                }
            }
            byte[] msg = new byte[]{func, 3};
            this.mUdooBluService.writeCharacteristic(address, charac, msg);
        }
    }

    private void detectSensors(String address, IReaderListener<byte[]> readerListener) {
        if (this.isBluManagerReady) {
            UUID servUuid = UDOOBLE.UUID_SENSORS_SERV;
            UUID dataUuid = UDOOBLE.UUID_SENSOR_DATA;
            BluetoothGattService serv = this.mUdooBluService.getService(address, servUuid);
            if (serv != null) {
                BluetoothGattCharacteristic charac = serv.getCharacteristic(dataUuid);
                this.mUdooBluService.readCharacteristic(address, charac);
                this.mIReaderListenerMap.put(address + charac.getUuid().toString(), readerListener);
            } else if (readerListener != null) {
                readerListener.onError(new UdooBluException(11));
            }
        } else if (readerListener != null) {
            readerListener.onError(new UdooBluException(0));
        }
    }

    public void enableSensor(final String address, final UDOOBLESensor sensor, final boolean enable, final OnBluOperationResult<Boolean> operationResult) {
        if (this.isBluManagerReady) {
            this.addOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    block3: {
                        if (sensor != null) {
                            UUID servUuid = sensor.getService();
                            UUID confUuid = sensor.getConfig();
                            BluetoothGattService serv = null;
                            BluetoothGattCharacteristic charac = null;
                            byte[] value = new byte[1];
                            try {
                                serv = UdooBluManager.this.mUdooBluService.getService(address, servUuid);
                                charac = serv.getCharacteristic(confUuid);
                                value[0] = enable ? sensor.getEnableSensorCode() : (byte)0;
                                UdooBluManager.this.mOnResultMap.put(address, operationResult);
                                UdooBluManager.this.mUdooBluService.writeCharacteristic(address, charac, value);
                            }
                            catch (Exception e) {
                                if (operationResult == null) break block3;
                                operationResult.onError(new UdooBluException(10));
                            }
                        }
                    }
                    return null;
                }
            });
        }
    }

    private void setNotification(final String address, final UDOOBLESensor udoobleSensor, final INotificationListener<byte[]> iNotificationListener) {
        if (this.isBluManagerReady) {
            this.addOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    UUID servUuid = udoobleSensor.getService();
                    UUID dataUuid = udoobleSensor.getData();
                    BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, servUuid);
                    if (serv != null) {
                        BluetoothGattCharacteristic charac = serv.getCharacteristic(dataUuid);
                        UdooBluManager.this.mINotificationListenerMap.put(address + charac.getUuid().toString(), iNotificationListener);
                        UdooBluManager.this.mUdooBluService.setCharacteristicNotification(address, charac, true);
                        Log.i((String)UdooBluManager.this.TAG, (String)"setNotification: ");
                    } else if (iNotificationListener != null) {
                        iNotificationListener.onError(new UdooBluException(10));
                    }
                    return null;
                }
            });
        }
    }

    private void setNotificationPeriod(final String address, final UDOOBLESensor udoobleSensor, final int period, final OnBluOperationResult<Boolean> operationResult) {
        if (this.isBluManagerReady) {
            this.addOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    UUID servUuid = udoobleSensor.getService();
                    UUID dataUuid = UDOOBLE.UUID_NOTIFICATION_PERI;
                    BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, servUuid);
                    if (serv != null) {
                        int tmpPeriod = period / 10;
                        BluetoothGattCharacteristic charac = serv.getCharacteristic(dataUuid);
                        byte[] msg = new byte[2];
                        byte[] value = BitUtility.To2Bytes(tmpPeriod);
                        msg[1] = value[0];
                        msg[0] = value[1];
                        UdooBluManager.this.mOnResultMap.put(address, operationResult);
                        UdooBluManager.this.mUdooBluService.writeCharacteristic(address, charac, msg);
                        Log.i((String)UdooBluManager.this.TAG, (String)"setNotificationPeriod: ");
                    } else if (operationResult != null) {
                        operationResult.onError(new UdooBluException(10));
                    }
                    return null;
                }
            });
        }
    }

    public void setNotification(final String address, final UDOOBLESensor udoobleSensor, final int period, final INotificationListener<byte[]> iNotificationListener) {
        if (this.isBluManagerReady) {
            this.addOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (period != 0) {
                        UdooBluManager.this.setNotificationPeriod(address, udoobleSensor, period, new OnBluOperationResult<Boolean>(){

                            @Override
                            public void onSuccess(Boolean aBoolean) {
                                if (aBoolean.booleanValue()) {
                                    UdooBluManager.this.setNotification(address, udoobleSensor, iNotificationListener);
                                } else if (iNotificationListener != null) {
                                    iNotificationListener.onError(new UdooBluException(14));
                                }
                                UdooBluManager.this.mOnResultMap.remove(address);
                            }

                            @Override
                            public void onError(UdooBluException runtimeException) {
                                if (iNotificationListener != null) {
                                    iNotificationListener.onError(runtimeException);
                                }
                                UdooBluManager.this.mOnResultMap.remove(address);
                            }
                        });
                    } else {
                        UdooBluManager.this.setNotification(address, udoobleSensor, iNotificationListener);
                    }
                    return null;
                }
            });
        } else if (iNotificationListener != null) {
            iNotificationListener.onError(new UdooBluException(0));
        }
    }

    private void addOperation(Callable<Void> operation) {
        try {
            this.voidBlockingQueue.put(operation);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setIoPinMode(final String address, final OnBluOperationResult<Boolean> onResultListener, final IOPin ... ioPins) {
        if (this.isBluManagerReady) {
            this.addOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    byte[] msg = new byte[2];
                    UUID service = UDOOBLE.UUID_IOPIN_SERV;
                    UUID characteristic = UDOOBLE.UUID_IOPIN_PIN_MODE;
                    for (IOPin ioPin : ioPins) {
                        if (ioPin == null) continue;
                        byte mode = ioPin.getPinMode();
                        int shift = 0;
                        switch (ioPin.pin) {
                            case D7: 
                            case A3: {
                                shift = 6;
                                break;
                            }
                            case D6: 
                            case A2: {
                                shift = 4;
                                break;
                            }
                            case A5: 
                            case A1: {
                                shift = 2;
                                break;
                            }
                            case A4: 
                            case A0: {
                                shift = 0;
                            }
                        }
                        byte value = (byte)(mode << shift & 0xFF);
                        int idx = ioPin.getPinValue() >= 4 ? 1 : 0;
                        msg[idx] = (byte)(msg[idx] | value);
                    }
                    Log.i((String)UdooBluManager.this.TAG, (String)"call: set pin mode");
                    BitUtility.LogBinValue(msg, false);
                    BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, service);
                    if (serv != null) {
                        BluetoothGattCharacteristic charac = serv.getCharacteristic(characteristic);
                        UdooBluManager.this.mOnResultMap.put(address, onResultListener);
                        UdooBluManager.this.mUdooBluService.writeCharacteristic(address, charac, msg);
                    }
                    return null;
                }
            });
        } else if (onResultListener != null) {
            onResultListener.onError(new UdooBluException(0));
        }
    }

    public void readDigital(final String address, final IReaderListener<byte[]> readerListener) {
        if (this.isBluManagerReady) {
            this.addOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    UUID servUuid = UDOOBLE.UUID_IOPIN_SERV;
                    UUID dataUuid = UDOOBLE.UUID_IOPIN_DIGITAL_DATA;
                    BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, servUuid);
                    if (serv != null) {
                        BluetoothGattCharacteristic charac = serv.getCharacteristic(dataUuid);
                        UdooBluManager.this.mUdooBluService.readCharacteristic(address, charac);
                        UdooBluManager.this.mIReaderListenerMap.put(address + charac.getUuid().toString(), readerListener);
                    } else if (readerListener != null) {
                        readerListener.onError(new UdooBluException(10));
                    }
                    return null;
                }
            });
        } else if (readerListener != null) {
            readerListener.onError(new UdooBluException(0));
        }
    }

    public void setPinAnalogOrPwmIndex(final String address, final IOPin ioPin, final OnBluOperationResult<Boolean> onResultListener) {
        if (this.isBluManagerReady) {
            this.addOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    UUID service = UDOOBLE.UUID_IOPIN_SERV;
                    UUID characteristic = UDOOBLE.UUID_IOPIN_PWM_ANALOG_INDEX;
                    byte[] msg = new byte[]{ioPin.getIndexValue()};
                    BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, service);
                    if (serv != null) {
                        BluetoothGattCharacteristic charac = serv.getCharacteristic(characteristic);
                        UdooBluManager.this.mOnResultMap.put(address, onResultListener);
                        UdooBluManager.this.mUdooBluService.writeCharacteristic(address, charac, msg);
                    } else if (onResultListener != null) {
                        onResultListener.onError(new UdooBluException(10));
                    }
                    return null;
                }
            });
        } else if (onResultListener != null) {
            onResultListener.onError(new UdooBluException(0));
        }
    }

    public void readAnalog(final String address, final IReaderListener<byte[]> iReaderListener) {
        this.addOperation(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                UUID servUuid = UDOOBLE.UUID_IOPIN_SERV;
                UUID dataUuid = UDOOBLE.UUID_IOPIN_ANALOG_READ;
                BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, servUuid);
                if (serv != null) {
                    BluetoothGattCharacteristic charac = serv.getCharacteristic(dataUuid);
                    UdooBluManager.this.mUdooBluService.readCharacteristic(address, charac);
                    UdooBluManager.this.mIReaderListenerMap.put(address + charac.getUuid().toString(), iReaderListener);
                } else if (iReaderListener != null) {
                    iReaderListener.onError(new UdooBluException(10));
                }
                return null;
            }
        });
    }

    public void writePwm(final String address, final int freq, final int dutyCycle, final OnBluOperationResult<Boolean> onResultListener) {
        if (this.isBluManagerReady) {
            this.addOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    UUID servUuid = UDOOBLE.UUID_IOPIN_SERV;
                    UUID dataUuid = UDOOBLE.UUID_IOPIN_PWM_CONFIG;
                    byte[] msg = new byte[5];
                    if (freq >= 3 && freq <= 24000000) {
                        byte[] freqs = BitUtility.ToBytes(freq);
                        msg[3] = freqs[0];
                        msg[2] = freqs[1];
                        msg[1] = freqs[2];
                        msg[0] = freqs[3];
                        msg[4] = (byte)(dutyCycle & 0xFF);
                        BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, servUuid);
                        BitUtility.LogBinValue(msg, false);
                        if (serv != null) {
                            BluetoothGattCharacteristic charac = serv.getCharacteristic(dataUuid);
                            UdooBluManager.this.mOnResultMap.put(address, onResultListener);
                            UdooBluManager.this.mUdooBluService.writeCharacteristic(address, charac, msg);
                        } else if (onResultListener != null) {
                            onResultListener.onError(new UdooBluException(10));
                        }
                    } else if (onResultListener != null) {
                        onResultListener.onError(new UdooBluException(9));
                    }
                    return null;
                }
            });
        } else if (onResultListener != null) {
            onResultListener.onError(new UdooBluException(0));
        }
    }

    public void writeDigital(final String address, final OnBluOperationResult<Boolean> onBluOperationResult, final IOPin ... ioPins) {
        this.addOperation(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (UdooBluManager.this.isBluManagerReady) {
                    UUID service = UDOOBLE.UUID_IOPIN_SERV;
                    UUID characteristic = UDOOBLE.UUID_IOPIN_DIGITAL_DATA;
                    byte[] msg = new byte[1];
                    int len = ioPins.length;
                    if (len > 8) {
                        len = 8;
                    }
                    for (int i = 0; i < len; ++i) {
                        IOPin ioPin = ioPins[i];
                        int shift = 0;
                        switch (ioPin.pin) {
                            case D7: {
                                shift = 7;
                                break;
                            }
                            case D6: {
                                shift = 6;
                                break;
                            }
                            case A5: {
                                shift = 5;
                                break;
                            }
                            case A4: {
                                shift = 4;
                                break;
                            }
                            case A3: {
                                shift = 3;
                                break;
                            }
                            case A2: {
                                shift = 2;
                                break;
                            }
                            case A1: {
                                shift = 1;
                                break;
                            }
                            case A0: {
                                shift = 0;
                            }
                        }
                        byte value = (byte)(ioPin.getShortDigitalValue() << shift & 0xFF);
                        msg[0] = (byte)(msg[0] | value);
                    }
                    Log.i((String)UdooBluManager.this.TAG, (String)"call: write difital");
                    BitUtility.LogBinValue(msg, false);
                    BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, service);
                    if (serv != null) {
                        BluetoothGattCharacteristic charac = serv.getCharacteristic(characteristic);
                        UdooBluManager.this.mOnResultMap.put(address, onBluOperationResult);
                        UdooBluManager.this.mUdooBluService.writeCharacteristic(address, charac, msg);
                    }
                } else if (onBluOperationResult != null) {
                    onBluOperationResult.onError(new UdooBluException(0));
                }
                return null;
            }
        });
    }

    private void unSubscribeNotification(final String address, final UDOOBLESensor udoobleSensor, final OnBluOperationResult<Boolean> operationResult) {
        if (this.isBluManagerReady) {
            this.addOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    UUID servUuid = udoobleSensor.getService();
                    UUID dataUuid = udoobleSensor.getData();
                    BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, servUuid);
                    Log.i((String)UdooBluManager.this.TAG, (String)("enableNotifications service " + servUuid.toString() + " is null: " + (serv == null)));
                    if (serv != null) {
                        BluetoothGattCharacteristic charac = serv.getCharacteristic(dataUuid);
                        String keySearch = address + charac.getUuid().toString();
                        if (UdooBluManager.this.mINotificationListenerMap.containsKey(keySearch)) {
                            UdooBluManager.this.mINotificationListenerMap.remove(keySearch);
                        }
                        UdooBluManager.this.mOnResultMap.put(address, operationResult);
                        UdooBluManager.this.mUdooBluService.setCharacteristicNotification(address, charac, false);
                    } else if (operationResult != null) {
                        operationResult.onError(new UdooBluException(10));
                    }
                    return null;
                }
            });
        } else if (operationResult != null) {
            operationResult.onError(new UdooBluException(0));
        }
    }

    public void readSensor(final String address, final IReaderListener<byte[]> readerListener, SENSORS sensor, final UDOOBLESensor udoobleSensor) {
        if (this.isBluManagerReady) {
            this.addOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    UUID servUuid = udoobleSensor.getService();
                    UUID dataUuid = udoobleSensor.getData();
                    BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, servUuid);
                    if (serv != null) {
                        BluetoothGattCharacteristic charac = serv.getCharacteristic(dataUuid);
                        UdooBluManager.this.mUdooBluService.readCharacteristic(address, charac);
                        UdooBluManager.this.mIReaderListenerMap.put(address + charac.getUuid().toString(), readerListener);
                    } else if (readerListener != null) {
                        readerListener.onError(new UdooBluException(10));
                    }
                    return null;
                }
            });
        } else if (readerListener != null) {
            readerListener.onError(new UdooBluException(0));
        }
    }

    public void readAccelerometer(String address, IReaderListener<byte[]> readerListener) {
        this.readSensor(address, readerListener, SENSORS.ACC, UDOOBLESensor.ACCELEROMETER);
    }

    public void readGyroscope(String address, IReaderListener<byte[]> readerListener) {
        this.readSensor(address, readerListener, SENSORS.GYRO, UDOOBLESensor.GYROSCOPE);
    }

    public void readMagnetometer(String address, IReaderListener<byte[]> readerListener) {
        this.readSensor(address, readerListener, SENSORS.MAGN, UDOOBLESensor.MAGNETOMETER);
    }

    public void readBarometer(String address, IReaderListener<byte[]> readerListener) {
        this.readSensor(address, readerListener, SENSORS.BAR, UDOOBLESensor.BAROMETER_P);
    }

    public void readTemperature(String address, IReaderListener<byte[]> readerListener) {
        this.readSensor(address, readerListener, SENSORS.TEMP, UDOOBLESensor.TEMPERATURE);
    }

    public void readHumidity(String address, IReaderListener<byte[]> readerListener) {
        this.readSensor(address, readerListener, SENSORS.HUM, UDOOBLESensor.HUMIDITY);
    }

    public void readAmbientLight(String address, IReaderListener<byte[]> readerListener) {
        this.readSensor(address, readerListener, SENSORS.AMB_LIG, UDOOBLESensor.AMBIENT_LIGHT);
    }

    public void subscribeNotificationAccelerometer(String address, INotificationListener<byte[]> notificationListener) {
        this.setNotification(address, UDOOBLESensor.ACCELEROMETER, 100, notificationListener);
    }

    public void unSubscribeNotificationAccelerometer(String address, OnBluOperationResult<Boolean> operationResult) {
        this.unSubscribeNotification(address, UDOOBLESensor.ACCELEROMETER, operationResult);
    }

    public void subscribeNotificationAccelerometer(String address, INotificationListener<byte[]> notificationListener, int period) {
        this.setNotification(address, UDOOBLESensor.ACCELEROMETER, period, notificationListener);
    }

    public void subscribeNotificationGyroscope(String address, INotificationListener<byte[]> notificationListener) {
        this.setNotification(address, UDOOBLESensor.GYROSCOPE, 100, notificationListener);
    }

    public void subscribeNotificationGyroscope(String address, INotificationListener<byte[]> notificationListener, int period) {
        this.setNotification(address, UDOOBLESensor.GYROSCOPE, period, notificationListener);
    }

    public void unSubscribeNotificationGyroscope(String address, OnBluOperationResult<Boolean> operationResult) {
        this.unSubscribeNotification(address, UDOOBLESensor.GYROSCOPE, operationResult);
    }

    public void subscribeNotificationMagnetometer(String address, INotificationListener<byte[]> notificationListener) {
        this.setNotification(address, UDOOBLESensor.MAGNETOMETER, 100, notificationListener);
    }

    public void subscribeNotificationMagnetometer(String address, INotificationListener<byte[]> notificationListener, int period) {
        this.setNotification(address, UDOOBLESensor.MAGNETOMETER, period, notificationListener);
    }

    public void unSubscribeNotificationMagnetometer(String address, OnBluOperationResult<Boolean> operationResult) {
        this.unSubscribeNotification(address, UDOOBLESensor.MAGNETOMETER, operationResult);
    }

    public void subscribeNotificationBarometer(String address, INotificationListener<byte[]> notificationListener) {
        this.setNotification(address, UDOOBLESensor.BAROMETER_P, 100, notificationListener);
    }

    public void subscribeNotificationBarometer(String address, INotificationListener<byte[]> notificationListener, int period) {
        this.setNotification(address, UDOOBLESensor.BAROMETER_P, period, notificationListener);
    }

    public void unSubscribeNotificationBarometer(String address, OnBluOperationResult<Boolean> operationResult) {
        this.unSubscribeNotification(address, UDOOBLESensor.BAROMETER_P, operationResult);
    }

    public void subscribeNotificationTemperature(String address, INotificationListener<byte[]> notificationListener) {
        this.setNotification(address, UDOOBLESensor.TEMPERATURE, 100, notificationListener);
    }

    public void subscribeNotificationTemperature(String address, INotificationListener<byte[]> notificationListener, int period) {
        this.setNotification(address, UDOOBLESensor.TEMPERATURE, 100, notificationListener);
    }

    public void unSubscribeNotificationTemperature(String address, OnBluOperationResult<Boolean> operationResult) {
        this.unSubscribeNotification(address, UDOOBLESensor.TEMPERATURE, operationResult);
    }

    public void subscribeNotificationHumidity(String address, INotificationListener<byte[]> notificationListener) {
        this.setNotification(address, UDOOBLESensor.HUMIDITY, 100, notificationListener);
    }

    public void subscribeNotificationHumidity(String address, INotificationListener<byte[]> notificationListener, int period) {
        this.setNotification(address, UDOOBLESensor.HUMIDITY, period, notificationListener);
    }

    public void unSubscribeNotificationHumidity(String address, OnBluOperationResult<Boolean> operationResult) {
        this.unSubscribeNotification(address, UDOOBLESensor.HUMIDITY, operationResult);
    }

    public void subscribeNotificationAmbientLight(String address, INotificationListener<byte[]> notificationListener) {
        this.setNotification(address, UDOOBLESensor.AMBIENT_LIGHT, 100, notificationListener);
    }

    public void subscribeNotificationAmbientLight(String address, INotificationListener<byte[]> notificationListener, int period) {
        this.setNotification(address, UDOOBLESensor.AMBIENT_LIGHT, period, notificationListener);
    }

    public void unSubscribeNotificationAmbientLight(String address, OnBluOperationResult<Boolean> operationResult) {
        this.unSubscribeNotification(address, UDOOBLESensor.AMBIENT_LIGHT, operationResult);
    }

    public void subscribeNotificationAnalog(String address, INotificationListener<byte[]> notificationListener) {
        this.subscribeNotificationAnalog(address, 100, notificationListener);
    }

    public void subscribeNotificationAnalog(final String address, int interval, final INotificationListener<byte[]> notificationListener) {
        this.setNotificationPeriod(address, UDOOBLESensor.IOPIN_ANALOG, interval, new OnBluOperationResult<Boolean>(){

            @Override
            public void onSuccess(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    UdooBluManager.this.setNotification(address, UDOOBLESensor.IOPIN_ANALOG, notificationListener);
                } else if (notificationListener != null) {
                    notificationListener.onError(new UdooBluException(14));
                }
                UdooBluManager.this.mOnResultMap.remove(address);
            }

            @Override
            public void onError(UdooBluException runtimeException) {
                if (notificationListener != null) {
                    notificationListener.onError(new UdooBluException(14));
                }
                UdooBluManager.this.mOnResultMap.remove(address);
            }
        });
    }

    public void unSubscribeNotificationAnalog(String address, OnBluOperationResult<Boolean> operationResult) {
        this.unSubscribeNotification(address, UDOOBLESensor.IOPIN_ANALOG, operationResult);
    }

    public void setPinAnalogPwmIndex(String address, IOPin ioPin, OnBluOperationResult<Boolean> operationResult) {
        this.setPinAnalogOrPwmIndex(address, ioPin, operationResult);
    }

    public void subscribeNotificationDigital(String address, INotificationListener<byte[]> notificationListener) {
        this.setNotification(address, UDOOBLESensor.IOPIN_DIGITAL, notificationListener);
    }

    public void unSubscribeNotificationDigital(String address, OnBluOperationResult<Boolean> operationResult) {
        this.unSubscribeNotification(address, UDOOBLESensor.IOPIN_DIGITAL, operationResult);
    }

    public boolean pwmWrite(IOPin.PIN pin, int freq, int dutyCycle) {
        return false;
    }

    public void saveBluItem(Context context, String address, String name) {
        SharedPreferences sharedPref = context.getSharedPreferences(BLU_FILE, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(address, name);
        editor.apply();
    }

    public void getBluItems(final Context context, final OnResult<Map<String, String>> onResult) {
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                SharedPreferences sharedPref = context.getSharedPreferences(UdooBluManager.BLU_FILE, 0);
                Map values = sharedPref.getAll();
                if (onResult != null) {
                    onResult.onSuccess(values);
                }
            }
        });
    }

    public void getBluItem(final Context context, final String address, final OnResult<String> onResult) {
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                SharedPreferences sharedPref = context.getSharedPreferences(UdooBluManager.BLU_FILE, 0);
                if (onResult != null) {
                    onResult.onSuccess(sharedPref.getString(address, ""));
                }
            }
        });
    }

    public UdooBlu getUdooBlu(String address) {
        UdooBlu udooBlu = null;
        if (this.mUdooBluConnected.containsKey(address)) {
            udooBlu = this.mUdooBluConnected.get(address);
        }
        return udooBlu;
    }

    private static IntentFilter makeGattUpdateIntentFilter() {
        IntentFilter fi = new IntentFilter();
        fi.addAction("ACTION_GATT_CONNECTED");
        fi.addAction("ACTION_GATT_DISCONNECTED");
        fi.addAction("ACTION_GATT_SERVICES_DISCOVERED");
        fi.addAction("ACTION_DATA_NOTIFY");
        fi.addAction("ACTION_DATA_WRITE");
        fi.addAction("ACTION_DATA_READ");
        fi.addAction("ACTION_DESCRIPTION_WRITE");
        return fi;
    }

    public boolean discoveryServices(String address) {
        if (this.isBluManagerReady) {
            return this.mUdooBluService.scanServices(address);
        }
        return false;
    }

    public boolean requestConnectionPriority(String address, int connectionPriority) {
        return this.mUdooBluService.requestConnectionPriority(address, connectionPriority);
    }

    public void readFirmwareVersion(final String address, final IReaderListener<byte[]> readerListener) {
        this.addOperation(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (UdooBluManager.this.isBluManagerReady) {
                    UUID servUuid = TIUUID.UUID_DEVINFO_SERV;
                    UUID dataUuid = TIUUID.UUID_DEVINFO_FWREV;
                    BluetoothGattService serv = UdooBluManager.this.mUdooBluService.getService(address, servUuid);
                    if (serv != null) {
                        BluetoothGattCharacteristic charac = serv.getCharacteristic(dataUuid);
                        UdooBluManager.this.mUdooBluService.readCharacteristic(address, charac);
                        UdooBluManager.this.mIReaderListenerMap.put(address + charac.getUuid().toString(), readerListener);
                    } else if (readerListener != null) {
                        readerListener.onError(new UdooBluException(10));
                    }
                }
                return null;
            }
        });
    }

    public BluetoothGattService getService(String address, UUID servUuid) {
        return this.mUdooBluService.getService(address, servUuid);
    }

    public void readCharacteristic(String address, BluetoothGattCharacteristic characteristic, IReaderListener<byte[]> readerListener) {
        if (characteristic != null) {
            this.mUdooBluService.readCharacteristic(address, characteristic);
            this.mIReaderListenerMap.put(address + characteristic.getUuid().toString(), readerListener);
        }
    }

    public void writeCharacteristic(String address, BluetoothGattCharacteristic characteristic, byte[] value, OnBluOperationResult<Boolean> onResultListener) {
        if (characteristic != null) {
            if (onResultListener != null) {
                this.mOnResultMap.put(address, onResultListener);
            }
            this.mUdooBluService.writeCharacteristic(address, characteristic, value);
        }
    }

    public boolean writeCharacteristicNonBlock(String address, BluetoothGattCharacteristic characteristic, byte[] value) {
        boolean result = false;
        if (characteristic != null) {
            result = this.mUdooBluService.writeCharacteristicNonBlock(address, characteristic, value);
        }
        return result;
    }

    public void subscribeNotification(String address, BluetoothGattCharacteristic characteristic, INotificationListener<byte[]> notificationListener) {
        if (characteristic != null) {
            this.mINotificationListenerMap.put(address + characteristic.getUuid().toString(), notificationListener);
            this.mUdooBluService.setCharacteristicNotification(address, characteristic, true);
            Log.i((String)this.TAG, (String)"setNotification: ");
        }
    }

    public void unSubscribeNotification(String address, BluetoothGattCharacteristic characteristic, OnBluOperationResult<Boolean> onResultListener) {
        if (characteristic != null) {
            String keySearch = address + characteristic.getUuid().toString();
            if (this.mINotificationListenerMap.containsKey(keySearch)) {
                this.mINotificationListenerMap.remove(keySearch);
            }
            this.mOnResultMap.put(address, onResultListener);
            this.mUdooBluService.setCharacteristicNotification(address, characteristic, false);
        }
    }

    public void disconnect(String address) {
        this.mUdooBluService.disconnect(address);
    }

    public boolean bond(String address) {
        return this.mUdooBluService.bond(address);
    }

    public boolean unpair(String address) {
        return this.mUdooBluService.unpair(address);
    }

    public static enum SENSORS {
        ACC,
        MAGN,
        GYRO,
        TEMP,
        BAR,
        HUM,
        AMB_LIG,
        RES;

    }
}

