/*
 * Decompiled with CFR 0.152.
 */
package org.udoo.udooblulib;

import org.udoo.udooblulib.exceptions.UdooBluException;
import org.udoo.udooblulib.interfaces.INotificationListener;
import org.udoo.udooblulib.interfaces.IReaderListener;
import org.udoo.udooblulib.interfaces.OnBluOperationResult;
import org.udoo.udooblulib.manager.UdooBluManager;
import org.udoo.udooblulib.model.IOPin;
import org.udoo.udooblulib.sensor.UDOOBLESensor;

public class UdooBlu {
    private String mAddress;
    private UdooBluManager mUdooBluManager;
    private IOPin[] mIOPins;
    private boolean[] sensorsDetected;
    private boolean[] sensorsEnabled = new boolean[8];
    private byte[] iOPinConfig = new byte[8];
    private byte indexAnalogConfig;

    public UdooBlu(String address, boolean[] sensorsDetected, UdooBluManager udooBluManager) {
        this.mAddress = address;
        this.mUdooBluManager = udooBluManager;
        this.mIOPins = new IOPin[8];
        this.sensorsDetected = sensorsDetected;
        this.indexAnalogConfig = (byte)-1;
    }

    public void readFirmwareVersion(IReaderListener<byte[]> readerListener) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.readFirmwareVersion(this.mAddress, readerListener);
        }
    }

    public boolean[] getSensorDetected() {
        return this.sensorsDetected;
    }

    public boolean isSensorDetected(UdooBluManager.SENSORS sensor) {
        return this.sensorsDetected[sensor.ordinal()];
    }

    public void blinkLed(int color, boolean blink) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.blinkLed(this.mAddress, color, blink);
        }
    }

    public void setIoPinMode(final OnBluOperationResult<Boolean> onResultListener, IOPin ... ioPins) {
        final IOPin[] tmpIOPins = this.mergeWithLocalIOPinConfig(ioPins);
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.setIoPinMode(this.mAddress, new OnBluOperationResult<Boolean>(){

                @Override
                public void onSuccess(Boolean aBoolean) {
                    UdooBlu.access$002(UdooBlu.this, (IOPin[])tmpIOPins.clone());
                    if (onResultListener != null) {
                        onResultListener.onSuccess(aBoolean);
                    }
                }

                @Override
                public void onError(UdooBluException runtimeException) {
                    if (onResultListener != null) {
                        onResultListener.onError(runtimeException);
                    }
                }
            }, tmpIOPins);
        }
    }

    public void setIoPinMode(int pin, IOPin.MODE mode) {
        final IOPin[] tmpIOPins = this.mergeWithLocalIOPinConfig(IOPin.Builder(IOPin.GetPin(pin), mode));
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.setIoPinMode(this.mAddress, new OnBluOperationResult<Boolean>(){

                @Override
                public void onSuccess(Boolean aBoolean) {
                    UdooBlu.access$002(UdooBlu.this, (IOPin[])tmpIOPins.clone());
                }

                @Override
                public void onError(UdooBluException runtimeException) {
                }
            }, tmpIOPins);
        }
    }

    public void digitalRead(IReaderListener<byte[]> iReaderListener, int pin) {
        IOPin.PIN ioPin = IOPin.GetPin(pin);
        IOPin.DIGITAL_VALUE ioValue = IOPin.DIGITAL_VALUE.LOW;
        if (ioPin != null) {
            this.digitalRead(iReaderListener, IOPin.Builder(ioPin, ioValue));
        }
    }

    public void digitalWrite(int pin, int value) {
        IOPin.PIN ioPin = IOPin.GetPin(pin);
        IOPin.DIGITAL_VALUE ioValue = IOPin.GetDigitalValue(value);
        if (ioPin != null && ioValue != null) {
            this.digitalWrite(null, IOPin.Builder(ioPin, ioValue));
        }
    }

    public void digitalWrite(int pin, IOPin.DIGITAL_VALUE value) {
        IOPin.PIN ioPin = IOPin.GetPin(pin);
        IOPin.DIGITAL_VALUE ioValue = IOPin.GetDigitalValue(value.ordinal());
        if (ioPin != null && ioValue != null) {
            this.digitalWrite(null, IOPin.Builder(ioPin, ioValue));
        }
    }

    public void digitalWrite(final OnBluOperationResult<Boolean> onBluOperationResult, final IOPin ... ioPins) {
        if (this.iOPinVerifier(IOPin.MODE.DIGITAL_OUTPUT, ioPins)) {
            if (this.mUdooBluManager != null) {
                this.mUdooBluManager.writeDigital(this.mAddress, onBluOperationResult, ioPins);
            }
        } else {
            this.iOPinModeBuilder(IOPin.MODE.DIGITAL_OUTPUT, ioPins);
            this.setIoPinMode(new OnBluOperationResult<Boolean>(){

                @Override
                public void onSuccess(Boolean aBoolean) {
                    UdooBlu.this.setLocaliOPinConfig(IOPin.MODE.DIGITAL_OUTPUT, ioPins);
                    if (UdooBlu.this.mUdooBluManager != null) {
                        UdooBlu.this.mUdooBluManager.writeDigital(UdooBlu.this.mAddress, onBluOperationResult, ioPins);
                    }
                }

                @Override
                public void onError(UdooBluException runtimeException) {
                    if (runtimeException != null) {
                        onBluOperationResult.onError(runtimeException);
                    }
                }
            }, ioPins);
        }
    }

    public void pwmWrite(int pin, int freq, int dutyCycle, OnBluOperationResult<Boolean> onResultListener) {
        IOPin.PIN ioPin = IOPin.GetPin(pin);
        if (ioPin != null) {
            this.pwmWrite(ioPin, freq, dutyCycle, onResultListener);
        }
    }

    public void pwmWrite(IOPin.PIN pin, final int freq, final int dutyCycle, final OnBluOperationResult<Boolean> onResultListener) {
        final IOPin ioPin = IOPin.Builder(pin, IOPin.MODE.DIGITAL_PWM);
        if (this.iOPinVerifier(IOPin.MODE.DIGITAL_PWM, ioPin)) {
            if (this.indexAnalogConfig == ioPin.getIndexValue()) {
                if (this.mUdooBluManager != null) {
                    this.mUdooBluManager.writePwm(this.mAddress, freq, dutyCycle, onResultListener);
                }
            } else if (this.mUdooBluManager != null) {
                this.mUdooBluManager.setPinAnalogOrPwmIndex(this.mAddress, IOPin.Builder(pin, IOPin.INDEX_VALUE.PWM), new OnBluOperationResult<Boolean>(){

                    @Override
                    public void onSuccess(Boolean aBoolean) {
                        if (aBoolean.booleanValue()) {
                            UdooBlu.this.indexAnalogConfig = ioPin.getIndexValue();
                            if (UdooBlu.this.mUdooBluManager != null) {
                                UdooBlu.this.mUdooBluManager.writePwm(UdooBlu.this.mAddress, freq, dutyCycle, onResultListener);
                            }
                        } else if (onResultListener != null) {
                            onResultListener.onError(new UdooBluException(9));
                        }
                    }

                    @Override
                    public void onError(UdooBluException runtimeException) {
                        if (runtimeException != null && onResultListener != null) {
                            onResultListener.onError(new UdooBluException(9));
                        }
                    }
                });
            }
        } else {
            this.iOPinModeBuilder(IOPin.MODE.DIGITAL_PWM, ioPin);
            this.setIoPinMode(new OnBluOperationResult<Boolean>(){

                @Override
                public void onSuccess(Boolean aBoolean) {
                    if (aBoolean.booleanValue()) {
                        UdooBlu.this.setLocaliOPinConfig(IOPin.MODE.DIGITAL_PWM, new IOPin[]{ioPin});
                        if (UdooBlu.this.mUdooBluManager != null) {
                            UdooBlu.this.mUdooBluManager.writePwm(UdooBlu.this.mAddress, freq, dutyCycle, onResultListener);
                        }
                    } else if (onResultListener != null) {
                        onResultListener.onError(new UdooBluException(9));
                    }
                }

                @Override
                public void onError(UdooBluException runtimeException) {
                    if (runtimeException != null && onResultListener != null) {
                        onResultListener.onError(runtimeException);
                    }
                }
            }, ioPin);
        }
    }

    public void digitalRead(final IReaderListener<byte[]> readerListener, final IOPin ... pins) {
        if (this.iOPinVerifier(IOPin.MODE.DIGITAL_INPUT, pins)) {
            if (this.mUdooBluManager != null) {
                this.mUdooBluManager.readDigital(this.mAddress, readerListener);
            }
        } else {
            this.iOPinModeBuilder(IOPin.MODE.DIGITAL_INPUT, pins);
            this.setIoPinMode(new OnBluOperationResult<Boolean>(){

                @Override
                public void onSuccess(Boolean aBoolean) {
                    UdooBlu.this.setLocaliOPinConfig(IOPin.MODE.DIGITAL_INPUT, pins);
                    if (UdooBlu.this.mUdooBluManager != null) {
                        UdooBlu.this.mUdooBluManager.readDigital(UdooBlu.this.mAddress, readerListener);
                    }
                }

                @Override
                public void onError(UdooBluException runtimeException) {
                    if (runtimeException != null && readerListener != null) {
                        readerListener.onError(new UdooBluException(8));
                    }
                }
            }, pins);
        }
    }

    public void analogRead(int pin, IReaderListener<byte[]> iReaderListener) {
        IOPin.PIN ioPin = IOPin.GetPin(pin);
        if (ioPin != null) {
            this.analogRead(ioPin, iReaderListener);
        }
    }

    public void analogRead(IOPin.PIN pin, final IReaderListener<byte[]> iReaderListener) {
        IOPin ioPin = IOPin.Builder(pin, IOPin.MODE.ANALOG_INPUT);
        if (this.iOPinVerifier(ioPin)) {
            if (this.indexAnalogConfig == ioPin.getIndexValue()) {
                if (this.mUdooBluManager != null) {
                    this.mUdooBluManager.readAnalog(this.mAddress, iReaderListener);
                }
            } else {
                this.configAnalog(pin, new OnBluOperationResult<Boolean>(){

                    @Override
                    public void onSuccess(Boolean aBoolean) {
                        if (UdooBlu.this.mUdooBluManager != null) {
                            UdooBlu.this.mUdooBluManager.readAnalog(UdooBlu.this.mAddress, iReaderListener);
                        }
                    }

                    @Override
                    public void onError(UdooBluException runtimeException) {
                        if (iReaderListener != null) {
                            iReaderListener.onError(runtimeException);
                        }
                    }
                });
            }
        }
    }

    public void readAccelerometer(IReaderListener<byte[]> readerListener) {
        if (this.mUdooBluManager != null) {
            this.readSensor(this.mAddress, readerListener, UdooBluManager.SENSORS.ACC, UDOOBLESensor.ACCELEROMETER);
        }
    }

    public void readGyroscope(IReaderListener<byte[]> readerListener) {
        if (this.mUdooBluManager != null) {
            this.readSensor(this.mAddress, readerListener, UdooBluManager.SENSORS.GYRO, UDOOBLESensor.GYROSCOPE);
        }
    }

    public void readMagnetometer(IReaderListener<byte[]> readerListener) {
        if (this.mUdooBluManager != null) {
            this.readSensor(this.mAddress, readerListener, UdooBluManager.SENSORS.MAGN, UDOOBLESensor.MAGNETOMETER);
        }
    }

    public void readBarometer(IReaderListener<byte[]> readerListener) {
        if (this.mUdooBluManager != null) {
            this.readSensor(this.mAddress, readerListener, UdooBluManager.SENSORS.BAR, UDOOBLESensor.BAROMETER_P);
        }
    }

    public void readTemperature(IReaderListener<byte[]> onCharacteristicsListener) {
        if (this.mUdooBluManager != null) {
            this.readSensor(this.mAddress, onCharacteristicsListener, UdooBluManager.SENSORS.TEMP, UDOOBLESensor.TEMPERATURE);
        }
    }

    public void readHumidity(IReaderListener<byte[]> onCharacteristicsListener) {
        if (this.mUdooBluManager != null) {
            this.readSensor(this.mAddress, onCharacteristicsListener, UdooBluManager.SENSORS.HUM, UDOOBLESensor.HUMIDITY);
        }
    }

    public void readAmbientLight(IReaderListener<byte[]> onCharacteristicsListener) {
        if (this.mUdooBluManager != null) {
            this.readSensor(this.mAddress, onCharacteristicsListener, UdooBluManager.SENSORS.AMB_LIG, UDOOBLESensor.AMBIENT_LIGHT);
        }
    }

    public void subscribeNotificationAccelerometer(INotificationListener<byte[]> notificationListener) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.ACC, UDOOBLESensor.ACCELEROMETER, 100, notificationListener);
        }
    }

    public void subscribeNotificationAccelerometer(INotificationListener<byte[]> notificationListener, int period) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.ACC, UDOOBLESensor.ACCELEROMETER, period, notificationListener);
        }
    }

    public void unSubscribeNotificationAccelerometer(OnBluOperationResult<Boolean> operationResult) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.unSubscribeNotificationAccelerometer(this.mAddress, operationResult);
        }
    }

    public void subscribeNotificationGyroscope(INotificationListener<byte[]> notificationListener) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.GYRO, UDOOBLESensor.GYROSCOPE, 100, notificationListener);
        }
    }

    public void subscribeNotificationGyroscope(INotificationListener<byte[]> notificationListener, int period) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.GYRO, UDOOBLESensor.GYROSCOPE, period, notificationListener);
        }
    }

    public void unSubscribeNotificationGyroscope(OnBluOperationResult<Boolean> operationResult) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.unSubscribeNotificationGyroscope(this.mAddress, operationResult);
        }
    }

    public void subscribeNotificationMagnetometer(INotificationListener<byte[]> notificationListener) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.MAGN, UDOOBLESensor.MAGNETOMETER, 100, notificationListener);
        }
    }

    public void subscribeNotificationMagnetometer(INotificationListener<byte[]> notificationListener, int period) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.MAGN, UDOOBLESensor.MAGNETOMETER, period, notificationListener);
        }
    }

    public void unSubscribeNotificationMagnetometer(OnBluOperationResult<Boolean> operationResult) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.unSubscribeNotificationMagnetometer(this.mAddress, operationResult);
        }
    }

    public void subscribeNotificationBarometer(INotificationListener<byte[]> notificationListener) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.BAR, UDOOBLESensor.BAROMETER_P, 100, notificationListener);
        }
    }

    public void subscribeNotificationBarometer(INotificationListener<byte[]> notificationListener, int period) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.BAR, UDOOBLESensor.BAROMETER_P, period, notificationListener);
        }
    }

    public void unSubscribeNotificationBarometer(OnBluOperationResult<Boolean> operationResult) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.unSubscribeNotificationBarometer(this.mAddress, operationResult);
        }
    }

    public void subscribeNotificationTemperature(INotificationListener<byte[]> notificationListener) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.TEMP, UDOOBLESensor.TEMPERATURE, 100, notificationListener);
        }
    }

    public void subscribeNotificationTemperature(INotificationListener<byte[]> notificationListener, int period) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.TEMP, UDOOBLESensor.TEMPERATURE, period, notificationListener);
        }
    }

    public void unSubscribeNotificationTemperature(OnBluOperationResult<Boolean> operationResult) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.unSubscribeNotificationTemperature(this.mAddress, operationResult);
        }
    }

    public void subscribeNotificationHumidity(INotificationListener<byte[]> notificationListener) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.HUM, UDOOBLESensor.HUMIDITY, 100, notificationListener);
        }
    }

    public void subscribeNotificationHumidity(INotificationListener<byte[]> notificationListener, int period) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.HUM, UDOOBLESensor.HUMIDITY, period, notificationListener);
        }
    }

    public void unSubscribeNotificationHumidity(OnBluOperationResult<Boolean> operationResult) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.unSubscribeNotificationHumidity(this.mAddress, operationResult);
        }
    }

    public void subscribeNotificationAmbientLight(INotificationListener<byte[]> notificationListener) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.AMB_LIG, UDOOBLESensor.AMBIENT_LIGHT, 100, notificationListener);
        }
    }

    public void subscribeNotificationAmbientLight(INotificationListener<byte[]> notificationListener, int period) {
        if (this.mUdooBluManager != null) {
            this.setNotification(this.mAddress, UdooBluManager.SENSORS.AMB_LIG, UDOOBLESensor.AMBIENT_LIGHT, period, notificationListener);
        }
    }

    public void unSubscribeNotificationAmbientLight(OnBluOperationResult<Boolean> operationResult) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.unSubscribeNotificationAmbientLight(this.mAddress, operationResult);
        }
    }

    public void subscribeNotificationAnalog(IOPin.PIN pin, INotificationListener<byte[]> notificationListener) {
        this.subscribeNotificationAnalog(pin, notificationListener, 100);
    }

    public void subscribeNotificationAnalog(IOPin.PIN pin, final INotificationListener<byte[]> notificationListener, final int period) {
        IOPin ioPin = IOPin.Builder(pin, IOPin.MODE.ANALOG_INPUT);
        if (this.iOPinVerifier(ioPin)) {
            if (this.indexAnalogConfig == ioPin.getIndexValue()) {
                if (this.mUdooBluManager != null) {
                    this.mUdooBluManager.setNotification(this.mAddress, UDOOBLESensor.IOPIN_ANALOG, period, notificationListener);
                }
            } else {
                this.configAnalog(pin, new OnBluOperationResult<Boolean>(){

                    @Override
                    public void onSuccess(Boolean aBoolean) {
                        if (UdooBlu.this.mUdooBluManager != null) {
                            UdooBlu.this.mUdooBluManager.setNotification(UdooBlu.this.mAddress, UDOOBLESensor.IOPIN_ANALOG, period, notificationListener);
                        }
                    }

                    @Override
                    public void onError(UdooBluException runtimeException) {
                        if (notificationListener != null) {
                            notificationListener.onError(runtimeException);
                        }
                    }
                });
            }
        }
    }

    public void unSubscribeNotificationAnalog(OnBluOperationResult<Boolean> operationResult) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.unSubscribeNotificationAnalog(this.mAddress, operationResult);
        }
    }

    public void setPinAnalogPwmIndex(IOPin ioPin, OnBluOperationResult<Boolean> operationResult) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.setPinAnalogPwmIndex(this.mAddress, ioPin, operationResult);
        }
    }

    public void subscribeNotificationDigital(final INotificationListener<byte[]> notificationListener, final IOPin ... pins) {
        if (this.iOPinVerifier(IOPin.MODE.DIGITAL_INPUT, pins)) {
            if (this.mUdooBluManager != null) {
                this.mUdooBluManager.subscribeNotificationDigital(this.mAddress, notificationListener);
            }
        } else {
            this.iOPinModeBuilder(IOPin.MODE.DIGITAL_INPUT, pins);
            this.setIoPinMode(new OnBluOperationResult<Boolean>(){

                @Override
                public void onSuccess(Boolean aBoolean) {
                    UdooBlu.this.setLocaliOPinConfig(IOPin.MODE.DIGITAL_INPUT, pins);
                    if (UdooBlu.this.mUdooBluManager != null) {
                        UdooBlu.this.mUdooBluManager.subscribeNotificationDigital(UdooBlu.this.mAddress, notificationListener);
                    }
                }

                @Override
                public void onError(UdooBluException runtimeException) {
                    if (runtimeException != null && notificationListener != null) {
                        notificationListener.onError(new UdooBluException(13));
                    }
                }
            }, pins);
        }
    }

    public void unSubscribeNotificationDigital(OnBluOperationResult<Boolean> operationResult) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.unSubscribeNotificationDigital(this.mAddress, operationResult);
        }
    }

    private void readSensor(final String address, final IReaderListener<byte[]> readerListener, final UdooBluManager.SENSORS sensor, final UDOOBLESensor udoobleSensor) {
        int sensVer = this.sensorVerifier(sensor);
        if (sensVer == 1) {
            this.mUdooBluManager.readSensor(address, readerListener, sensor, udoobleSensor);
        } else if (sensVer == 0) {
            this.mUdooBluManager.enableSensor(address, udoobleSensor, true, new OnBluOperationResult<Boolean>(){

                @Override
                public void onSuccess(Boolean aBoolean) {
                    if (aBoolean.booleanValue()) {
                        ((UdooBlu)UdooBlu.this).sensorsEnabled[sensor.ordinal()] = true;
                        UdooBlu.this.readSensor(address, readerListener, sensor, udoobleSensor);
                    } else if (readerListener != null) {
                        readerListener.onError(new UdooBluException(8));
                    }
                }

                @Override
                public void onError(UdooBluException runtimeException) {
                    if (readerListener != null) {
                        readerListener.onError(new UdooBluException(8));
                    }
                }
            });
        } else if (readerListener != null) {
            readerListener.onError(new UdooBluException(11));
        }
    }

    private void setNotification(final String address, final UdooBluManager.SENSORS sensor, final UDOOBLESensor udoobleSensor, final int period, final INotificationListener<byte[]> iNotificationListener) {
        int sensVer = this.sensorVerifier(sensor);
        if (sensVer == 1) {
            this.mUdooBluManager.setNotification(address, udoobleSensor, period, iNotificationListener);
        } else if (sensVer == 0) {
            this.mUdooBluManager.enableSensor(address, udoobleSensor, true, new OnBluOperationResult<Boolean>(){

                @Override
                public void onSuccess(Boolean aBoolean) {
                    if (aBoolean.booleanValue()) {
                        ((UdooBlu)UdooBlu.this).sensorsEnabled[sensor.ordinal()] = true;
                        UdooBlu.this.setNotification(address, sensor, udoobleSensor, period, iNotificationListener);
                    } else if (iNotificationListener != null) {
                        iNotificationListener.onError(new UdooBluException(9));
                    }
                }

                @Override
                public void onError(UdooBluException runtimeException) {
                    if (iNotificationListener != null) {
                        iNotificationListener.onError(new UdooBluException(9));
                    }
                }
            });
        } else if (iNotificationListener != null) {
            iNotificationListener.onError(new UdooBluException(11));
        }
    }

    private void configAnalog(final IOPin.PIN pin, final OnBluOperationResult<Boolean> operationResult) {
        final IOPin ioPin = IOPin.Builder(pin, IOPin.MODE.ANALOG_INPUT);
        if (this.iOPinVerifier(ioPin)) {
            if (this.indexAnalogConfig == ioPin.getIndexValue()) {
                if (operationResult != null) {
                    operationResult.onSuccess(true);
                }
            } else {
                this.mUdooBluManager.setPinAnalogOrPwmIndex(this.mAddress, IOPin.Builder(pin, IOPin.INDEX_VALUE.ANALOG), new OnBluOperationResult<Boolean>(){

                    @Override
                    public void onSuccess(Boolean aBoolean) {
                        if (aBoolean.booleanValue()) {
                            UdooBlu.this.indexAnalogConfig = ioPin.getIndexValue();
                            if (operationResult != null) {
                                operationResult.onSuccess(true);
                            }
                        } else if (operationResult != null) {
                            operationResult.onError(new UdooBluException(9));
                        }
                    }

                    @Override
                    public void onError(UdooBluException runtimeException) {
                        if (runtimeException != null && operationResult != null) {
                            operationResult.onError(new UdooBluException(8));
                        }
                    }
                });
            }
        } else {
            this.iOPinModeBuilder(IOPin.MODE.ANALOG_INPUT, ioPin);
            this.setIoPinMode(new OnBluOperationResult<Boolean>(){

                @Override
                public void onSuccess(Boolean aBoolean) {
                    if (aBoolean.booleanValue()) {
                        UdooBlu.this.configAnalog(pin, operationResult);
                    } else if (operationResult != null) {
                        operationResult.onError(new UdooBluException(9));
                    }
                }

                @Override
                public void onError(UdooBluException runtimeException) {
                    if (runtimeException != null && operationResult != null) {
                        operationResult.onError(new UdooBluException(8));
                    }
                }
            }, ioPin);
        }
    }

    private void setLocaliOPinConfig(IOPin.MODE mode, IOPin ... ioPins) {
        for (int i = 0; i < this.iOPinConfig.length && i < ioPins.length; ++i) {
            this.iOPinConfig[ioPins[i].pin.ordinal()] = (byte)mode.ordinal();
        }
    }

    private boolean iOPinVerifier(IOPin.MODE mode, IOPin ... ioPins) {
        boolean configured = true;
        for (int i = 0; i < this.iOPinConfig.length && i < ioPins.length; ++i) {
            if (this.iOPinConfig[ioPins[i].pin.ordinal()] == mode.ordinal()) continue;
            configured = false;
        }
        return configured;
    }

    private boolean iOPinVerifier(IOPin ... ioPins) {
        boolean configured = true;
        block0: for (IOPin ioPin : ioPins) {
            for (int j = 0; j < this.mIOPins.length; ++j) {
                if (this.mIOPins[j] == null || ioPin.pin != this.mIOPins[j].pin || ioPin.mode == this.mIOPins[j].mode) continue;
                configured = false;
                continue block0;
            }
        }
        return configured;
    }

    private void iOPinModeBuilder(IOPin.MODE mode, IOPin ... ioPins) {
        for (int i = 0; i < ioPins.length; ++i) {
            ioPins[i].mode = mode;
        }
    }

    private IOPin[] mergeWithLocalIOPinConfig(IOPin ... ioPins) {
        IOPin[] tmpIOPins = (IOPin[])this.mIOPins.clone();
        int len = ioPins.length;
        if (len > 8) {
            len = 8;
        }
        for (int i = 0; i < len; ++i) {
            int j;
            IOPin ioPin = ioPins[i];
            boolean found = false;
            for (j = 0; !found && j < tmpIOPins.length; ++j) {
                if (tmpIOPins[j] == null || ioPin.pin != tmpIOPins[j].pin) continue;
                tmpIOPins[j] = ioPin;
                found = true;
            }
            if (found) continue;
            for (j = 0; j < tmpIOPins.length; ++j) {
                if (tmpIOPins[j] != null) continue;
                tmpIOPins[j] = ioPin;
                j = tmpIOPins.length;
            }
        }
        return tmpIOPins;
    }

    private int sensorVerifier(UdooBluManager.SENSORS sensors) {
        return this.sensorsDetected[sensors.ordinal()] ? (this.sensorsEnabled[sensors.ordinal()] ? 1 : 0) : -1;
    }

    static /* synthetic */ IOPin[] access$002(UdooBlu x0, IOPin[] x1) {
        x0.mIOPins = x1;
        return x1;
    }
}

