/*
 * Decompiled with CFR 0.152.
 */
package org.udoo.udooblulib.utils;

import android.util.Log;

public class BitUtility {
    private static final String TAG = "BinUtility";

    public static byte setOnlyValuePosByte(boolean high, int pos) {
        if (pos > 128) {
            return 0;
        }
        return (byte)((high ? 1 : 0) << pos & 0xFF);
    }

    public static byte setValuesPosByte(boolean high, int ... positon) {
        byte out = 0;
        if (positon.length == 0 && high) {
            out = -1;
        } else {
            for (int i = 0; i < positon.length; ++i) {
                int pos = positon[i];
                out = (byte)(out | pos);
            }
        }
        return out;
    }

    public static byte setValuePosByte(boolean high, int pos, byte oldValue) {
        if (pos > 8) {
            return 0;
        }
        return (byte)((high ? 1 : 0) << pos & 0xFF | oldValue);
    }

    public static void LogBinValue(byte[] value, boolean inverse) {
        if (value != null) {
            int size = value.length;
            if (inverse) {
                String sValueBin = "";
                for (int i = 0; i < size; ++i) {
                    sValueBin = " " + value[i] + sValueBin;
                    for (int k = 0; k < 8; ++k) {
                        sValueBin = ((value[i] & 1 << k) != 0 ? "1" : "0") + sValueBin;
                    }
                    sValueBin = " " + sValueBin;
                }
                Log.i((String)TAG, (String)("LogValue: " + sValueBin));
            } else {
                String sValueBin = "";
                for (int i = size - 1; i >= 0; --i) {
                    sValueBin = " " + value[i] + sValueBin;
                    for (int k = 0; k < 8; ++k) {
                        sValueBin = ((value[i] & 1 << k) != 0 ? "1" : "0") + sValueBin;
                    }
                    sValueBin = " " + sValueBin;
                }
                Log.i((String)TAG, (String)("LogValue: " + sValueBin));
            }
        } else {
            Log.i((String)TAG, (String)"LogValue: null value");
        }
    }

    public static byte ToUnsignedByte(int value) {
        return (byte)value;
    }

    public static byte[] ToBytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return result;
    }

    public static byte[] To2Bytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 8), (byte)i};
        return result;
    }
}

