/*
 * Decompiled with CFR 0.152.
 */
package org.udoo.udooblulib.sensor;

import android.bluetooth.BluetoothGattCharacteristic;
import java.util.UUID;
import org.udoo.udooblulib.model.IOPin;
import org.udoo.udooblulib.sensor.Constant;
import org.udoo.udooblulib.sensor.UDOOBLE;
import org.udoo.udooblulib.utils.BitUtility;
import org.udoo.udooblulib.utils.Point3D;

public enum UDOOBLESensor {
    ACCELEROMETER(UDOOBLE.UUID_ACC_SERV, UDOOBLE.UUID_ACC_DATA, UDOOBLE.UUID_SENSOR_CONF){

        @Override
        public Point3D convert(byte[] value) {
            float x = (float)((short)(value[1] << 8 | value[0] & 0xFF)) * 0.0024244f;
            float y = (float)((short)(value[3] << 8 | value[2] & 0xFF)) * 0.0024244f;
            float z = (float)((short)(value[5] << 8 | value[4] & 0xFF)) * 0.0024244f;
            return new Point3D(x, y, z);
        }
    }
    ,
    MAGNETOMETER(UDOOBLE.UUID_MAG_SERV, UDOOBLE.UUID_MAG_DATA, UDOOBLE.UUID_SENSOR_CONF){

        @Override
        public Point3D convert(byte[] value) {
            float x = (float)((short)(value[1] << 8 | value[0] & 0xFF)) / 100.0f;
            float y = (float)((short)(value[3] << 8 | value[2] & 0xFF)) / 100.0f;
            float z = (float)((short)(value[5] << 8 | value[4] & 0xFF)) / 100.0f;
            return new Point3D(x, y, z);
        }
    }
    ,
    GYROSCOPE(UDOOBLE.UUID_GYR_SERV, UDOOBLE.UUID_GYR_DATA, UDOOBLE.UUID_SENSOR_CONF){

        @Override
        public Point3D convert(byte[] value) {
            float x = (float)((short)(value[1] << 8 | value[0] & 0xFF)) * 0.00625f;
            float y = (float)((short)(value[3] << 8 | value[2] & 0xFF)) * 0.00625f;
            float z = (float)((short)(value[5] << 8 | value[4] & 0xFF)) * 0.00625f;
            return new Point3D(x, y, z);
        }
    }
    ,
    CAPACITIVE_BUTTON(UDOOBLE.UUID_KEY_SERV, UDOOBLE.UUID_KEY_DATA, null){

        @Override
        public Integer convertKeys(byte[] value) {
            return value[0];
        }
    }
    ,
    TEMPERATURE(UDOOBLE.UUID_TEM_SERV, UDOOBLE.UUID_TEM_DATA, UDOOBLE.UUID_SENSOR_CONF){

        @Override
        public int convertTemp(byte[] value) {
            int rbit = (int)Constant.TemperatureTable[0][0];
            float ris = Constant.TemperatureTable[0][1];
            int rBit = rbit - 8;
            return (int)((float)(value[1] << rBit | value[0] & rBit) * ris);
        }
    }
    ,
    BAROMETER_P(UDOOBLE.UUID_BAR_SERV, UDOOBLE.UUID_BAR_PRESS_DATA, UDOOBLE.UUID_SENSOR_CONF){

        @Override
        public int convertBar(byte[] value) {
            int test = (value[2] << 16 | value[1] << 8 & 0xFF00 | value[0] & 0xFF) / 4000;
            return test;
        }
    }
    ,
    BAROMETER_A(UDOOBLE.UUID_BAR_SERV, UDOOBLE.UUID_BAR_ALTIT_DATA, UDOOBLE.UUID_SENSOR_CONF){

        @Override
        public int convertBar(byte[] value) {
            return value[2] << 16 | value[1] << 8 & 0xFF | value[0] & 0xFFFF;
        }
    }
    ,
    IOPIN_DIGITAL(UDOOBLE.UUID_IOPIN_SERV, UDOOBLE.UUID_IOPIN_DIGITAL_DATA, UDOOBLE.UUID_SENSOR_CONF){

        @Override
        public boolean[] convertIOPinDigital(byte[] value, IOPin ... pins) {
            boolean[] iopin = new boolean[pins.length];
            BitUtility.LogBinValue(value, false);
            for (int i = 0; i < pins.length; ++i) {
                short pinVal = (short)(1 << pins[i].getPinValue());
                iopin[i] = (value[0] & pinVal) == pinVal;
            }
            return iopin;
        }
    }
    ,
    IOPIN_ANALOG(UDOOBLE.UUID_IOPIN_SERV, UDOOBLE.UUID_IOPIN_ANALOG_READ, UDOOBLE.UUID_SENSOR_CONF){

        @Override
        public short convertADC(byte[] value) {
            return (short)(value[1] << 8 | value[0] & 0xFF);
        }
    }
    ,
    HUMIDITY(UDOOBLE.UUID_HUM_SERV, UDOOBLE.UUID_HUM_DATA, UDOOBLE.UUID_SENSOR_CONF){

        @Override
        public int convertHumidity(byte[] value) {
            int rHum = (short)(value[1] << 8 & 0xF000) | value[0] & 0xFF;
            int rh = 125 * rHum / 65536 - 6;
            if (rh < 0) {
                rh = 0;
            } else if (rh > 100) {
                rh = 100;
            }
            return rh;
        }
    }
    ,
    AMBIENT_LIGHT(UDOOBLE.UUID_AMB_LIG_SERV, UDOOBLE.UUID_AMB_LIG_DATA, UDOOBLE.UUID_SENSOR_CONF){

        @Override
        public int convertAmbientLight(byte[] value) {
            return (short)(value[1] << 8 | value[0] & 0xFF);
        }
    };

    private final UUID service;
    private final UUID data;
    private final UUID config;
    private byte enableCode;
    public static final byte DISABLE_SENSOR_CODE = 0;
    public static final byte ENABLE_SENSOR_CODE = 1;
    public static final byte CALIBRATE_SENSOR_CODE = 2;
    public static final UDOOBLESensor[] SENSOR_LIST;

    private static Integer shortSignedAtOffset(byte[] c, int offset) {
        Integer lowerByte = c[offset] & 0xFF;
        Integer upperByte = c[offset + 1];
        return (upperByte << 8) + lowerByte;
    }

    private static Integer shortUnsignedAtOffset(byte[] c, int offset) {
        Integer lowerByte = c[offset] & 0xFF;
        Integer upperByte = c[offset + 1] & 0xFF;
        return (upperByte << 8) + lowerByte;
    }

    public void onCharacteristicChanged(BluetoothGattCharacteristic c) {
        throw new UnsupportedOperationException("Programmer error, the individual enum classes are supposed to override this method.");
    }

    public Integer convertKeys(byte[] value) {
        throw new UnsupportedOperationException("Programmer error, the individual enum classes are supposed to override this method.");
    }

    public Point3D convert(byte[] value) {
        throw new UnsupportedOperationException("Programmer error, the individual enum classes are supposed to override this method.");
    }

    public int convertTemp(byte[] value) {
        throw new UnsupportedOperationException("Programmer error, the individual enum classes are supposed to override this method.");
    }

    public int convertBar(byte[] value) {
        throw new UnsupportedOperationException("Programmer error, the individual enum classes are supposed to override this method.");
    }

    public boolean[] convertIOPinDigital(byte[] value, IOPin ... pin) {
        throw new UnsupportedOperationException("Programmer error, the individual enum classes are supposed to override this method.");
    }

    public short convertADC(byte[] value) {
        throw new UnsupportedOperationException("Programmer error, the individual enum classes are supposed to override this method.");
    }

    public int convertHumidity(byte[] value) {
        throw new UnsupportedOperationException("Programmer error, the individual enum classes are supposed to override this method.");
    }

    public int convertAmbientLight(byte[] value) {
        throw new UnsupportedOperationException("Programmer error, the individual enum classes are supposed to override this method.");
    }

    private UDOOBLESensor(UUID service, UUID data, UUID config) {
        this.service = service;
        this.data = data;
        this.config = config;
        this.enableCode = 1;
    }

    public byte getEnableSensorCode() {
        return this.enableCode;
    }

    public UUID getService() {
        return this.service;
    }

    public UUID getData() {
        return this.data;
    }

    public UUID getConfig() {
        return this.config;
    }

    public static UDOOBLESensor getFromDataUuid(UUID uuid) {
        for (UDOOBLESensor s : UDOOBLESensor.values()) {
            if (!s.getData().equals(uuid)) continue;
            return s;
        }
        throw new RuntimeException("Programmer error, unable to find uuid.");
    }

    static {
        SENSOR_LIST = new UDOOBLESensor[]{ACCELEROMETER, MAGNETOMETER, GYROSCOPE, CAPACITIVE_BUTTON, TEMPERATURE};
    }
}

