/*
 * Decompiled with CFR 0.152.
 */
package org.udoo.udooblulib.service;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.udoo.udooblulib.common.GattInfo;
import org.udoo.udooblulib.exceptions.UdooBluException;
import org.udoo.udooblulib.interfaces.IBleDeviceListener;
import org.udoo.udooblulib.scan.BluScanCallBack;
import org.udoo.udooblulib.sensor.UDOOBLE;
import org.udoo.udooblulib.utils.SeqObserverQueue;

public class UdooBluService
extends Service {
    static final String TAG = "BluetoothLeService";
    public static final String ACTION_GATT_CONNECTED = "ACTION_GATT_CONNECTED";
    public static final String ACTION_GATT_DISCONNECTED = "ACTION_GATT_DISCONNECTED";
    public static final String ACTION_GATT_SERVICES_DISCOVERED = "ACTION_GATT_SERVICES_DISCOVERED";
    public static final String ACTION_DATA_READ = "ACTION_DATA_READ";
    public static final String ACTION_DATA_NOTIFY = "ACTION_DATA_NOTIFY";
    public static final String ACTION_DATA_WRITE = "ACTION_DATA_WRITE";
    public static final String ACTION_DESCRIPTION_WRITE = "ACTION_DESCRIPTION_WRITE";
    public static final String EXTRA_DATA = "EXTRA_DATA";
    public static final String EXTRA_UUID = "EXTRA_UUID";
    public static final String EXTRA_STATUS = "EXTRA_STATUS";
    public static final String EXTRA_ADDRESS = "EXTRA_ADDRESS";
    private BluetoothManager mBluetoothManager = null;
    private BluetoothAdapter mBtAdapter = null;
    private static final long SCAN_PERIOD = 20000L;
    private HashMap<String, BluetoothGatt> mBluetoothGatts;
    private BlockingQueue<Callable> voidBlockingQueue = new LinkedBlockingQueue<Callable>(10);
    private SeqObserverQueue seqObserverQueue = new SeqObserverQueue(this.voidBlockingQueue);
    private BluetoothLeScanner mLEScanner;
    private AtomicBoolean mScanning;
    private final IBinder binder = new LocalBinder();

    private void broadcastUpdate(String action, String address, int status) {
        Intent intent = new Intent(action);
        intent.putExtra(EXTRA_ADDRESS, address);
        intent.putExtra(EXTRA_STATUS, status);
        this.sendBroadcast(intent);
    }

    private void broadcastUpdate(String action, BluetoothGattCharacteristic characteristic, int status) {
        Intent intent = new Intent(action);
        intent.putExtra(EXTRA_UUID, characteristic.getUuid().toString());
        intent.putExtra(EXTRA_DATA, characteristic.getValue());
        intent.putExtra(EXTRA_STATUS, status);
        this.sendBroadcast(intent);
    }

    private void broadcastUpdate(String action, String address, BluetoothGattCharacteristic characteristic, int status) {
        Intent intent = new Intent(action);
        intent.putExtra(EXTRA_UUID, characteristic.getUuid().toString());
        intent.putExtra(EXTRA_ADDRESS, address);
        intent.putExtra(EXTRA_DATA, characteristic.getValue());
        intent.putExtra(EXTRA_STATUS, status);
        this.sendBroadcast(intent);
    }

    private boolean checkGatt(String mac) {
        if (this.mBtAdapter == null) {
            Log.w((String)TAG, (String)"BluetoothAdapter not initialized");
            return false;
        }
        if (this.mBluetoothGatts.containsKey(mac) && this.mBluetoothGatts.get(mac) != null) {
            Log.w((String)TAG, (String)("BluetoothGatt :" + mac + " not initialized"));
            return false;
        }
        return true;
    }

    private BluetoothGatt checkAndGetGattItem(String mac) {
        BluetoothGatt bluetoothGatt = null;
        if (this.mBluetoothGatts.containsKey(mac)) {
            bluetoothGatt = this.mBluetoothGatts.get(mac);
            if (bluetoothGatt != null) {
                if (this.mBtAdapter == null) {
                    bluetoothGatt = null;
                    Log.w((String)TAG, (String)"BluetoothAdapter not initialized");
                }
            } else {
                Log.w((String)TAG, (String)("BluetoothGatt :" + mac + " not initialized"));
            }
        }
        return bluetoothGatt;
    }

    public BluetoothGattService getService(String mBleAddress, UUID uuidLedServ) {
        BluetoothGattService gattService = null;
        BluetoothGatt bluetoothGatt = this.checkAndGetGattItem(mBleAddress);
        if (bluetoothGatt != null) {
            gattService = bluetoothGatt.getService(uuidLedServ);
        }
        return gattService;
    }

    public void onCreate() {
        super.onCreate();
        Log.i((String)TAG, (String)"onCreate: ");
    }

    public IBinder onBind(Intent intent) {
        Log.i((String)TAG, (String)"onBind: ");
        return this.binder;
    }

    public boolean onUnbind(Intent intent) {
        Log.i((String)TAG, (String)"onUnBind: ");
        this.close();
        return super.onUnbind(intent);
    }

    public boolean initialize() {
        Log.d((String)TAG, (String)"initialize");
        this.mBluetoothGatts = new HashMap();
        this.mScanning = new AtomicBoolean(false);
        this.seqObserverQueue.run();
        return true;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.i((String)TAG, (String)("Received start id " + startId + ": " + intent));
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)TAG, (String)"onDestroy() called");
        this.close();
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
        Log.i((String)TAG, (String)"onRebind:");
    }

    public boolean bond(String address) {
        boolean success = false;
        Set bluetoothDevices = this.mBtAdapter.getBondedDevices();
        boolean bond = false;
        for (BluetoothDevice bluetoothDevice : bluetoothDevices) {
            if (!bluetoothDevice.getAddress().equals(address)) continue;
            bond = true;
        }
        if (!bond) {
            BluetoothDevice bluetoothDevice;
            BluetoothGatt bluetoothGatt = this.checkAndGetGattItem(address);
            if (bluetoothGatt != null && (bluetoothDevice = bluetoothGatt.getDevice()) != null) {
                success = bluetoothDevice.createBond();
            }
        } else {
            success = true;
        }
        return success;
    }

    public void readCharacteristic(final String mac, final BluetoothGattCharacteristic characteristic) {
        try {
            this.voidBlockingQueue.put(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BluetoothGatt bluetoothGatt = UdooBluService.this.checkAndGetGattItem(mac);
                    boolean success = false;
                    if (bluetoothGatt != null && characteristic != null) {
                        success = bluetoothGatt.readCharacteristic(characteristic);
                    }
                    return success;
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void writeCharacteristic(final String address, final BluetoothGattCharacteristic characteristic, final byte[] b) {
        try {
            this.voidBlockingQueue.put(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    boolean result = false;
                    BluetoothGatt bluetoothGatt = UdooBluService.this.checkAndGetGattItem(address);
                    if (bluetoothGatt != null) {
                        characteristic.setValue(b);
                        result = bluetoothGatt.writeCharacteristic(characteristic);
                        if (!result) {
                            UdooBluService.this.broadcastUpdate(UdooBluService.ACTION_DATA_WRITE, address, characteristic, 3);
                        }
                    }
                    return result;
                }
            });
        }
        catch (InterruptedException e) {
            this.broadcastUpdate(ACTION_DATA_WRITE, address, characteristic, 3);
        }
    }

    public boolean writeCharacteristicNonBlock(String address, BluetoothGattCharacteristic characteristic, byte[] b) {
        boolean result = false;
        BluetoothGatt bluetoothGatt = this.checkAndGetGattItem(address);
        if (bluetoothGatt != null) {
            characteristic.setValue(b);
            result = bluetoothGatt.writeCharacteristic(characteristic);
        }
        return result;
    }

    public boolean scanServices(String mac) {
        BluetoothGatt bluetoothGatt = this.checkAndGetGattItem(mac);
        boolean result = false;
        if (bluetoothGatt != null) {
            result = bluetoothGatt.discoverServices();
        }
        return result;
    }

    public int getNumServices(String mac) {
        BluetoothGatt bluetoothGatt;
        int res = 0;
        if (this.mBluetoothGatts.containsKey(mac) && (bluetoothGatt = this.mBluetoothGatts.get(mac)) != null) {
            res = bluetoothGatt.getServices().size();
        }
        return res;
    }

    public List<BluetoothGattService> getSupportedGattServices(String mac) {
        BluetoothGatt bluetoothGatt;
        List<Object> list = new ArrayList<BluetoothGattService>();
        if (this.mBluetoothGatts.containsKey(mac) && (bluetoothGatt = this.mBluetoothGatts.get(mac)) != null) {
            list = bluetoothGatt.getServices();
        }
        return list;
    }

    public void setCharacteristicNotification(final String address, final BluetoothGattCharacteristic characteristic, final boolean enable) {
        try {
            this.voidBlockingQueue.put(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BluetoothGatt bluetoothGatt = UdooBluService.this.checkAndGetGattItem(address);
                    boolean result = false;
                    if (bluetoothGatt != null && bluetoothGatt.setCharacteristicNotification(characteristic, enable)) {
                        BluetoothGattDescriptor clientConfig = characteristic.getDescriptor(GattInfo.CLIENT_CHARACTERISTIC_CONFIG);
                        if (clientConfig != null) {
                            if (enable) {
                                Log.i((String)UdooBluService.TAG, (String)"enable notification");
                                clientConfig.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                            } else {
                                Log.i((String)UdooBluService.TAG, (String)"disable notification");
                                clientConfig.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
                            }
                            result = bluetoothGatt.writeDescriptor(clientConfig);
                        }
                    } else {
                        Log.w((String)UdooBluService.TAG, (String)"setCharacteristicNotification failed");
                    }
                    return result;
                }
            });
        }
        catch (InterruptedException e) {
            this.broadcastUpdate(ACTION_DATA_WRITE, address, characteristic, 3);
        }
    }

    public boolean isNotificationEnabled(String mac, BluetoothGattCharacteristic characteristic) {
        BluetoothGattDescriptor clientConfig;
        BluetoothGatt bluetoothGatt = this.checkAndGetGattItem(mac);
        boolean result = false;
        if (bluetoothGatt != null && (clientConfig = characteristic.getDescriptor(GattInfo.CLIENT_CHARACTERISTIC_CONFIG)) != null) {
            result = clientConfig.getValue() == BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
        }
        return result;
    }

    public void scanLeDevice(boolean enable, final BluScanCallBack scanCallback) {
        ArrayList<ScanFilter> scanFilters = new ArrayList<ScanFilter>();
        ScanFilter scanFilter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(UDOOBLE.UUID_SENSORS_SERV)).build();
        scanFilters.add(scanFilter);
        ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(2).build();
        UdooBluException udooBluException = this.checkBluetooth(this.getApplicationContext());
        if (udooBluException != null) {
            if (scanCallback != null) {
                scanCallback.onError(udooBluException);
            }
        } else {
            this.mLEScanner = this.mBtAdapter.getBluetoothLeScanner();
            if (enable && this.mScanning.compareAndSet(false, true)) {
                this.mLEScanner.startScan(scanFilters, scanSettings, (ScanCallback)scanCallback);
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        UdooBluService.this.mLEScanner.stopScan((ScanCallback)scanCallback);
                        UdooBluService.this.mScanning.set(false);
                        if (scanCallback != null) {
                            scanCallback.onScanFinished();
                        }
                    }
                }, 20000L);
            } else {
                this.mScanning.set(false);
                this.mLEScanner.stopScan((ScanCallback)scanCallback);
                if (scanCallback != null) {
                    scanCallback.onScanFinished();
                }
            }
        }
    }

    public void connect(String address, IBleDeviceListener iBleDeviceListener) {
        UdooBluException udooBluException = this.checkBluetooth(this.getApplicationContext());
        if (udooBluException != null) {
            if (iBleDeviceListener != null) {
                iBleDeviceListener.onError(udooBluException);
            }
        } else {
            BluetoothDevice device = this.mBtAdapter.getRemoteDevice(address);
            int connectionState = this.mBluetoothManager.getConnectionState(device, 7);
            BluetoothGatt bluetoothGatt = this.checkAndGetGattItem(address);
            if (connectionState == 0) {
                if (bluetoothGatt != null) {
                    Log.d((String)TAG, (String)"Re-use GATT connection");
                    if (!bluetoothGatt.connect()) {
                        Log.w((String)TAG, (String)"GATT re-connect failed.");
                    }
                } else if (device == null) {
                    Log.w((String)TAG, (String)"Device not found.  Unable to connect.");
                } else {
                    Log.d((String)TAG, (String)"Create a new GATT connection.");
                    bluetoothGatt = device.connectGatt((Context)this, false, this.bluetoothGattCallbackBuilder());
                    this.mBluetoothGatts.put(address, bluetoothGatt);
                }
            } else {
                Log.w((String)TAG, (String)("Attempt to connect in state: " + connectionState));
                this.bond(address);
                bluetoothGatt = device.connectGatt((Context)this, false, this.bluetoothGattCallbackBuilder());
                this.mBluetoothGatts.put(address, bluetoothGatt);
            }
        }
    }

    public void disconnect(String address) {
        if (this.mBtAdapter == null) {
            Log.w((String)TAG, (String)"disconnect: BluetoothAdapter not initialized");
            return;
        }
        BluetoothDevice device = this.mBtAdapter.getRemoteDevice(address);
        int connectionState = this.mBluetoothManager.getConnectionState(device, 7);
        BluetoothGatt bluetoothGatt = this.checkAndGetGattItem(address);
        if (bluetoothGatt != null) {
            Log.i((String)TAG, (String)"disconnect");
            if (connectionState != 0) {
                bluetoothGatt.disconnect();
            } else {
                Log.w((String)TAG, (String)("Attempt to disconnect in state: " + connectionState));
            }
        }
    }

    public void close() {
        Set<String> macs = this.mBluetoothGatts.keySet();
        for (String deviceMac : macs) {
            BluetoothGatt bluetoothGatt = this.mBluetoothGatts.get(deviceMac);
            if (bluetoothGatt == null) continue;
            bluetoothGatt.close();
            this.mBluetoothGatts.remove(deviceMac);
        }
    }

    public int numConnectedDevices() {
        List devList = this.mBluetoothManager.getConnectedDevices(7);
        return devList.size();
    }

    private BluetoothGattCallback bluetoothGattCallbackBuilder() {
        return new BluetoothGattCallback(){

            public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
                if (gatt == null) {
                    Log.e((String)UdooBluService.TAG, (String)"mBluetoothGatt not created!");
                    return;
                }
                BluetoothDevice device = gatt.getDevice();
                String address = device.getAddress();
                Log.d((String)UdooBluService.TAG, (String)("onConnectionStateChange (" + address + ") " + newState + " status: " + status));
                try {
                    switch (newState) {
                        case 2: {
                            UdooBluService.this.broadcastUpdate(UdooBluService.ACTION_GATT_CONNECTED, address, status);
                            break;
                        }
                        case 0: {
                            UdooBluService.this.broadcastUpdate(UdooBluService.ACTION_GATT_DISCONNECTED, address, status);
                            break;
                        }
                        default: {
                            Log.e((String)UdooBluService.TAG, (String)("New state not processed: " + newState));
                            break;
                        }
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }

            public void onServicesDiscovered(BluetoothGatt gatt, int status) {
                BluetoothDevice device = gatt.getDevice();
                UdooBluService.this.broadcastUpdate(UdooBluService.ACTION_GATT_SERVICES_DISCOVERED, device.getAddress(), status);
            }

            public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                UdooBluService.this.broadcastUpdate(UdooBluService.ACTION_DATA_NOTIFY, gatt.getDevice().getAddress(), characteristic, 0);
            }

            public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                UdooBluService.this.broadcastUpdate(UdooBluService.ACTION_DATA_READ, gatt.getDevice().getAddress(), characteristic, status);
            }

            public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                UdooBluService.this.broadcastUpdate(UdooBluService.ACTION_DATA_WRITE, gatt.getDevice().getAddress(), characteristic, status);
            }

            public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
                Log.i((String)UdooBluService.TAG, (String)"onDescriptorRead");
            }

            public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
                UdooBluService.this.broadcastUpdate(UdooBluService.ACTION_DESCRIPTION_WRITE, gatt.getDevice().getAddress(), status);
            }
        };
    }

    public UdooBluException checkBluetooth(Context context) {
        UdooBluException udooBluException = null;
        if (!this.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            udooBluException = new UdooBluException(2);
        } else {
            if (this.mBluetoothManager == null) {
                this.mBluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
            }
            if (this.mBluetoothManager == null) {
                udooBluException = new UdooBluException(1);
            }
            if (this.mBtAdapter == null) {
                this.mBtAdapter = this.mBluetoothManager.getAdapter();
            }
            if (this.mBtAdapter == null || !this.mBtAdapter.isEnabled()) {
                udooBluException = new UdooBluException(3);
            } else if (Build.VERSION.SDK_INT >= 23) {
                if (!this.isLocationPermissionApproved(context)) {
                    udooBluException = new UdooBluException(5);
                } else if (!this.isLocationProviderEnabled((LocationManager)context.getSystemService("location"))) {
                    udooBluException = new UdooBluException(6);
                }
            }
        }
        return udooBluException;
    }

    public boolean isLocationPermissionApproved(Context context) {
        return this.isPermissionGranted("android.permission.ACCESS_COARSE_LOCATION", context) || this.isPermissionGranted("android.permission.ACCESS_FINE_LOCATION", context);
    }

    public boolean isLocationProviderEnabled(LocationManager locationManager) {
        return locationManager.isProviderEnabled("network") || locationManager.isProviderEnabled("gps") || Build.MODEL.equals("UDOONEO-MX6SX") || Build.MODEL.equals("UDOO-MX6DQ");
    }

    private boolean isPermissionGranted(String permission2, Context context) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public boolean requestConnectionPriority(String address, int connectionPriority) {
        boolean result = false;
        BluetoothGatt bluetoothGatt = this.checkAndGetGattItem(address);
        if (bluetoothGatt != null) {
            result = bluetoothGatt.requestConnectionPriority(connectionPriority);
        }
        return result;
    }

    public class LocalBinder
    extends Binder {
        public UdooBluService getService() {
            return UdooBluService.this;
        }
    }
}

