/*
 * Decompiled with CFR 0.152.
 */
package org.udoo.udooblulib.activity;

import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.widget.Toast;
import org.udoo.udooblulib.R;
import org.udoo.udooblulib.UdooBlu;
import org.udoo.udooblulib.exceptions.UdooBluException;
import org.udoo.udooblulib.interfaces.IBleDeviceListener;
import org.udoo.udooblulib.interfaces.IBluManagerCallback;
import org.udoo.udooblulib.manager.UdooBluManager;
import org.udoo.udooblulib.model.IOPin;
import org.udoo.udooblulib.scan.BluScanCallBack;

public abstract class UdooBluAppCompatActivity
extends AppCompatActivity {
    private static final int PERMISSION_REQUEST_COARSE_LOCATION = 1;
    private static final int REQUEST_ENABLE_BT = 2;
    private static final int REQUEST_ENABLE_LOCATION = 3;
    private boolean mBleSupported = true;
    private static BluetoothManager mBluetoothManager = null;
    private BluetoothAdapter mBtAdapter = null;
    private final String TAG = "UdooBluAct";
    private UdooBluManager mUdooBluManager;
    private boolean mScan;
    public static final int HIGH = IOPin.DIGITAL_VALUE.HIGH.ordinal();
    public static final int LOW = IOPin.DIGITAL_VALUE.LOW.ordinal();
    private BluScanCallBack scanCallback = new BluScanCallBack(){

        public void onScanResult(int callbackType, ScanResult result) {
            BluetoothDevice device;
            super.onScanResult(callbackType, result);
            if (result != null && (device = result.getDevice()) != null) {
                UdooBluAppCompatActivity.this.onBluDiscovered(result.getRssi(), device);
            }
        }

        @Override
        public void onScanFinished() {
            UdooBluAppCompatActivity.this.mScan = false;
            UdooBluAppCompatActivity.this.onBluScanFinished();
        }

        @Override
        public void onError(UdooBluException runtimeException) {
            UdooBluAppCompatActivity.this.mScan = false;
            UdooBluAppCompatActivity.this.onBluError(runtimeException);
        }

        public void onScanFailed(int errorCode) {
            super.onScanFailed(errorCode);
            UdooBluAppCompatActivity.this.mScan = false;
            this.onError(new UdooBluException(errorCode));
            UdooBluAppCompatActivity.this.onBluScanFailed();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!this.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            Toast.makeText((Context)this, (int)R.string.ble_not_supported, (int)1).show();
            this.mBleSupported = false;
        }
        mBluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
        this.mBtAdapter = mBluetoothManager.getAdapter();
        if (this.mBtAdapter == null || !this.mBtAdapter.isEnabled()) {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            this.startActivityForResult(enableBtIntent, 2);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setTitle((CharSequence)"This app needs location access");
                builder.setMessage((CharSequence)"Please grant location access so this app can detect beacons.");
                builder.setPositiveButton(17039370, null);
                builder.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialog) {
                        if (Build.VERSION.SDK_INT >= 23) {
                            UdooBluAppCompatActivity.this.requestPermissions(new String[]{"android.permission.ACCESS_COARSE_LOCATION"}, 1);
                        }
                    }
                });
                builder.show();
            } else if (this.isLocationProviderEnabled((LocationManager)this.getSystemService("location"))) {
                this.initBluManager();
            } else {
                Intent myIntent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                this.startActivityForResult(myIntent, 3);
            }
        } else if (savedInstanceState == null && this.mBleSupported) {
            this.initBluManager();
        }
    }

    private void initBluManager() {
        UdooBluManager.GetUdooBluManager((Context)this, new IBluManagerCallback(){

            @Override
            public void onBluManagerReady(UdooBluManager udooBluManager) {
                UdooBluAppCompatActivity.this.mUdooBluManager = udooBluManager;
                UdooBluAppCompatActivity.this.onUdooBluManagerReady();
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 1: {
                if (grantResults[0] == 0) {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (UdooBluAppCompatActivity.this.isLocationProviderEnabled((LocationManager)UdooBluAppCompatActivity.this.getSystemService("location"))) {
                                UdooBluAppCompatActivity.this.initBluManager();
                            } else {
                                Intent myIntent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                                UdooBluAppCompatActivity.this.startActivityForResult(myIntent, 3);
                            }
                        }
                    });
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                    builder.setTitle((CharSequence)"Functionality limited");
                    builder.setMessage((CharSequence)"Since location access has not been granted, this app will not be able to discover beacons when in the background.");
                    builder.setPositiveButton(17039370, null);
                    builder.setOnDismissListener(new DialogInterface.OnDismissListener(){

                        public void onDismiss(DialogInterface dialog) {
                        }
                    });
                    builder.show();
                }
                return;
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 2: {
                if (resultCode == -1) {
                    Toast.makeText((Context)this, (int)R.string.bt_on, (int)0).show();
                    break;
                }
                Toast.makeText((Context)this, (int)R.string.bt_not_on, (int)0).show();
                this.finish();
                break;
            }
            case 3: {
                if (!this.isLocationProviderEnabled((LocationManager)this.getSystemService("location"))) break;
                this.initBluManager();
                break;
            }
            default: {
                Log.e((String)"UdooBluAct", (String)"Unknown request code");
            }
        }
    }

    public void startScan() {
        if (this.mScan) {
            this.mUdooBluManager.scanLeDevice(false, this.scanCallback);
        } else {
            this.mUdooBluManager.scanLeDevice(true, this.scanCallback);
            this.mScan = true;
        }
    }

    public void stopScan() {
        if (this.mScan) {
            this.mUdooBluManager.scanLeDevice(false, this.scanCallback);
        }
    }

    public void connect(String address) {
        if (this.mUdooBluManager != null) {
            this.mUdooBluManager.connect(address, new IBleDeviceListener(){

                @Override
                public void onDeviceConnected(UdooBlu udooBlu) {
                    UdooBluAppCompatActivity.this.onBluConnected(udooBlu);
                }

                @Override
                public void onDeviceDisconnect(String address) {
                    UdooBluAppCompatActivity.this.onBluDisconnected(address);
                }

                @Override
                public void onError(UdooBluException runtimeException) {
                    UdooBluAppCompatActivity.this.onBluError(runtimeException);
                }
            });
        }
    }

    public abstract void onUdooBluManagerReady();

    public abstract void onBluConnected(UdooBlu var1);

    public abstract void onBluDisconnected(String var1);

    public abstract void onBluDiscovered(int var1, BluetoothDevice var2);

    public abstract void onBluScanFinished();

    public abstract void onBluScanFailed();

    public void onBluError(UdooBluException e) {
        if (e != null) {
            String err;
            Log.i((String)"UdooBluAct", (String)("onBluError: " + e.getReason()));
            switch (e.getReason()) {
                case 0: {
                    err = "Service not ready";
                    break;
                }
                case 1: {
                    err = "Bluetooth not start";
                    break;
                }
                case 2: {
                    err = "ble non supported";
                    break;
                }
                case 3: {
                    err = "Bluetooth disabled";
                    break;
                }
                case 4: {
                    err = "Bluetooth not available";
                    break;
                }
                case 5: {
                    err = "Location permission missing";
                    break;
                }
                case 6: {
                    err = "Location disabled";
                    break;
                }
                case 7: {
                    err = "BluManager error";
                    break;
                }
                case 8: {
                    err = "BluManager read char error";
                    break;
                }
                case 9: {
                    err = "BluManager write char error";
                    break;
                }
                case 10: {
                    err = "BluManager service gatt not found";
                    break;
                }
                case 11: {
                    err = "BluManager blu sensor not found";
                    break;
                }
                case 12: {
                    err = "BluManager write descr error";
                    break;
                }
                case 13: {
                    err = "BluManager notification error";
                    break;
                }
                case 14: {
                    err = "BluManager write period notification error";
                    break;
                }
                default: {
                    err = "Generic error";
                }
            }
            Toast.makeText((Context)this, (CharSequence)err, (int)1).show();
        } else {
            Log.e((String)"UdooBluAct", (String)"onBluError: -1");
        }
    }

    public boolean isLocationProviderEnabled(LocationManager locationManager) {
        return locationManager.isProviderEnabled("network") || locationManager.isProviderEnabled("gps") || Build.MODEL.equals("UDOONEO-MX6SX") || Build.MODEL.equals("UDOO-MX6DQ");
    }
}

