/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet.util;

import javax.servlet.http.HttpServletRequest;

public class HttpServletRequestHolder {
    private static ThreadLocal<HttpServletRequest> threadLocal = new ThreadLocal();

    public static void bind(HttpServletRequest request) {
        if (request != null && threadLocal.get() != null) {
            throw new IllegalStateException("HttpServletRequestHolder.bind() called for a thread that already has a request associated with it. It's likely that the request was not correctly removed from the thread before it is put back into the thread pool.");
        }
        threadLocal.set(request);
    }

    public static void release() {
        threadLocal.set(null);
    }

    public static HttpServletRequest get() {
        return threadLocal.get();
    }
}

