/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.togglz.junit5.AllDisabled;
import org.togglz.junit5.AllEnabled;
import org.togglz.junit5.FeatureManagerExtension;
import org.togglz.testing.TestFeatureManager;

class AnnotationBasedTogglzExtension
extends FeatureManagerExtension {
    AnnotationBasedTogglzExtension() {
    }

    @Override
    TestFeatureManager createTestFeatureManager(ExtensionContext context) {
        TestFeatureManager featureManager = null;
        Optional<AllEnabled> allEnabled = this.findAnnotation(context, AllEnabled.class);
        Optional<AllDisabled> allDisabled = this.findAnnotation(context, AllDisabled.class);
        if (allEnabled.isPresent() && allDisabled.isPresent()) {
            throw new IllegalStateException("Both @AllEnabled and @AllDisabled are present");
        }
        if (allEnabled.isPresent()) {
            featureManager = new TestFeatureManager(allEnabled.get().value());
            featureManager.enableAll();
        } else if (allDisabled.isPresent()) {
            featureManager = new TestFeatureManager(allDisabled.get().value());
            featureManager.disableAll();
        }
        return featureManager;
    }

    private <T extends Annotation> Optional<T> findAnnotation(ExtensionContext context, Class<T> annotationClass) {
        Method testMethod = context.getRequiredTestMethod();
        Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, annotationClass);
        if (annotation.isPresent()) {
            return annotation;
        }
        Class testClass = context.getRequiredTestClass();
        return AnnotationSupport.findAnnotation((AnnotatedElement)testClass, annotationClass);
    }
}

