/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNGanymedSession;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNGanymedConnector
implements ISVNConnector {
    private static final String SVNSERVE_COMMAND = "svnserve -t";
    private static final String SVNSERVE_COMMAND_WITH_USER_NAME = "svnserve -t --tunnel-user ";
    private Session mySession;
    private InputStream myInputStream;
    private OutputStream myOutputStream;
    private Connection myConnection;

    public void open(SVNRepositoryImpl repository) throws SVNException {
        ISVNAuthenticationManager authManager = repository.getAuthenticationManager();
        String realm = repository.getLocation().getProtocol() + "://" + repository.getLocation().getHost();
        if (repository.getLocation().hasPort()) {
            realm = realm + ":" + repository.getLocation().getPort();
        }
        if (repository.getLocation().getUserInfo() != null && !"".equals(repository.getLocation().getUserInfo())) {
            realm = repository.getLocation().getUserInfo() + "@" + realm;
        }
        int reconnect = 1;
        while (true) {
            SVNSSHAuthentication authentication = (SVNSSHAuthentication)authManager.getFirstAuthentication("svn.ssh", realm, repository.getLocation());
            Connection connection = null;
            while (authentication != null) {
                try {
                    connection = SVNGanymedSession.getConnection(repository.getLocation(), authentication);
                    if (connection == null) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Cannot connect to ''{0}''", repository.getLocation().setPath("", false));
                        SVNErrorManager.error(err);
                    }
                    authManager.acknowledgeAuthentication(true, "svn.ssh", realm, null, authentication);
                    break;
                }
                catch (SVNAuthenticationException e) {
                    authManager.acknowledgeAuthentication(false, "svn.ssh", realm, e.getErrorMessage(), authentication);
                    authentication = (SVNSSHAuthentication)authManager.getNextAuthentication("svn.ssh", realm, repository.getLocation());
                    connection = null;
                }
            }
            if (authentication == null) {
                SVNErrorManager.cancel("authentication cancelled");
            } else if (connection == null) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Can not establish connection with to ''{0}''", realm));
            }
            try {
                String userName;
                this.mySession = connection.openSession();
                SVNGanymedSession.addSession(this.mySession);
                SVNAuthentication author = authManager.getFirstAuthentication("svn.username", realm, repository.getLocation());
                if (author == null) {
                    SVNErrorManager.cancel("authentication cancelled");
                }
                if ((userName = author.getUserName()) == null || "".equals(userName.trim())) {
                    userName = authentication.getUserName();
                }
                if (author.getUserName() == null || author.getUserName().equals(authentication.getUserName()) || "".equals(author.getUserName())) {
                    repository.setExternalUserName("");
                } else {
                    repository.setExternalUserName(author.getUserName());
                }
                author = new SVNUserNameAuthentication(userName, author.isStorageAllowed());
                authManager.acknowledgeAuthentication(true, "svn.username", realm, null, author);
                if ("".equals(repository.getExternalUserName())) {
                    this.mySession.execCommand(SVNSERVE_COMMAND);
                } else {
                    this.mySession.execCommand("svnserve -t --tunnel-user \"" + repository.getExternalUserName() + "\"");
                }
                this.myOutputStream = this.mySession.getStdin();
                this.myOutputStream = new BufferedOutputStream(this.myOutputStream, 16384);
                this.myInputStream = this.mySession.getStdout();
                new StreamGobbler(this.mySession.getStderr());
                if (!SVNGanymedSession.isUsePersistentConnection()) {
                    this.myConnection = connection;
                }
                return;
            }
            catch (IOException e) {
                if (e.getMessage().indexOf("SSH_OPEN_ADMINISTRATIVELY_PROHIBITED") >= 0) {
                    this.close(repository);
                    SVNGanymedSession.waitForFreeChannel();
                    continue;
                }
                if (--reconnect >= 0) {
                    SVNGanymedSession.closeConnection(connection);
                    connection = null;
                    continue;
                }
                repository.getDebugLog().info(e);
                this.close(repository);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Cannot connect to ''{0}'': {1}", new Object[]{repository.getLocation().setPath("", false), e.getMessage()});
                SVNErrorManager.error(err, e);
                continue;
            }
            break;
        }
    }

    public void free() {
        SVNGanymedSession.freeSession(this.mySession);
    }

    public boolean occupy() {
        return SVNGanymedSession.occupySession(this.mySession);
    }

    public void close(SVNRepositoryImpl repository) throws SVNException {
        SVNFileUtil.closeFile(this.myOutputStream);
        SVNFileUtil.closeFile(this.myInputStream);
        if (this.mySession != null && SVNGanymedSession.disposeSession(this.mySession)) {
            this.mySession.close();
            this.mySession.waitForCondition(2, 0L);
        }
        if (!SVNGanymedSession.isUsePersistentConnection() && this.myConnection != null) {
            SVNGanymedSession.closeConnection(this.myConnection);
            this.myConnection = null;
        }
        this.mySession = null;
        this.myOutputStream = null;
        this.myInputStream = null;
    }

    public InputStream getInputStream() throws IOException {
        return this.myInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.myOutputStream;
    }

    public boolean isConnected(SVNRepositoryImpl repos) throws SVNException {
        return true;
    }
}

