/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.CramMD5;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.SVNRollbackInputStream;
import org.tmatesoft.svn.core.internal.io.svn.SVNWriter;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

class SVNConnection {
    private final ISVNConnector myConnector;
    private String myRealm;
    private String myRoot;
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private SVNRepositoryImpl myRepository;
    private boolean myIsSVNDiff1;
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";
    private static final String STEP = "step";
    private static final String EDIT_PIPELINE = "edit-pipeline";
    private static final String SVNDIFF1 = "svndiff1";
    private static final String ABSENT_ENTRIES = "absent-entries";
    private boolean myIsCredentialsReceived = false;
    private InputStream myLoggingInputStream;
    private boolean myIsReopening = false;

    public SVNConnection(ISVNConnector connector, SVNRepositoryImpl repository) {
        this.myConnector = connector;
        this.myRepository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(SVNRepositoryImpl repository) throws SVNException {
        this.myIsReopening = true;
        try {
            this.myIsCredentialsReceived = false;
            this.myConnector.open(repository);
            this.myRepository = repository;
            this.handshake(repository);
        }
        finally {
            this.myIsReopening = false;
        }
    }

    public String getRealm() {
        return this.myRealm;
    }

    public boolean isSVNDiff1() {
        return this.myIsSVNDiff1;
    }

    protected void handshake(SVNRepositoryImpl repository) throws SVNException {
        Object[] items = this.read("[(*N(*W)(*W))]", null, true);
        if (!SVNReader.hasValue(items, 0, 2)) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_BAD_VERSION, "Only protocol of version '2' or older is supported"));
        } else if (!SVNReader.hasValue(items, 2, EDIT_PIPELINE)) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_BAD_VERSION, "Only servers with 'edit-pipeline' capability is supported"));
        }
        this.myIsSVNDiff1 = SVNReader.hasValue(items, 2, SVNDIFF1);
        this.write("(n(www)s)", new Object[]{"2", EDIT_PIPELINE, SVNDIFF1, ABSENT_ENTRIES, repository.getLocation().toString()});
    }

    public void authenticate(SVNRepositoryImpl repository) throws SVNException {
        SVNErrorMessage failureReason;
        block19: {
            failureReason = null;
            Object[] items = this.read("[((*W)?S)]", null, true);
            List mechs = SVNReader.getList(items, 0);
            this.myRealm = SVNReader.getString(items, 1);
            if (mechs == null || mechs.size() == 0) {
                this.receiveRepositoryCredentials(repository);
                return;
            }
            ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
            if (authManager != null && authManager.isAuthenticationForced() && mechs.contains("ANONYMOUS") && mechs.contains("CRAM-MD5")) {
                mechs.remove("ANONYMOUS");
            }
            SVNURL location = this.myRepository.getLocation();
            SVNAuthentication auth = null;
            if (repository.getExternalUserName() != null && mechs.contains("EXTERNAL")) {
                this.write("(w(s))", new Object[]{"EXTERNAL", repository.getExternalUserName()});
                failureReason = this.readAuthResponse();
            } else if (mechs.contains("ANONYMOUS")) {
                this.write("(w())", new Object[]{"ANONYMOUS"});
                failureReason = this.readAuthResponse();
            } else {
                if (mechs.contains("CRAM-MD5")) {
                    block2: while (true) {
                        CramMD5 authenticator = new CramMD5();
                        String realm = this.getRealm();
                        if (location != null) {
                            realm = "<" + location.getProtocol() + "://" + location.getHost() + ":" + location.getPort() + "> " + realm;
                        }
                        if (auth == null && authManager != null) {
                            auth = (SVNPasswordAuthentication)authManager.getFirstAuthentication("svn.simple", realm, location);
                        } else if (authManager != null) {
                            authManager.acknowledgeAuthentication(false, "svn.simple", realm, failureReason, auth);
                            auth = (SVNPasswordAuthentication)authManager.getNextAuthentication("svn.simple", realm, location);
                        }
                        if (auth == null || auth.getUserName() == null || ((SVNPasswordAuthentication)auth).getPassword() == null) {
                            failureReason = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Can't get password. Authentication is required for ''{0}''", realm);
                            break block19;
                        }
                        this.write("(w())", new Object[]{"CRAM-MD5"});
                        while (true) {
                            authenticator.setUserCredentials((SVNPasswordAuthentication)auth);
                            items = this.read("(W(?B))", null, true);
                            if (SUCCESS.equals(items[0])) {
                                authManager.acknowledgeAuthentication(true, "svn.simple", realm, null, auth);
                                this.receiveRepositoryCredentials(repository);
                                return;
                            }
                            if (FAILURE.equals(items[0])) {
                                failureReason = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Authentication error from server: {1}", new String((byte[])items[1]));
                                continue block2;
                            }
                            if (!STEP.equals(items[0])) continue;
                            try {
                                byte[] response = authenticator.buildChallengeResponse((byte[])items[1]);
                                this.getOutputStream().write(response);
                                this.getOutputStream().flush();
                            }
                            catch (IOException e) {
                                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage()), e);
                            }
                        }
                        break;
                    }
                }
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Cannot negotiate authentication mechanism"));
            }
        }
        if (failureReason == null) {
            this.receiveRepositoryCredentials(repository);
            return;
        }
        SVNErrorManager.error(failureReason);
    }

    private void receiveRepositoryCredentials(SVNRepositoryImpl repository) throws SVNException {
        if (this.myIsCredentialsReceived) {
            return;
        }
        Object[] creds = this.read("[(S?S)]", null, true);
        this.myIsCredentialsReceived = true;
        if (creds != null && creds.length == 2 && creds[0] != null && creds[1] != null) {
            SVNURL rootURL;
            SVNURL sVNURL = rootURL = creds[1] != null ? SVNURL.parseURIEncoded((String)creds[1]) : null;
            if (rootURL != null && rootURL.toString().length() > repository.getLocation().toString().length()) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Impossibly long repository root from server"));
            }
            if (repository != null && repository.getRepositoryRoot(false) == null) {
                repository.updateCredentials((String)creds[0], rootURL);
            }
            if (this.myRealm == null) {
                this.myRealm = (String)creds[0];
            }
            if (this.myRoot == null) {
                this.myRoot = (String)creds[1];
            }
        }
    }

    private SVNErrorMessage readAuthResponse() throws SVNException {
        Object[] items = this.read("(W(?S))", null, true);
        if (SUCCESS.equals(items[0])) {
            return null;
        }
        if (FAILURE.equals(items[0])) {
            return SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Authentication error from server: {1}", items[1]);
        }
        return SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Unexpected server response to authentication");
    }

    public void free() {
        this.myConnector.free();
    }

    public void occupy() throws SVNException {
        if (!this.myConnector.occupy()) {
            this.close();
            this.open(this.myRepository);
            this.authenticate(this.myRepository);
        }
    }

    public void close() throws SVNException {
        this.myInputStream = null;
        this.myLoggingInputStream = null;
        this.myOutputStream = null;
        this.myConnector.close(this.myRepository);
    }

    public Object[] read(String template, Object[] items, boolean readMalformedData) throws SVNException {
        try {
            this.checkConnection();
            Object[] objectArray = SVNReader.parse(this.getInputStream(), template, items);
            return objectArray;
        }
        catch (SVNException e) {
            if (readMalformedData && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_MALFORMED_DATA) {
                byte[] malfored = new byte[1024];
                try {
                    this.getInputStream().read(malfored);
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            throw e;
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String template, Object[] items) throws SVNException {
        block7: {
            try {
                SVNWriter.write(this.getOutputStream(), template, items);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.getOutputStream().flush();
                }
                catch (IOException e) {
                }
                catch (SVNException e) {
                    // empty catch block
                }
                this.myRepository.getDebugLog().flushStream(this.getOutputStream());
                throw throwable;
            }
            try {
                this.getOutputStream().flush();
                break block7;
            }
            catch (IOException e) {
                break block7;
            }
            catch (SVNException e) {
                // empty catch block
            }
            {
            }
        }
        this.myRepository.getDebugLog().flushStream(this.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection() throws SVNException {
        if (!this.myIsReopening && !this.myConnector.isConnected(this.myRepository)) {
            this.myIsReopening = true;
            try {
                this.close();
                this.open(this.myRepository);
            }
            finally {
                this.myIsReopening = false;
            }
        }
    }

    public OutputStream getOutputStream() throws SVNException {
        if (this.myOutputStream == null) {
            try {
                this.myOutputStream = this.myRepository.getDebugLog().createLogStream(this.myConnector.getOutputStream());
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage()), e);
            }
        }
        return this.myOutputStream;
    }

    public InputStream getInputStream() throws SVNException {
        if (this.myInputStream == null) {
            try {
                this.myLoggingInputStream = this.myInputStream = this.myRepository.getDebugLog().createLogStream(new BufferedInputStream(this.myConnector.getInputStream()));
                this.myInputStream = new SVNRollbackInputStream(this.myInputStream, 1024);
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage()), e);
            }
        }
        return this.myInputStream;
    }
}

