/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tmatesoft.svn.core.internal.io.dav.http.FixedSizeInputStream;

class ChunkedInputStream
extends InputStream {
    private InputStream mySource;
    private byte[] myBuffer;
    private int myPosition;

    public ChunkedInputStream(InputStream source) {
        this.mySource = source;
    }

    public int read() throws IOException {
        if (this.mySource == null) {
            return -1;
        }
        if (this.myBuffer == null || this.myPosition >= this.myBuffer.length) {
            int length = this.readChunkLength();
            if (length == 0) {
                this.mySource = null;
                return -1;
            }
            this.myBuffer = new byte[length];
            int offset = 0;
            while (length > 0) {
                int count = this.mySource.read(this.myBuffer, offset, length);
                if (count < 0) {
                    this.mySource = null;
                    throw new IOException("Cannot read chunk of data, connection is closed by the server or end of stream reached");
                }
                length -= count;
                offset += count;
            }
            this.myPosition = 0;
        }
        return this.myBuffer[this.myPosition++] & 0xFF;
    }

    public void close() throws IOException {
        if (this.mySource != null) {
            try {
                FixedSizeInputStream.consumeRemaining(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySource = null;
        }
    }

    private int readChunkLength() throws IOException {
        int result;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int state = 0;
        block15: while (state != -1) {
            int b = this.mySource.read();
            if (b == -1) {
                throw new IOException("Chunked stream ended unexpectedly");
            }
            switch (state) {
                case 0: {
                    switch (b) {
                        case 13: {
                            state = 1;
                            continue block15;
                        }
                        case 34: {
                            state = 2;
                        }
                    }
                    baos.write(b);
                    continue block15;
                }
                case 1: {
                    if (b == 10) {
                        state = -1;
                        continue block15;
                    }
                    throw new IOException("Protocol violation: Unexpected single newline character in chunk size");
                }
                case 2: {
                    switch (b) {
                        case 92: {
                            b = this.mySource.read();
                            baos.write(b);
                            continue block15;
                        }
                        case 34: {
                            state = 0;
                        }
                    }
                    baos.write(b);
                    continue block15;
                }
            }
            throw new IOException("Assertion failed while reading chunk length");
        }
        String dataString = new String(baos.toByteArray());
        int separator = dataString.indexOf(59);
        String string = dataString = separator > 0 ? dataString.substring(0, separator).trim() : dataString.trim();
        if (dataString.trim().length() == 0) {
            return this.readChunkLength();
        }
        try {
            result = Integer.parseInt(dataString.trim(), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad chunk size: " + dataString);
        }
        return result;
    }
}

