/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;

public class SVNKitLog
extends SVNDebugLogAdapter {
    private static final String DEBUG_FINE = "/debug/fine";
    private static final String DEBUG_INFO = "/debug/info";
    private static final String DEBUG_ERROR = "/debug/error";
    private boolean myIsFineEnabled;
    private boolean myIsInfoEnabled;
    private boolean myIsErrorEnabled;
    private ILog myLog;
    private String myPluginID;

    public SVNKitLog(Bundle bundle, boolean enabled) {
        this.myLog = Platform.getLog((Bundle)bundle);
        this.myPluginID = bundle.getSymbolicName();
        this.myIsErrorEnabled = Boolean.TRUE.toString().equals(Platform.getDebugOption((String)(this.myPluginID + DEBUG_ERROR)));
        this.myIsFineEnabled = enabled && Boolean.TRUE.toString().equals(Platform.getDebugOption((String)(this.myPluginID + DEBUG_FINE)));
        this.myIsInfoEnabled = enabled && Boolean.TRUE.toString().equals(Platform.getDebugOption((String)(this.myPluginID + DEBUG_INFO)));
    }

    public boolean isFineEnabled() {
        return this.myIsFineEnabled;
    }

    public boolean isInfoEnabled() {
        return this.myIsInfoEnabled;
    }

    public boolean isErrorEnabled() {
        return this.myIsErrorEnabled;
    }

    private Status createStatus(int severity, String message, Throwable th) {
        return new Status(severity, this.myPluginID, 0, message == null ? "" : message, th);
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.myLog.log((IStatus)this.createStatus(1, message, null));
        }
    }

    public void info(Throwable th) {
        if (this.isInfoEnabled()) {
            this.myLog.log((IStatus)this.createStatus(1, th != null ? th.getMessage() : "", th));
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.myLog.log((IStatus)this.createStatus(4, message, null));
        }
    }

    public void error(Throwable th) {
        if (this.isErrorEnabled()) {
            this.myLog.log((IStatus)this.createStatus(4, th != null ? th.getMessage() : "", th));
        }
    }

    public void log(String message, byte[] data) {
        if (this.isFineEnabled()) {
            this.myLog.log((IStatus)this.createStatus(1, message + " : " + new String(data), null));
        }
    }

    public InputStream createLogStream(InputStream is) {
        if (this.isFineEnabled()) {
            return super.createLogStream(is);
        }
        return is;
    }

    public OutputStream createLogStream(OutputStream os) {
        if (this.isFineEnabled()) {
            return super.createLogStream(os);
        }
        return os;
    }
}

