/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common.net;

public class InetMediaType {
    private final String type;
    private final String subType;
    private final String fileExtension;
    public static final InetMediaType UNDEFINED = InetMediaType.applicationType("undefined");
    public static final String UNDEFINED_VALUE = "application/undefined";
    public static final InetMediaType ANY = InetMediaType.type("*", "*");
    public static final String ANY_VALUE = "*/*";
    public static final InetMediaType APPLICATION_ANY = InetMediaType.applicationType("*");
    public static final String APPLICATION_ANY_VALUE = "application/*";
    public static final InetMediaType APPLICATION_XML = InetMediaType.applicationType("xml");
    public static final String APPLICATION_XML_VALUE = "application/xml";
    public static final InetMediaType APPLICATION_XHTML = InetMediaType.applicationType("xhtml+xml", "xhtml");
    public static final String APPLICATION_XHTML_VALUE = "application/xhtml+xml";
    public static final InetMediaType APPLICATION_JSON = InetMediaType.applicationType("json");
    public static final String APPLICATION_JSON_VALUE = "application/json";
    public static final InetMediaType APPLICATION_ZIP = InetMediaType.applicationType("zip");
    public static final String APPLICATION_ZIP_VALUE = "application/zip";
    public static final InetMediaType APPLICATION_PDF = InetMediaType.applicationType("pdf");
    public static final String APPLICATION_PDF_VALUE = "application/pdf";
    public static final InetMediaType TEXT_ANY = InetMediaType.textType("*");
    public static final String TEXT_ANY_VALUE = "text/*";
    public static final InetMediaType TEXT_PLAIN = InetMediaType.textType("plain", "text");
    public static final String TEXT_PLAIN_VALUE = "text/plain";
    public static final InetMediaType TEXT_HTML = InetMediaType.textType("html");
    public static final String TEXT_HTML_VALUE = "text/html";
    public static final InetMediaType TEXT_XML = InetMediaType.textType("xml");
    public static final String TEXT_XML_VALUE = "text/xml";
    public static final InetMediaType TEXT_CSS = InetMediaType.textType("css");
    public static final String TEXT_CSS_VALUE = "text/css";
    public static final InetMediaType APPLICATION_JAVASCRIPT = InetMediaType.applicationType("javascript");
    public static final String APPLICATION_JAVASCRIPT_VALUE = "application/javascript";
    public static final InetMediaType IMAGE_ANY = InetMediaType.imageType("*");
    public static final String IMAGE_ANY_VALUE = "image/*";
    public static final InetMediaType IMAGE_GIF = InetMediaType.imageType("gif");
    public static final String IMAGE_GIF_VALUE = "image/gif";
    public static final InetMediaType IMAGE_JPEG = InetMediaType.imageType("jpeg");
    public static final String IMAGE_JPEG_VALUE = "image/jpeg";
    public static final InetMediaType IMAGE_TIFF = InetMediaType.imageType("tiff");
    public static final String IMAGE_TIFF_VALUE = "image/tiff";
    public static final InetMediaType IMAGE_PNG = InetMediaType.imageType("png");
    public static final String IMAGE_PNG_VALUE = "image/png";
    public static final InetMediaType IMAGE_ICON = InetMediaType.imageType("icon");
    public static final String IMAGE_ICON_VALUE = "image/icon";
    public static final InetMediaType AUDIO_ANY = InetMediaType.audioType("*");
    public static final String AUDIO_ANY_VALUE = "audio/*";
    public static final InetMediaType AUDIO_MPEG = InetMediaType.audioType("mpeg");
    public static final String AUDIO_MPEG_VALUE = "audio/mpeg";
    public static final InetMediaType VIDEO_ANY = InetMediaType.videoType("*");
    public static final String VIDEO_ANY_VALUE = "video/*";
    public static final InetMediaType VIDEO_MP4 = InetMediaType.videoType("mp4");
    public static final String VIDEO_MP4_VALUE = "video/mp4";
    public static final InetMediaType MULTIPART_ANY = InetMediaType.multipartType("*");
    public static final String MULTIPART_ANY_VALUE = "multipart/*";
    public static final InetMediaType MULTIPART_MIXED = InetMediaType.multipartType("mixed");
    public static final String MULTIPART_MIXED_VALUE = "multipart/mixed";
    public static final InetMediaType MULTIPART_RELATED = InetMediaType.multipartType("related");
    public static final String MULTIPART_RELATED_VALUE = "multipart/related";
    public static final InetMediaType MULTIPART_ALTERNATIVE = InetMediaType.multipartType("alternative");
    public static final String MULTIPART_ALTERNATIVE_VALUE = "multipart/alternative";
    public static final InetMediaType MULTIPART_FORM_DATA = InetMediaType.multipartType("form-data");
    public static final String MULTIPART_FORM_DATA_VALUE = "multipart/form-data";
    public static final InetMediaType MULTIPART_SIGNED = InetMediaType.multipartType("signed");
    public static final String MULTIPART_SIGNED_VALUE = "multipart/signed";
    public static final InetMediaType MULTIPART_ENCRYPTED = InetMediaType.multipartType("encrypted");
    public static final String MULTIPART_ENCRYPTED_VALUE = "multipart/encrypted";

    public static InetMediaType newFromJson(String mediaString) {
        return InetMediaType.fromString(mediaString);
    }

    public static InetMediaType type(String type, String subType, String fileExtension) {
        fileExtension = fileExtension != null ? fileExtension : subType;
        return new InetMediaType(type, subType, fileExtension);
    }

    public static InetMediaType fromString(String mediaString) {
        String[] split = mediaString.split("/");
        if (split.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid mime type value: %s", mediaString));
        }
        return InetMediaType.type(split[0], split[1]);
    }

    public static InetMediaType type(String type, String subType) {
        return InetMediaType.type(type, subType, subType);
    }

    public static InetMediaType applicationType(String subType) {
        return InetMediaType.type("application", subType);
    }

    public static InetMediaType applicationType(String subType, String fileExtension) {
        return InetMediaType.type("application", subType, fileExtension);
    }

    public static InetMediaType multipartType(String subType) {
        return InetMediaType.type("multipart", subType);
    }

    public static InetMediaType textType(String subType, String fileExtension) {
        return InetMediaType.type("text", subType, fileExtension);
    }

    public static InetMediaType textType(String subType) {
        return InetMediaType.type("text", subType);
    }

    public static InetMediaType imageType(String subType, String fileExtension) {
        return InetMediaType.type("image", subType, fileExtension);
    }

    public static InetMediaType imageType(String subType) {
        return InetMediaType.type("image", subType);
    }

    public static InetMediaType messageType(String subType, String fileExtension) {
        return InetMediaType.type("message", subType, fileExtension);
    }

    public static InetMediaType audioType(String subType, String fileExtension) {
        return InetMediaType.type("audio", subType, fileExtension);
    }

    public static InetMediaType audioType(String subType) {
        return InetMediaType.type("audio", subType);
    }

    public static InetMediaType videoType(String subType, String fileExtension) {
        return InetMediaType.type("text", subType, fileExtension);
    }

    public static InetMediaType videoType(String subType) {
        return InetMediaType.type("video", subType);
    }

    private InetMediaType(String type, String subType, String fileExtension) {
        if (type == null) {
            throw new NullPointerException("Null type argument give to InetMediaType.");
        }
        if (subType == null) {
            throw new NullPointerException("Null subType argument give to InetMediaType.");
        }
        if (fileExtension == null) {
            throw new NullPointerException("Null fileExtension argument give to InetMediaType.");
        }
        this.type = type;
        this.subType = subType;
        this.fileExtension = fileExtension;
    }

    public String getMediaString() {
        return String.format("%s/%s", this.type, this.subType);
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public boolean isUndefined() {
        return this.equals(UNDEFINED);
    }

    public boolean isDefined() {
        return !this.equals(UNDEFINED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InetMediaType inetMediaType = (InetMediaType)o;
        if (!this.subType.equals(inetMediaType.subType)) {
            return false;
        }
        return this.type.equals(inetMediaType.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subType.hashCode();
        result = 31 * result + this.fileExtension.hashCode();
        return result;
    }

    public String toString() {
        return this.getMediaString();
    }
}

