/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.StringUtils;

public class EnvUtils {
    private static final Logger log = LoggerFactory.getLogger(EnvUtils.class);

    private EnvUtils() {
    }

    public static String getEnvironmentProperty(String propertyName) {
        return System.getenv(propertyName);
    }

    public static String getEnvironmentProperty(String propertyName, String defaultValue) {
        String actualValue = System.getenv(propertyName);
        return StringUtils.isBlank(actualValue) ? defaultValue : actualValue;
    }

    public static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public static String getSystemProperty(String propertyName, String defaultValue) {
        String actualValue = System.getProperty(propertyName);
        return StringUtils.isBlank(actualValue) ? defaultValue : actualValue;
    }

    public static String requireProperty(String propertyName) {
        return EnvUtils.requireProperty(propertyName, IllegalArgumentException.class);
    }

    public static String requireProperty(String propertyName, Class<? extends RuntimeException> type) {
        String value = EnvUtils.findProperty(propertyName, null);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        String msg = String.format("The system or environment property \"%s\" must be specified.", propertyName);
        try {
            throw type.getConstructor(String.class).newInstance(msg);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            log.error("Cannot create custom exception: " + type.getName(), (Throwable)ex);
            throw new IllegalArgumentException(msg);
        }
    }

    public static String findProperty(String propertyName) {
        return EnvUtils.findProperty(propertyName, null);
    }

    public static String findProperty(String propertyName, String defaultValue) {
        String value = EnvUtils.getSystemProperty(propertyName);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return EnvUtils.findEnvironmentProperty(System.getenv(), propertyName, defaultValue);
    }

    static String findEnvironmentProperty(Map<String, String> envMap, String name, String defaultValue) {
        String key = name;
        String value = envMap.get(name);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        key = name.toUpperCase();
        value = envMap.get(key);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        key = name.toLowerCase();
        value = envMap.get(key);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        key = name.replaceAll("\\.", "_");
        value = envMap.get(key);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        key = name.replaceAll("\\.", "_").toUpperCase();
        value = envMap.get(key);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        key = name.replaceAll("\\.", "_").toLowerCase();
        value = envMap.get(key);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        key = name.replaceAll("_", "\\.");
        value = envMap.get(key);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        key = name.replaceAll("_", "\\.").toUpperCase();
        value = envMap.get(key);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        key = name.replaceAll("_", "\\.").toLowerCase();
        value = envMap.get(key);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return defaultValue;
    }
}

