/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers.raw;

import java.io.IOException;
import org.tinylog.writers.raw.ByteArrayWriter;

public final class BufferedWriterDecorator
implements ByteArrayWriter {
    private static final int BUFFER_CAPACITY = 65536;
    private final ByteArrayWriter writer;
    private final byte[] buffer;
    private int position;

    public BufferedWriterDecorator(ByteArrayWriter writer) {
        this.writer = writer;
        this.buffer = new byte[65536];
        this.position = 0;
    }

    @Override
    public void write(byte[] data, int length) throws IOException {
        if (this.position > 0 && 65536 - this.position < length) {
            this.writer.write(this.buffer, this.position);
            this.position = 0;
        }
        if (65536 < length) {
            this.writer.write(data, length);
        } else {
            System.arraycopy(data, 0, this.buffer, this.position, length);
            this.position += length;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.position > 0) {
            this.writer.write(this.buffer, this.position);
            this.position = 0;
        }
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.position > 0) {
            this.writer.write(this.buffer, this.position);
        }
        this.writer.close();
    }
}

