/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

final class ExceptionToken
implements Token {
    private static final String NEW_LINE = System.getProperty("line.separator");

    ExceptionToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.EXCEPTION);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        Throwable throwable = logEntry.getException();
        if (throwable != null) {
            ExceptionToken.render(throwable, builder);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        Throwable throwable = logEntry.getException();
        if (throwable == null) {
            statement.setString(index, null);
        } else {
            StringBuilder builder = new StringBuilder();
            ExceptionToken.render(throwable, builder);
            statement.setString(index, builder.toString());
        }
    }

    private static void render(Throwable throwable, StringBuilder builder) {
        builder.append(throwable.getClass().getName());
        String message = throwable.getMessage();
        if (message != null) {
            builder.append(": ");
            builder.append(message);
        }
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            builder.append(NEW_LINE);
            builder.append("\tat ");
            builder.append(stackTrace[i]);
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            builder.append(NEW_LINE);
            builder.append("Caused by: ");
            ExceptionToken.render(cause, builder);
        }
    }
}

