/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.tinylog.core.ConfigurationParser;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;
import org.tinylog.runtime.RuntimeProvider;
import org.tinylog.runtime.TimestampFormatter;

final class DateToken
implements Token {
    private static final String DEFAULT_DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final Locale locale = ConfigurationParser.getLocale();
    private final boolean formatted;
    private final TimestampFormatter formatter;

    DateToken() {
        this.formatted = false;
        this.formatter = RuntimeProvider.createTimestampFormatter((String)DEFAULT_DATE_FORMAT_PATTERN, (Locale)locale);
    }

    DateToken(String pattern) {
        this.formatted = true;
        this.formatter = RuntimeProvider.createTimestampFormatter((String)pattern, (Locale)locale);
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singletonList(LogEntryValue.DATE);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        builder.append(this.formatter.format(logEntry.getTimestamp()));
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        if (this.formatted) {
            statement.setString(index, this.formatter.format(logEntry.getTimestamp()));
        } else {
            statement.setTimestamp(index, logEntry.getTimestamp().toSqlTimestamp());
        }
    }
}

