/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.path;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tinylog.path.CountSegment;
import org.tinylog.path.DateSegment;
import org.tinylog.path.LastModifiedFileComparator;
import org.tinylog.path.PlainTextSegment;
import org.tinylog.path.ProcessIdSegment;
import org.tinylog.path.Segment;
import org.tinylog.runtime.RuntimeProvider;
import org.tinylog.runtime.Timestamp;

public final class DynamicPath {
    private static final String DEFAULT_DATE_FORMAT_PATTERN = "yyyy-MM-dd_HH-mm-ss";
    private final List<Segment> segments;
    private final File folder;
    private final List<String> plainTexts;
    private final String suffix;

    public DynamicPath(String path) {
        String normalizedPath = path.replace('/', File.separatorChar);
        this.segments = new ArrayList<Segment>();
        this.plainTexts = new ArrayList<String>();
        String prefix = "";
        int start = 0;
        boolean token = false;
        for (int i = 0; i < normalizedPath.length(); ++i) {
            char character = normalizedPath.charAt(i);
            if (character == '{') {
                if (token) {
                    throw new IllegalArgumentException("Closing curly bracket is missing: '" + path + "'");
                }
                if (i > 0 && normalizedPath.charAt(i - 1) == '}') {
                    throw new IllegalArgumentException("Two patterns must be separated by at least one character: '" + path + "'");
                }
                if (i > start) {
                    if (prefix.isEmpty() && this.segments.isEmpty()) {
                        prefix = normalizedPath.substring(0, i);
                    }
                    String text = normalizedPath.substring(start, i);
                    this.segments.add(new PlainTextSegment(text));
                    this.plainTexts.add(text);
                }
                start = i + 1;
                token = true;
                continue;
            }
            if (character != '}') continue;
            if (token) {
                this.segments.add(DynamicPath.parseSegment(normalizedPath, normalizedPath.substring(start, i)));
                start = i + 1;
                token = false;
                continue;
            }
            throw new IllegalArgumentException("Opening curly bracket is missing: '" + path + "'");
        }
        if (token) {
            throw new IllegalArgumentException("Closing curly bracket is missing: '" + path + "'");
        }
        if (start < normalizedPath.length() - 1) {
            if (prefix.isEmpty() && this.segments.isEmpty()) {
                prefix = normalizedPath.substring(0, normalizedPath.length());
            }
            String text = normalizedPath.substring(start, normalizedPath.length());
            int separator = Math.max(text.lastIndexOf(File.separatorChar), text.lastIndexOf(47));
            this.segments.add(new PlainTextSegment(text));
            this.plainTexts.add(text);
            this.suffix = separator == -1 ? text : text.substring(separator + 1);
        } else {
            this.suffix = "";
        }
        int separator = Math.max(prefix.lastIndexOf(File.separatorChar), prefix.lastIndexOf(47));
        this.folder = new File(separator == -1 ? "" : prefix.substring(0, separator));
    }

    public String resolve() {
        Timestamp timestamp = RuntimeProvider.createTimestamp();
        StringBuilder builder = new StringBuilder();
        for (Segment segment : this.segments) {
            builder.append(segment.createToken(builder.toString(), timestamp));
        }
        return builder.toString();
    }

    public List<File> getAllFiles() {
        ArrayList<File> files = new ArrayList<File>();
        this.collectFiles(this.folder, files);
        Collections.sort(files, LastModifiedFileComparator.INSTANCE);
        return files;
    }

    public boolean isValid(File file) {
        return this.isValid(file.getPath(), 0, 0);
    }

    private void collectFiles(File folder, List<File> found) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.collectFiles(file, found);
                    continue;
                }
                if (!file.isFile() || !file.getPath().endsWith(this.suffix)) continue;
                int index = 0;
                for (String text : this.plainTexts) {
                    index = file.getPath().indexOf(text, index);
                    if (index == -1) break;
                    index += text.length();
                }
                if (index < 0) continue;
                found.add(file);
            }
        }
    }

    private boolean isValid(String path, int pathPosition, int segmentIndex) {
        Segment segment = this.segments.get(segmentIndex);
        String expectedValue = segment.getStaticText();
        if (expectedValue == null) {
            if (segmentIndex == this.segments.size() - 1) {
                return segment.validateToken(path.substring(pathPosition));
            }
            String nextValue = this.segments.get(segmentIndex + 1).getStaticText();
            int i = path.indexOf(nextValue, pathPosition);
            while (i >= 0) {
                if (segment.validateToken(path.substring(pathPosition, i)) && this.isValid(path, i, segmentIndex + 1)) {
                    return true;
                }
                i = path.indexOf(nextValue, i + 1);
            }
            return false;
        }
        if (path.startsWith(expectedValue, pathPosition)) {
            if (segmentIndex == this.segments.size() - 1) {
                return pathPosition + expectedValue.length() == path.length();
            }
            return this.isValid(path, pathPosition + expectedValue.length(), segmentIndex + 1);
        }
        return false;
    }

    private static Segment parseSegment(String path, String token) {
        String parameter;
        String name;
        int separator = token.indexOf(58);
        if (separator == -1) {
            name = token.trim();
            parameter = null;
        } else {
            name = token.substring(0, separator).trim();
            parameter = token.substring(separator + 1).trim();
        }
        if ("date".equals(name)) {
            return new DateSegment(parameter == null ? DEFAULT_DATE_FORMAT_PATTERN : parameter);
        }
        if ("count".equals(name) && parameter == null) {
            return new CountSegment();
        }
        if ("pid".equals(name) && parameter == null) {
            return new ProcessIdSegment();
        }
        throw new IllegalArgumentException("Invalid token '" + token + "' in '" + path + "'");
    }
}

