/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class XmlPropertyTask
extends Task {
    private File src;
    private String xml = null;
    private String prefix = "";
    private boolean keepRoot = true;
    private boolean validate = false;
    private boolean collapseAttributes = false;
    private boolean semanticAttributes = false;
    private boolean includeSemanticAttribute = false;
    private File rootDirectory = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private Hashtable addedAttributes = new Hashtable();
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private static final String ID = "id";
    private static final String REF_ID = "refid";
    private static final String LOCATION = "location";
    private static final String VALUE = "value";
    private static final String PATH = "path";
    private static final String PATHID = "pathid";
    private static final String[] ATTRIBUTES = new String[]{"id", "refid", "location", "value", "path", "pathid"};

    public void init() {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    protected EntityResolver getEntityResolver() {
        return this.xmlCatalog;
    }

    public void execute() throws BuildException {
        try {
            InputStream is = this.getInputStream();
            if (is == null) {
                String msg = "XmlProperty task requires a file or xml attribute";
                throw new BuildException(msg);
            }
            this.log("Loading " + (this.src != null ? this.src.getAbsolutePath() : "xml properties"), 3);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(this.validate);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this.getEntityResolver());
            Document document = builder.parse(is);
            Element topElement = document.getDocumentElement();
            this.addedAttributes = new Hashtable();
            if (this.keepRoot) {
                this.addNodeRecursively(topElement, this.prefix, null);
            } else {
                NodeList topChildren = topElement.getChildNodes();
                int numChildren = topChildren.getLength();
                for (int i = 0; i < numChildren; ++i) {
                    this.addNodeRecursively(topChildren.item(i), this.prefix, null);
                }
            }
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            throw new BuildException((Throwable)x);
        }
        catch (ParserConfigurationException pce) {
            throw new BuildException((Throwable)pce);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    private InputStream getInputStream() throws IOException {
        if (this.src != null && this.src.exists()) {
            return new BufferedInputStream(new FileInputStream(this.src));
        }
        if (this.xml != null) {
            return new BufferedInputStream(new ByteArrayInputStream(this.xml.getBytes()));
        }
        return null;
    }

    private void addNodeRecursively(Node node, String prefix, Object container) {
        String nodePrefix = prefix;
        if (node.getNodeType() != 3) {
            if (prefix.trim().length() > 0) {
                nodePrefix = nodePrefix + ".";
            }
            nodePrefix = nodePrefix + node.getNodeName();
        }
        Object nodeObject = this.processNode(node, nodePrefix, container);
        if (node.hasChildNodes()) {
            NodeList nodeChildren = node.getChildNodes();
            int numChildren = nodeChildren.getLength();
            for (int i = 0; i < numChildren; ++i) {
                this.addNodeRecursively(nodeChildren.item(i), nodePrefix, nodeObject);
            }
        }
    }

    void addNodeRecursively(Node node, String prefix) {
        this.addNodeRecursively(node, prefix, null);
    }

    public Object processNode(Node node, String prefix, Object container) {
        String addedPath = null;
        String id = null;
        if (node.hasAttributes()) {
            NamedNodeMap nodeAttributes = node.getAttributes();
            Node idNode = nodeAttributes.getNamedItem(ID);
            id = this.semanticAttributes && idNode != null ? idNode.getNodeValue() : null;
            for (int i = 0; i < nodeAttributes.getLength(); ++i) {
                Path containingPath;
                String attributeValue;
                Node attributeNode = nodeAttributes.item(i);
                if (!this.semanticAttributes) {
                    String attributeName = this.getAttributeName(attributeNode);
                    attributeValue = this.getAttributeValue(attributeNode);
                    this.addProperty(prefix + attributeName, attributeValue, null);
                    continue;
                }
                String nodeName = attributeNode.getNodeName();
                attributeValue = this.getAttributeValue(attributeNode);
                Path path = containingPath = container != null && container instanceof Path ? (Path)container : null;
                if (nodeName.equals(ID)) continue;
                if (containingPath != null && nodeName.equals(PATH)) {
                    containingPath.setPath(attributeValue);
                    continue;
                }
                if (container instanceof Path && nodeName.equals(REF_ID)) {
                    containingPath.setPath(attributeValue);
                    continue;
                }
                if (container instanceof Path && nodeName.equals(LOCATION)) {
                    containingPath.setLocation(this.resolveFile(attributeValue));
                    continue;
                }
                if (nodeName.equals(PATHID)) {
                    if (container != null) {
                        throw new BuildException("XmlProperty does not support nested paths");
                    }
                    addedPath = new Path(this.getProject());
                    this.getProject().addReference(attributeValue, (Object)addedPath);
                    continue;
                }
                String attributeName = this.getAttributeName(attributeNode);
                this.addProperty(prefix + attributeName, attributeValue, id);
            }
        }
        String nodeText = null;
        if (node.getNodeType() == 3) {
            nodeText = this.getAttributeValue(node);
        } else if (node.getNodeType() == 1 && node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 4) {
            nodeText = node.getFirstChild().getNodeValue();
        }
        if (nodeText != null) {
            if (this.semanticAttributes && id == null && container instanceof String) {
                id = (String)container;
            }
            if (nodeText.trim().length() != 0) {
                this.addProperty(prefix, nodeText, id);
            }
        }
        return addedPath != null ? addedPath : id;
    }

    private void addProperty(String name, String value, String id) {
        String msg = name + ":" + value;
        if (id != null) {
            msg = msg + "(id=" + id + ")";
        }
        this.log(msg, 4);
        if (this.addedAttributes.containsKey(name)) {
            value = (String)this.addedAttributes.get(name) + "," + value;
            this.getProject().setProperty(name, value);
        } else {
            this.getProject().setNewProperty(name, value);
        }
        this.addedAttributes.put(name, value);
        if (id != null) {
            this.getProject().addReference(id, (Object)value);
        }
    }

    private String getAttributeName(Node attributeNode) {
        String attributeName = attributeNode.getNodeName();
        if (this.semanticAttributes) {
            if (attributeName.equals(REF_ID)) {
                return "";
            }
            if (!XmlPropertyTask.isSemanticAttribute(attributeName) || this.includeSemanticAttribute) {
                return "." + attributeName;
            }
            return "";
        }
        if (this.collapseAttributes) {
            return "." + attributeName;
        }
        return "(" + attributeName + ")";
    }

    private static boolean isSemanticAttribute(String attributeName) {
        for (int i = 0; i < ATTRIBUTES.length; ++i) {
            if (!attributeName.equals(ATTRIBUTES[i])) continue;
            return true;
        }
        return false;
    }

    private String getAttributeValue(Node attributeNode) {
        String nodeValue = attributeNode.getNodeValue().trim();
        if (this.semanticAttributes) {
            Object ref;
            String attributeName = attributeNode.getNodeName();
            nodeValue = this.getProject().replaceProperties(nodeValue);
            if (attributeName.equals(LOCATION)) {
                File f = this.resolveFile(nodeValue);
                return f.getPath();
            }
            if (attributeName.equals(REF_ID) && (ref = this.getProject().getReference(nodeValue)) != null) {
                return ref.toString();
            }
        }
        return nodeValue;
    }

    public void setFile(File src) {
        this.src = src;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix.trim();
    }

    public void setKeeproot(boolean keepRoot) {
        this.keepRoot = keepRoot;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setCollapseAttributes(boolean collapseAttributes) {
        this.collapseAttributes = collapseAttributes;
    }

    public void setSemanticAttributes(boolean semanticAttributes) {
        this.semanticAttributes = semanticAttributes;
    }

    public void setRootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public void setIncludeSemanticAttribute(boolean includeSemanticAttribute) {
        this.includeSemanticAttribute = includeSemanticAttribute;
    }

    public void addConfiguredXMLCatalog(XMLCatalog catalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(catalog);
    }

    protected File getFile() {
        return this.src;
    }

    protected String getXML() {
        return this.xml;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected boolean getKeeproot() {
        return this.keepRoot;
    }

    protected boolean getValidate() {
        return this.validate;
    }

    protected boolean getCollapseAttributes() {
        return this.collapseAttributes;
    }

    protected boolean getSemanticAttributes() {
        return this.semanticAttributes;
    }

    protected File getRootDirectory() {
        return this.rootDirectory;
    }

    protected boolean getIncludeSementicAttribute() {
        return this.includeSemanticAttribute;
    }

    private File resolveFile(String fileName) {
        if (this.rootDirectory == null) {
            return this.getProject().resolveFile(fileName);
        }
        return this.fileUtils.resolveFile(this.rootDirectory, fileName);
    }
}

