/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class SuiteOriginal
extends Task {
    private Target setUp = null;
    private Target tearDown = null;
    private Vector testTargets = new Vector();
    private Vector failures = new Vector();
    private boolean showSummary = true;
    private boolean showOutput = true;
    private int tests_passed = 0;
    private int tests_failed = 0;

    public int getTestCaseCount() {
        return this.testTargets.size();
    }

    public int getRanCount() {
        return this.tests_passed + this.tests_failed;
    }

    public int getFailedCount() {
        return this.tests_failed;
    }

    public int getPassedCount() {
        return this.tests_passed;
    }

    public Enumeration getFailures() {
        return this.failures.elements();
    }

    public void setShowoutput(boolean b) {
        this.showOutput = b;
    }

    public void setShowsummary(boolean b) {
        this.showSummary = b;
    }

    public void execute() {
        Hashtable targets = this.getProject().getTargets();
        Enumeration<Object> en = targets.keys();
        while (en.hasMoreElements()) {
            String target = (String)en.nextElement();
            if (target.equals("setUp")) {
                this.setUp = (Target)targets.get(target);
                continue;
            }
            if (target.equals("tearDown")) {
                this.tearDown = (Target)targets.get(target);
                continue;
            }
            if (target.startsWith("test")) {
                this.testTargets.addElement(targets.get(target));
                continue;
            }
            if (target.lastIndexOf(".") <= 0 || !target.substring(target.lastIndexOf(".") + 1).startsWith("test")) continue;
            this.testTargets.addElement(targets.get(target));
        }
        if (this.setUp != null) {
            this.setUp.execute();
        }
        en = this.testTargets.elements();
        StringBuffer messages = new StringBuffer();
        while (en.hasMoreElements()) {
            Target target = (Target)en.nextElement();
            try {
                this.executeDependencies(target);
                target.performTasks();
                if (this.showOutput) {
                    this.log(target.getName() + " passed.");
                }
                ++this.tests_passed;
            }
            catch (Exception e) {
                ++this.tests_failed;
                if (this.showOutput) {
                    this.log(target.getName() + " failed: " + e.getMessage());
                }
                this.failures.addElement(target.getName() + " failed: " + e.getMessage());
            }
        }
        if (this.tearDown != null) {
            this.tearDown.execute();
        }
        if (this.showSummary) {
            if (this.failures.size() > 0) {
                this.log("");
                this.log("---- Errors ---------------------------------");
                en = this.failures.elements();
                while (en.hasMoreElements()) {
                    String msg = (String)en.nextElement();
                    this.log(msg);
                }
            }
            this.log("");
            this.log("---- Results --------------------------------");
            this.log("Ran " + this.getRanCount() + " out of " + this.getTestCaseCount() + " tests.");
            this.log("Passed: " + this.getPassedCount());
            this.log("Failed: " + this.getFailedCount());
        }
    }

    private void executeDependencies(Target target) {
        if (target == null) {
            return;
        }
        Enumeration en = target.getDependencies();
        if (en == null) {
            return;
        }
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            Target t = (Target)this.getProject().getTargets().get(name);
            this.executeDependencies(t);
            t.performTasks();
        }
    }
}

