/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SplitTask
extends Task {
    private String prefix = "x";
    private int bytes = -1;
    private int lines = 1000;
    private String value = null;
    private File file = null;
    private File outputDir = null;
    private boolean failOnError = true;

    public void setPrefix(String x) {
        this.prefix = x;
    }

    public void setBytes(int b) {
        this.bytes = b;
        this.lines = -1;
    }

    public void setSize(String b) {
        if (b == null || b.length() == 0) {
            return;
        }
        b = b.toLowerCase();
        String modifier = b.substring(b.length() - 1);
        int multiplier = 1;
        b = b.substring(0, b.length() - 1);
        if (modifier.equals("b")) {
            multiplier = 512;
        } else if (modifier.equals("k")) {
            multiplier = 1024;
        } else if (modifier.equals("m")) {
            multiplier = 0x100000;
        } else {
            b = b + modifier;
        }
        try {
            int size = Integer.parseInt(b) * multiplier;
            this.setBytes(size);
        }
        catch (NumberFormatException e) {
            throw new BuildException("Invalid size parameter.");
        }
    }

    public void setLines(int x) {
        this.lines = x;
        this.bytes = -1;
    }

    public void setProperty(String p) {
        String v = this.getProject().getProperty(p);
        if (v == null || v.equals("")) {
            throw new BuildException("Property " + p + " has no value.");
        }
        this.setValue(v);
    }

    public void setValue(String v) {
        if (v == null || v.equals("")) {
            throw new BuildException("Value is null or empty.");
        }
        this.value = v;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public void setOutputdir(File d) {
        this.outputDir = d;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void execute() throws BuildException {
        if (this.value == null && this.file == null) {
            throw new BuildException("Must have property, value, or file.");
        }
        if (this.file == null && this.outputDir == null) {
            throw new BuildException("Must have output directory.");
        }
        if (this.value != null && this.file != null) {
            throw new BuildException("Must not have more than one of property, value, or file.");
        }
        try {
            if (this.value != null) {
                this.splitValue();
            } else {
                this.splitFile();
            }
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new BuildException(e.getMessage());
            }
            this.log(e.getMessage());
        }
    }

    private void splitValue() throws Exception {
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IOException("Unable to create output directory.");
        }
        StringReader reader = new StringReader(this.value);
        int bytes_read = 0;
        int suffix = 0;
        if (this.bytes > 0) {
            char[] buffer = new char[this.bytes];
            while (bytes_read > -1 && (bytes_read = reader.read(buffer, 0, this.bytes)) != -1) {
                FileWriter fw = new FileWriter(new File(this.outputDir, this.prefix + "." + String.valueOf(suffix)));
                fw.write(buffer, 0, bytes_read);
                fw.flush();
                fw.close();
                ++suffix;
            }
        } else {
            this.splitByLines(reader);
        }
    }

    private void splitFile() throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.toString());
        }
        if (this.file.length() == 0L) {
            throw new BuildException("Zero length file.");
        }
        if (this.outputDir == null) {
            this.outputDir = this.file.getParentFile();
        }
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IOException("Unable to create output directory.");
        }
        int suffix = 0;
        if (this.bytes > 0) {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file));
            int bytes_read = 0;
            byte[] buffer = new byte[this.bytes];
            while (bytes_read > -1 && (bytes_read = bis.read(buffer, 0, this.bytes)) != -1) {
                FileOutputStream fos = new FileOutputStream(new File(this.outputDir, this.prefix + "." + String.valueOf(suffix)));
                fos.write(buffer, 0, bytes_read);
                fos.flush();
                fos.close();
                ++suffix;
            }
        } else {
            this.splitByLines(new FileReader(this.file));
        }
    }

    private void splitByLines(Reader reader) throws IOException {
        int suffix = 0;
        LineNumberReader lnr = new LineNumberReader(reader);
        String line = lnr.readLine();
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.outputDir, this.prefix + "." + String.valueOf(suffix))));
        while (line != null) {
            writer.write(line);
            writer.newLine();
            if (lnr.getLineNumber() % this.lines == 0) {
                writer.flush();
                writer.close();
                writer = new BufferedWriter(new FileWriter(new File(this.outputDir, this.prefix + "." + String.valueOf(++suffix))));
            }
            line = lnr.readLine();
        }
        writer.flush();
        writer.close();
    }
}

