/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Grep {
    private String findIn = null;
    private String regex = null;
    private int group = 0;
    private boolean dotall = false;
    private boolean caseInsensitive = false;
    private boolean multiLine = false;
    private boolean unicodeCase = false;
    private boolean canonEq = false;
    private boolean comments = false;
    private boolean unixLines = false;
    private boolean allMatches = false;
    private String separator = System.getProperty("line.separator");
    private String grep_match = null;
    private int count = 0;
    private List matches = new ArrayList();

    public void setIn(String string) {
        this.findIn = string;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setGroup(int g) {
        this.group = g;
    }

    public void setDotall(boolean b) {
        this.dotall = b;
    }

    public void setCaseinsensitive(boolean b) {
        this.caseInsensitive = b;
    }

    public void setMultiline(boolean b) {
        this.multiLine = b;
    }

    public void setUnicodecase(boolean b) {
        this.unicodeCase = b;
    }

    public void setCanoneq(boolean b) {
        this.canonEq = b;
    }

    public void setComments(boolean b) {
        this.comments = b;
    }

    public void setUnixlines(boolean b) {
        this.unixLines = b;
    }

    public void setAllmatches(boolean b) {
        this.allMatches = b;
    }

    public int getCount() {
        return this.matches.size();
    }

    public String getMatch() {
        return this.grep_match;
    }

    public Iterator getMatches() {
        return this.matches.iterator();
    }

    public String getMatch(int i) {
        return i < 0 || i >= this.matches.size() ? null : (String)this.matches.get(i);
    }

    public void setSeparator(String s) {
        this.separator = s;
    }

    public String grep() {
        if (this.findIn == null) {
            throw new IllegalArgumentException("'in' is required");
        }
        if (this.regex == null) {
            throw new IllegalArgumentException("'regex' is required");
        }
        int flags = 0;
        if (this.dotall) {
            flags += 32;
        }
        if (this.caseInsensitive) {
            flags += 2;
        }
        if (this.multiLine) {
            flags += 8;
        }
        if (this.unicodeCase) {
            flags += 64;
        }
        if (this.canonEq) {
            flags += 128;
        }
        if (this.comments) {
            flags += 4;
        }
        if (this.unixLines) {
            ++flags;
        }
        try {
            String match;
            Pattern p = Pattern.compile(this.regex, flags);
            Matcher m = p.matcher(this.findIn);
            StringBuffer result = new StringBuffer();
            this.matches = new ArrayList();
            if (this.allMatches) {
                while (m.find()) {
                    String match2 = m.group(this.group);
                    if (match2 == null) continue;
                    result.append(match2).append(this.separator);
                    this.matches.add(match2);
                }
            } else if (m.find() && (match = m.group(this.group)) != null) {
                result.append(match);
                this.matches.add(match);
            }
            this.grep_match = result.length() > 0 ? result.toString() : null;
            return this.grep_match;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

