/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import java.util.Map;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.thymeleaf.model.IElementAttributes;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;
import org.unbescape.html.HtmlEscape;

public final class SpringActionTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    public static final int ATTR_PRECEDENCE = 1000;
    public static final String TARGET_ATTR_NAME = "action";
    private static final TemplateMode TEMPLATE_MODE = TemplateMode.HTML;
    private static final String METHOD_ATTR_NAME = "method";
    private static final String TYPE_ATTR_NAME = "type";
    private static final String NAME_ATTR_NAME = "name";
    private static final String VALUE_ATTR_NAME = "value";
    private AttributeDefinition targetAttributeDefinition;
    private AttributeDefinition methodAttributeDefinition;
    private AttributeDefinition typeAttributeDefinition;
    private AttributeDefinition nameAttributeDefinition;
    private AttributeDefinition valueAttributeDefinition;

    public SpringActionTagProcessor(String dialectPrefix) {
        super(TEMPLATE_MODE, dialectPrefix, TARGET_ATTR_NAME, 1000, false);
    }

    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull((Object)attributeDefinitions, (String)"Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, TARGET_ATTR_NAME);
        this.methodAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, METHOD_ATTR_NAME);
        this.typeAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, TYPE_ATTR_NAME);
        this.nameAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, NAME_ATTR_NAME);
        this.valueAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, VALUE_ATTR_NAME);
    }

    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        Map<String, String> extraHiddenFields;
        String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)(expressionResult == null ? "" : expressionResult.toString()));
        IElementAttributes attributes = tag.getAttributes();
        String httpMethod = attributes.getValue(this.methodAttributeDefinition.getAttributeName());
        newAttributeValue = RequestDataValueProcessorUtils.processAction(context, newAttributeValue, httpMethod);
        StandardProcessorUtils.replaceAttribute((IElementAttributes)attributes, (AttributeName)attributeName, (AttributeDefinition)this.targetAttributeDefinition, (String)TARGET_ATTR_NAME, (String)(newAttributeValue == null ? "" : newAttributeValue));
        if ("form".equalsIgnoreCase(tag.getElementName()) && (extraHiddenFields = RequestDataValueProcessorUtils.getExtraHiddenFields(context)) != null && extraHiddenFields.size() > 0) {
            IModelFactory modelFactory = context.getConfiguration().getModelFactory(context.getTemplateMode());
            IModel extraHiddenElementTags = modelFactory.createModel();
            for (Map.Entry<String, String> extraHiddenField : extraHiddenFields.entrySet()) {
                IStandaloneElementTag extraHiddenElementTag = modelFactory.createStandaloneElementTag("input", true);
                IElementAttributes extraHiddenElementTagAttributes = extraHiddenElementTag.getAttributes();
                StandardProcessorUtils.setAttribute((IElementAttributes)extraHiddenElementTagAttributes, (AttributeDefinition)this.typeAttributeDefinition, (String)TYPE_ATTR_NAME, (String)"hidden");
                StandardProcessorUtils.setAttribute((IElementAttributes)extraHiddenElementTagAttributes, (AttributeDefinition)this.nameAttributeDefinition, (String)NAME_ATTR_NAME, (String)extraHiddenField.getKey());
                StandardProcessorUtils.setAttribute((IElementAttributes)extraHiddenElementTagAttributes, (AttributeDefinition)this.valueAttributeDefinition, (String)VALUE_ATTR_NAME, (String)extraHiddenField.getValue());
                extraHiddenElementTags.add((ITemplateEvent)extraHiddenElementTag);
            }
            structureHandler.insertImmediatelyAfter(extraHiddenElementTags, false);
        }
    }
}

