/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.springframework.web.servlet.support.BindStatus;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ITemplateProcessingContext;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring4.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;

public final class SpringSelectFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    static final String OPTION_IN_SELECT_ATTR_NAME = "%%OPTION_IN_SELECT_ATTR_NAME%%";
    static final String OPTION_IN_SELECT_ATTR_VALUE = "%%OPTION_IN_SELECT_ATTR_VALUE%%";

    public SpringSelectFieldTagProcessor(IProcessorDialect dialect, String dialectPrefix) {
        super(dialect, dialectPrefix, "select", null, null, true);
    }

    protected void doProcess(ITemplateProcessingContext processingContext, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, String attributeTemplateName, int attributeLine, int attributeCol, BindStatus bindStatus, IElementTagStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(processingContext, tag, name, false);
        boolean multiple = tag.getAttributes().hasAttribute("multiple");
        tag.getAttributes().setAttribute("id", id);
        tag.getAttributes().setAttribute("name", name);
        structureHandler.setLocalVariable(OPTION_IN_SELECT_ATTR_NAME, (Object)attributeName);
        structureHandler.setLocalVariable(OPTION_IN_SELECT_ATTR_VALUE, (Object)attributeValue);
        if (multiple && !SpringSelectFieldTagProcessor.isDisabled(tag)) {
            IModel hiddenMethodElementModel = processingContext.getModelFactory().createModel();
            String hiddenName = "_" + name;
            String type = "hidden";
            String value = RequestDataValueProcessorUtils.processFormFieldValue((IProcessingContext)processingContext, hiddenName, "1", "hidden");
            IStandaloneElementTag hiddenMethodElementTag = processingContext.getModelFactory().createStandaloneElementTag("input", true);
            hiddenMethodElementTag.getAttributes().setAttribute("type", "hidden");
            hiddenMethodElementTag.getAttributes().setAttribute("name", hiddenName);
            hiddenMethodElementTag.getAttributes().setAttribute("value", value);
            hiddenMethodElementModel.add((ITemplateEvent)hiddenMethodElementTag);
            structureHandler.insertBefore(hiddenMethodElementModel);
        }
    }

    private static final boolean isDisabled(IProcessableElementTag tag) {
        return tag.getAttributes().hasAttribute("disabled");
    }
}

