/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.ValueFormatterWrapper;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.context.ILocalVariableAwareVariablesMap;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.IVariablesMap;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.spring4.expression.IThymeleafEvaluationContext;
import org.thymeleaf.spring4.expression.SpringStandardConversionService;
import org.thymeleaf.spring4.expression.ThymeleafEvaluationContextWrapper;
import org.thymeleaf.spring4.util.FieldUtils;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.util.StandardExpressionUtils;

public class SPELVariableExpressionEvaluator
implements IStandardVariableExpressionEvaluator {
    public static final SPELVariableExpressionEvaluator INSTANCE = new SPELVariableExpressionEvaluator();
    private static final String SPEL_CACHE_PREFIX = "ognl|";
    private static final Logger logger = LoggerFactory.getLogger(SPELVariableExpressionEvaluator.class);
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();

    protected SPELVariableExpressionEvaluator() {
    }

    public final Object evaluate(IProcessingContext processingContext, String spelExpression, StandardExpressionExecutionContext expContext, boolean useSelectionAsRoot) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] SpringEL expression: evaluating expression \"{}\" on target", (Object)TemplateEngine.threadIndex(), (Object)spelExpression);
        }
        try {
            IVariablesMap evaluationRoot;
            IVariablesMap variablesMap;
            BindStatus bindStatus;
            if (expContext.getPerformTypeConversion() && (useSelectionAsRoot || !SPELVariableExpressionEvaluator.isLocalVariableOverriding(processingContext, spelExpression)) && (bindStatus = FieldUtils.getBindStatusFromParsedExpression(processingContext, true, useSelectionAsRoot, spelExpression)) != null) {
                return ValueFormatterWrapper.getDisplayString(bindStatus.getValue(), bindStatus.getEditor(), false);
            }
            IEngineConfiguration configuration = processingContext.getConfiguration();
            SpelExpression exp = SPELVariableExpressionEvaluator.getExpression(configuration, spelExpression);
            IExpressionObjects expressionObjects = StandardExpressionUtils.mightNeedExpressionObjects((String)spelExpression) ? processingContext.getExpressionObjects() : null;
            EvaluationContext evaluationContext = (EvaluationContext)processingContext.getVariables().getVariable("thymeleaf::EvaluationContext");
            if (evaluationContext == null) {
                evaluationContext = new ThymeleafEvaluationContextWrapper((EvaluationContext)new StandardEvaluationContext());
                variablesMap = processingContext.getVariables();
                if (variablesMap instanceof ILocalVariableAwareVariablesMap) {
                    ((ILocalVariableAwareVariablesMap)variablesMap).put("thymeleaf::EvaluationContext", (Object)evaluationContext);
                }
            } else if (!(evaluationContext instanceof IThymeleafEvaluationContext)) {
                evaluationContext = new ThymeleafEvaluationContextWrapper(evaluationContext);
                variablesMap = processingContext.getVariables();
                if (variablesMap instanceof ILocalVariableAwareVariablesMap) {
                    ((ILocalVariableAwareVariablesMap)variablesMap).put("thymeleaf::EvaluationContext", (Object)evaluationContext);
                }
            }
            IThymeleafEvaluationContext thymeleafEvaluationContext = (IThymeleafEvaluationContext)evaluationContext;
            thymeleafEvaluationContext.setExpressionObjects(expressionObjects);
            thymeleafEvaluationContext.setVariableAccessRestricted(expContext.getRestrictVariableAccess());
            IVariablesMap variablesMap2 = processingContext.getVariables();
            Object object = evaluationRoot = useSelectionAsRoot && variablesMap2.hasSelectionTarget() ? variablesMap2.getSelectionTarget() : variablesMap2;
            if (!expContext.getPerformTypeConversion()) {
                return exp.getValue((EvaluationContext)thymeleafEvaluationContext, (Object)evaluationRoot);
            }
            IStandardConversionService conversionService = StandardExpressions.getConversionService((IEngineConfiguration)configuration);
            if (conversionService instanceof SpringStandardConversionService) {
                return exp.getValue((EvaluationContext)thymeleafEvaluationContext, (Object)evaluationRoot, String.class);
            }
            Object result = exp.getValue((EvaluationContext)thymeleafEvaluationContext, (Object)evaluationRoot);
            return conversionService.convert(processingContext, result, String.class);
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Exception evaluating SpringEL expression: \"" + spelExpression + "\"", (Throwable)e);
        }
    }

    private static SpelExpression getExpression(IEngineConfiguration configuration, String spelExpression) {
        SpelExpression exp = null;
        ICache cache = null;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
            exp = (SpelExpression)cache.get((Object)(SPEL_CACHE_PREFIX + spelExpression));
        }
        if (exp == null) {
            exp = (SpelExpression)PARSER.parseExpression(spelExpression);
            if (cache != null && null != exp) {
                cache.put((Object)(SPEL_CACHE_PREFIX + spelExpression), (Object)exp);
            }
        }
        return exp;
    }

    private static boolean isLocalVariableOverriding(IProcessingContext processingContext, String expression) {
        IVariablesMap variablesMap = processingContext.getVariables();
        if (!(variablesMap instanceof ILocalVariableAwareVariablesMap)) {
            return false;
        }
        ILocalVariableAwareVariablesMap localVariableAwareVariablesMap = (ILocalVariableAwareVariablesMap)variablesMap;
        int dotPos = expression.indexOf(46);
        if (dotPos == -1) {
            return false;
        }
        String expressionFirstComponent = expression.substring(0, dotPos);
        return localVariableAwareVariablesMap.isVariableLocal(expressionFirstComponent);
    }

    public String toString() {
        return "SpringEL";
    }
}

