/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring4.util.DetailedError;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.SelectionVariableExpression;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldUtils {
    public static final String ALL_FIELDS = "*";
    public static final String GLOBAL_EXPRESSION = "global";
    public static final String ALL_EXPRESSION = "all";

    public static boolean hasErrors(IProcessingContext processingContext, String field) {
        return FieldUtils.checkErrors(processingContext, FieldUtils.convertToFieldExpression(field));
    }

    public static boolean hasAnyErrors(IProcessingContext processingContext) {
        return FieldUtils.checkErrors(processingContext, ALL_EXPRESSION);
    }

    public static boolean hasGlobalErrors(IProcessingContext processingContext) {
        return FieldUtils.checkErrors(processingContext, GLOBAL_EXPRESSION);
    }

    public static List<String> errors(IProcessingContext processingContext, String field) {
        return FieldUtils.computeErrors(processingContext, FieldUtils.convertToFieldExpression(field));
    }

    public static List<String> errors(IProcessingContext processingContext) {
        return FieldUtils.computeErrors(processingContext, ALL_EXPRESSION);
    }

    public static List<String> globalErrors(IProcessingContext processingContext) {
        return FieldUtils.computeErrors(processingContext, GLOBAL_EXPRESSION);
    }

    private static List<String> computeErrors(IProcessingContext processingContext, String fieldExpression) {
        BindStatus bindStatus = FieldUtils.getBindStatus(processingContext, fieldExpression);
        if (bindStatus == null) {
            return Collections.EMPTY_LIST;
        }
        String[] errorCodes = bindStatus.getErrorMessages();
        if (errorCodes == null || errorCodes.length == 0) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(errorCodes);
    }

    public static List<DetailedError> detailedErrors(IProcessingContext processingContext) {
        return FieldUtils.computeDetailedErrors(processingContext, ALL_EXPRESSION, true, true);
    }

    private static List<DetailedError> computeDetailedErrors(IProcessingContext processingContext, String fieldExpression, boolean includeGlobalErrors, boolean includeFieldErrors) {
        DetailedError errorObject;
        String message;
        BindStatus bindStatus = FieldUtils.getBindStatus(processingContext, fieldExpression);
        if (bindStatus == null) {
            return Collections.EMPTY_LIST;
        }
        Errors errors = bindStatus.getErrors();
        if (errors == null) {
            return Collections.EMPTY_LIST;
        }
        RequestContext requestContext = (RequestContext)processingContext.getVariables().getVariable("springRequestContext");
        if (requestContext == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DetailedError> errorObjects = null;
        if (includeGlobalErrors) {
            List globalErrors = errors.getGlobalErrors();
            for (ObjectError globalError : globalErrors) {
                message = requestContext.getMessage((MessageSourceResolvable)globalError, false);
                errorObject = new DetailedError(globalError.getCode(), globalError.getArguments(), message);
                if (errorObjects == null) {
                    errorObjects = new ArrayList<DetailedError>(errors.getErrorCount() + 2);
                }
                errorObjects.add(errorObject);
            }
        }
        if (includeFieldErrors) {
            List fieldErrors = errors.getFieldErrors();
            for (FieldError fieldError : fieldErrors) {
                message = requestContext.getMessage((MessageSourceResolvable)fieldError, false);
                errorObject = new DetailedError(fieldError.getField(), fieldError.getCode(), fieldError.getArguments(), message);
                if (errorObjects == null) {
                    errorObjects = new ArrayList(errors.getErrorCount() + 2);
                }
                errorObjects.add(errorObject);
            }
        }
        if (errorObjects == null) {
            return Collections.EMPTY_LIST;
        }
        return errorObjects;
    }

    public static String idFromName(String fieldName) {
        return StringUtils.deleteAny((String)fieldName, (String)"[]");
    }

    private static String convertToFieldExpression(String field) {
        if (field == null) {
            return null;
        }
        String trimmedField = field.trim();
        if (trimmedField.length() == 0) {
            return null;
        }
        char firstc = trimmedField.charAt(0);
        if (firstc == '*' || firstc == '$') {
            return field;
        }
        return "*{" + field + "}";
    }

    private static boolean checkErrors(IProcessingContext processingContext, String expression) {
        BindStatus bindStatus = FieldUtils.getBindStatus(processingContext, expression);
        return bindStatus.isError();
    }

    public static BindStatus getBindStatus(IProcessingContext processingContext, String expression) {
        return FieldUtils.getBindStatus(processingContext, false, expression);
    }

    public static BindStatus getBindStatus(IProcessingContext processingContext, boolean optional, String expression) {
        Validate.notNull((Object)expression, (String)"Expression cannot be null");
        if (GLOBAL_EXPRESSION.equals(expression) || ALL_EXPRESSION.equals(expression) || ALL_FIELDS.equals(expression)) {
            String completeExpression = "*{" + expression + "}";
            return FieldUtils.getBindStatus(processingContext, optional, completeExpression);
        }
        IEngineConfiguration configuration = processingContext.getConfiguration();
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
        IStandardExpression expressionObj = expressionParser.parseExpression(processingContext, expression);
        if (expressionObj == null) {
            throw new TemplateProcessingException("Expression \"" + expression + "\" is not valid: cannot perform Spring bind");
        }
        if (expressionObj instanceof SelectionVariableExpression) {
            String bindExpression = ((SelectionVariableExpression)expressionObj).getExpression();
            return FieldUtils.getBindStatusFromParsedExpression(processingContext, optional, true, bindExpression);
        }
        if (expressionObj instanceof VariableExpression) {
            String bindExpression = ((VariableExpression)expressionObj).getExpression();
            return FieldUtils.getBindStatusFromParsedExpression(processingContext, optional, false, bindExpression);
        }
        throw new TemplateProcessingException("Expression \"" + expression + "\" is not valid: only variable expressions ${...} or " + "selection expressions *{...} are allowed in Spring field bindings");
    }

    public static BindStatus getBindStatusFromParsedExpression(IProcessingContext processingContext, boolean useSelectionAsRoot, String expression) {
        return FieldUtils.getBindStatusFromParsedExpression(processingContext, false, useSelectionAsRoot, expression);
    }

    public static BindStatus getBindStatusFromParsedExpression(IProcessingContext processingContext, boolean optional, boolean useSelectionAsRoot, String expression) {
        RequestContext requestContext = (RequestContext)processingContext.getVariables().getVariable("springRequestContext");
        if (requestContext == null) {
            return null;
        }
        String completeExpression = FieldUtils.validateAndGetValueExpression(processingContext, useSelectionAsRoot, expression);
        if (completeExpression == null) {
            return null;
        }
        if (!optional) {
            return new BindStatus(requestContext, completeExpression, false);
        }
        if (FieldUtils.isBound(requestContext, completeExpression)) {
            try {
                return new BindStatus(requestContext, completeExpression, false);
            }
            catch (NotReadablePropertyException ignored) {
                return null;
            }
        }
        return null;
    }

    private static String validateAndGetValueExpression(IProcessingContext processingContext, boolean useSelectionAsRoot, String expression) {
        if (useSelectionAsRoot) {
            String boundObjectExpression;
            VariableExpression boundObjectValue = (VariableExpression)processingContext.getVariables().getVariable("springBoundObjectExpression");
            String string = boundObjectExpression = boundObjectValue == null ? null : boundObjectValue.getExpression();
            if (GLOBAL_EXPRESSION.equals(expression)) {
                if (boundObjectExpression == null) {
                    return null;
                }
                return boundObjectExpression;
            }
            if (ALL_EXPRESSION.equals(expression) || ALL_FIELDS.equals(expression)) {
                if (boundObjectExpression == null) {
                    return null;
                }
                return boundObjectExpression + "." + ALL_FIELDS;
            }
            if (boundObjectExpression == null) {
                return expression;
            }
            return boundObjectExpression + "." + expression;
        }
        return expression;
    }

    private static boolean isBound(RequestContext requestContext, String completeExpression) {
        boolean beanValid;
        int dotPos = completeExpression.indexOf(46);
        if (dotPos == -1) {
            return false;
        }
        String beanName = completeExpression.substring(0, dotPos);
        boolean bl = beanValid = requestContext.getErrors(beanName, false) != null;
        if (beanValid && completeExpression.length() > dotPos) {
            String path = completeExpression.substring(dotPos + 1, completeExpression.length() - 1);
            return FieldUtils.validateBeanPath(path);
        }
        return false;
    }

    private static boolean validateBeanPath(CharSequence path) {
        int pathLen = path.length();
        for (int charPos = 0; charPos < pathLen; ++charPos) {
            char c = path.charAt(charPos);
            if (Character.isJavaIdentifierPart(c) && c != '.') continue;
            return false;
        }
        return true;
    }

    private FieldUtils() {
    }
}

