/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ITemplateProcessingContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IElementStructureHandler;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import org.unbescape.html.HtmlEscape;

public final class SpringValueTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor {
    public static final int ATTR_PRECEDENCE = 1010;
    public static final String ATTR_NAME = "value";

    public SpringValueTagProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, ATTR_NAME, 1010);
    }

    protected final void doProcess(ITemplateProcessingContext processingContext, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementStructureHandler structureHandler) {
        String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)(expressionResult == null ? "" : expressionResult.toString()));
        if (!tag.getAttributes().hasAttribute(attributeName.getPrefix(), "field")) {
            String nameValue = tag.getAttributes().getValue("name");
            String typeValue = tag.getAttributes().getValue("type");
            newAttributeValue = RequestDataValueProcessorUtils.processFormFieldValue((IProcessingContext)processingContext, nameValue, newAttributeValue, typeValue);
        }
        tag.getAttributes().setAttribute(ATTR_NAME, newAttributeValue == null ? "" : newAttributeValue);
        tag.getAttributes().removeAttribute(attributeName);
    }
}

