/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ITemplateProcessingContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IElementStructureHandler;
import org.thymeleaf.engine.IMarkup;
import org.thymeleaf.engine.ITemplateHandlerEvent;
import org.thymeleaf.engine.Markup;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import org.unbescape.html.HtmlEscape;

public final class SpringMethodTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor {
    public static final int ATTR_PRECEDENCE = 990;
    public static final String ATTR_NAME = "method";

    public SpringMethodTagProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, ATTR_NAME, 990);
    }

    protected final void doProcess(ITemplateProcessingContext processingContext, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementStructureHandler structureHandler) {
        String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)(expressionResult == null ? null : expressionResult.toString()));
        if (newAttributeValue == null || newAttributeValue.length() == 0) {
            tag.getAttributes().removeAttribute(ATTR_NAME);
        } else {
            tag.getAttributes().setAttribute(ATTR_NAME, newAttributeValue);
        }
        tag.getAttributes().removeAttribute(attributeName);
        if (newAttributeValue != null && "form".equalsIgnoreCase(tag.getElementName()) && !this.isMethodBrowserSupported(newAttributeValue)) {
            tag.getAttributes().setAttribute(ATTR_NAME, "post");
            Markup hiddenMethodMarkup = processingContext.getMarkupFactory().createMarkup();
            String type = "hidden";
            String name = "_method";
            String value = RequestDataValueProcessorUtils.processFormFieldValue((IProcessingContext)processingContext, "_method", newAttributeValue, "hidden");
            IStandaloneElementTag hiddenMethodElementTag = processingContext.getMarkupFactory().createStandaloneElementTag("input", true);
            hiddenMethodElementTag.getAttributes().setAttribute("type", "hidden");
            hiddenMethodElementTag.getAttributes().setAttribute("name", "_method");
            hiddenMethodElementTag.getAttributes().setAttribute("value", value);
            hiddenMethodMarkup.add((ITemplateHandlerEvent)hiddenMethodElementTag);
            structureHandler.insertAfter((IMarkup)hiddenMethodMarkup, false);
        }
    }

    protected boolean isMethodBrowserSupported(String method) {
        return "get".equalsIgnoreCase(method) || "post".equalsIgnoreCase(method);
    }
}

