/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.processor.attr;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.ValueFormatterWrapper;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.spring3.util.FieldUtils;
import org.thymeleaf.templateparser.ITemplateParser;
import org.thymeleaf.util.DOMUtils;

public final class SpringErrorsAttrProcessor
extends AbstractAttrProcessor {
    private static final String ERROR_DELIMITER = "<br />";
    public static final int ATTR_PRECEDENCE = 1200;
    public static final String ATTR_NAME = "errors";

    public SpringErrorsAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 1200;
    }

    public ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        BindStatus bindStatus = FieldUtils.getBindStatus(arguments, attributeValue, true);
        if (bindStatus.isError()) {
            HashMap<String, BindStatus> localVariables = new HashMap<String, BindStatus>();
            localVariables.put("springFieldBindStatus", bindStatus);
            StringBuilder strBuilder = new StringBuilder();
            String[] errorMsgs = bindStatus.getErrorMessages();
            for (int i = 0; i < errorMsgs.length; ++i) {
                if (i > 0) {
                    strBuilder.append(ERROR_DELIMITER);
                }
                String displayString = ValueFormatterWrapper.getDisplayString(errorMsgs[i], false);
                try {
                    strBuilder.append(DOMUtils.escapeXml((String)displayString, (boolean)true));
                    continue;
                }
                catch (IOException e) {
                    throw new TemplateProcessingException("Exception while trying to escape Spring error message", (Throwable)e);
                }
            }
            element.clearChildren();
            Configuration configuration = arguments.getConfiguration();
            ITemplateParser templateParser = configuration.getTemplateModeHandler(arguments.getTemplateResolution().getTemplateMode()).getTemplateParser();
            List fragNodes = templateParser.parseFragment(configuration, strBuilder.toString());
            for (Node child : fragNodes) {
                child.setProcessable(false);
                element.addChild(child);
            }
            element.removeAttribute(attributeName);
            return ProcessorResult.setLocalVariables(localVariables);
        }
        element.getParent().removeChild((Node)element);
        return ProcessorResult.OK;
    }
}

