/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.chrono.JapaneseChronology;
import org.threeten.bp.chrono.Ser;
import org.threeten.bp.jdk8.DefaultInterfaceEra;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Era;

final class JapaneseEra
extends DefaultInterfaceEra
implements Serializable {
    static final int ERA_OFFSET = 2;
    static final Era[] ERA_CONFIG;
    public static final JapaneseEra SEIREKI;
    public static final JapaneseEra MEIJI;
    public static final JapaneseEra TAISHO;
    public static final JapaneseEra SHOWA;
    public static final JapaneseEra HEISEI;
    private static final int N_ERA_CONSTANTS;
    private static final long serialVersionUID = 1466499369062886794L;
    private static final JapaneseEra[] KNOWN_ERAS;
    private final int eraValue;
    private final transient LocalDate since;

    private JapaneseEra(int eraValue, LocalDate since) {
        this.eraValue = eraValue;
        this.since = since;
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return JapaneseEra.of(this.eraValue);
        }
        catch (DateTimeException e) {
            InvalidObjectException ex = new InvalidObjectException("Invalid era");
            ex.initCause(e);
            throw ex;
        }
    }

    Era getPrivateEra() {
        return ERA_CONFIG[JapaneseEra.ordinal(this.eraValue)];
    }

    public static JapaneseEra of(int japaneseEra) {
        if (japaneseEra != JapaneseEra.SEIREKI.eraValue && (japaneseEra < JapaneseEra.MEIJI.eraValue || japaneseEra > JapaneseEra.HEISEI.eraValue)) {
            throw new DateTimeException("japaneseEra is invalid");
        }
        return KNOWN_ERAS[JapaneseEra.ordinal(japaneseEra)];
    }

    static JapaneseEra[] values() {
        return Arrays.copyOf(KNOWN_ERAS, KNOWN_ERAS.length);
    }

    static JapaneseEra from(LocalDate date) {
        for (int i = KNOWN_ERAS.length - 1; i > 0; --i) {
            JapaneseEra era = KNOWN_ERAS[i];
            if (date.compareTo(era.since) < 0) continue;
            return era;
        }
        return SEIREKI;
    }

    static JapaneseEra toJapaneseEra(Era privateEra) {
        for (int i = ERA_CONFIG.length - 1; i > 0; --i) {
            if (!ERA_CONFIG[i].equals(privateEra)) continue;
            return KNOWN_ERAS[i];
        }
        return SEIREKI;
    }

    static Era privateEraFrom(LocalDate isoDate) {
        for (int i = KNOWN_ERAS.length - 1; i > 0; --i) {
            JapaneseEra era = KNOWN_ERAS[i];
            if (isoDate.compareTo(era.since) < 0) continue;
            return ERA_CONFIG[i];
        }
        return null;
    }

    private static int ordinal(int eravalue) {
        return eravalue == JapaneseEra.SEIREKI.eraValue ? 0 : eravalue + 2;
    }

    @Override
    public int getValue() {
        return this.eraValue;
    }

    @Override
    public JapaneseChronology getChronology() {
        return JapaneseChronology.INSTANCE;
    }

    String getAbbreviation() {
        int index = JapaneseEra.ordinal(this.getValue());
        if (index == 0) {
            return "";
        }
        return ERA_CONFIG[index].getAbbreviation();
    }

    String getName() {
        int index = JapaneseEra.ordinal(this.getValue());
        if (index == 0) {
            return "Seireki";
        }
        return ERA_CONFIG[index].getName();
    }

    public String toString() {
        return this.getName();
    }

    private Object writeReplace() {
        return new Ser(2, this);
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.getValue());
    }

    static JapaneseEra readExternal(DataInput in) throws IOException {
        byte eraValue = in.readByte();
        return JapaneseEra.of(eraValue);
    }

    static {
        int i;
        SEIREKI = new JapaneseEra(-999, LocalDate.MIN);
        MEIJI = new JapaneseEra(-1, LocalDate.of(1868, 9, 8));
        TAISHO = new JapaneseEra(0, LocalDate.of(1912, 7, 30));
        SHOWA = new JapaneseEra(1, LocalDate.of(1926, 12, 25));
        HEISEI = new JapaneseEra(2, LocalDate.of(1989, 1, 8));
        N_ERA_CONSTANTS = HEISEI.getValue() + 2 + 1;
        Era[] sunEras = JapaneseChronology.JCAL.getEras();
        ERA_CONFIG = new Era[sunEras.length + 1];
        for (i = 1; i < ERA_CONFIG.length; ++i) {
            JapaneseEra.ERA_CONFIG[i] = sunEras[i - 1];
        }
        KNOWN_ERAS = new JapaneseEra[ERA_CONFIG.length];
        JapaneseEra.KNOWN_ERAS[0] = SEIREKI;
        JapaneseEra.KNOWN_ERAS[1] = MEIJI;
        JapaneseEra.KNOWN_ERAS[2] = TAISHO;
        JapaneseEra.KNOWN_ERAS[3] = SHOWA;
        JapaneseEra.KNOWN_ERAS[4] = HEISEI;
        for (i = N_ERA_CONSTANTS; i < ERA_CONFIG.length; ++i) {
            CalendarDate date = ERA_CONFIG[i].getSinceDate();
            LocalDate isoDate = LocalDate.of(date.getYear(), date.getMonth(), date.getDayOfMonth());
            JapaneseEra.KNOWN_ERAS[i] = new JapaneseEra(i - 2, isoDate);
        }
    }
}

