/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.chrono;

import java.util.Comparator;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.chrono.ChronoLocalDate;
import org.threeten.bp.chrono.ChronoZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalAmount;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalUnit;

public interface ChronoLocalDateTime<D extends ChronoLocalDate<D>>
extends Temporal,
TemporalAdjuster,
Comparable<ChronoLocalDateTime<?>> {
    public static final Comparator<ChronoLocalDateTime<?>> DATE_TIME_COMPARATOR = new Comparator<ChronoLocalDateTime<?>>(){

        @Override
        public int compare(ChronoLocalDateTime<?> datetime1, ChronoLocalDateTime<?> datetime2) {
            int cmp = Long.compare(datetime1.toLocalDate().toEpochDay(), datetime2.toLocalDate().toEpochDay());
            if (cmp == 0) {
                cmp = Long.compare(datetime1.toLocalTime().toNanoOfDay(), datetime2.toLocalTime().toNanoOfDay());
            }
            return cmp;
        }
    };

    public ChronoLocalDate<D> toLocalDate();

    public LocalTime toLocalTime();

    @Override
    public ChronoLocalDateTime<D> with(TemporalAdjuster var1);

    @Override
    public ChronoLocalDateTime<D> with(TemporalField var1, long var2);

    @Override
    public ChronoLocalDateTime<D> plus(TemporalAmount var1);

    @Override
    public ChronoLocalDateTime<D> plus(long var1, TemporalUnit var3);

    @Override
    public ChronoLocalDateTime<D> minus(TemporalAmount var1);

    @Override
    public ChronoLocalDateTime<D> minus(long var1, TemporalUnit var3);

    public ChronoZonedDateTime<D> atZone(ZoneId var1);

    public Instant toInstant(ZoneOffset var1);

    public long toEpochSecond(ZoneOffset var1);

    @Override
    public int compareTo(ChronoLocalDateTime<?> var1);

    public boolean isAfter(ChronoLocalDateTime<?> var1);

    public boolean isBefore(ChronoLocalDateTime<?> var1);

    public boolean isEqual(ChronoLocalDateTime<?> var1);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();

    public String toString(DateTimeFormatter var1);
}

