/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.format.DateTimeBuilder;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.temporal.ValueRange;

public final class JulianFields {
    public static final TemporalField JULIAN_DAY = Field.JULIAN_DAY;
    public static final TemporalField MODIFIED_JULIAN_DAY = Field.MODIFIED_JULIAN_DAY;
    public static final TemporalField RATA_DIE = Field.RATA_DIE;

    private static enum Field implements TemporalField
    {
        JULIAN_DAY("JulianDay", ChronoUnit.DAYS, ChronoUnit.FOREVER, 2440588L),
        MODIFIED_JULIAN_DAY("ModifiedJulianDay", ChronoUnit.DAYS, ChronoUnit.FOREVER, 40587L),
        RATA_DIE("RataDie", ChronoUnit.DAYS, ChronoUnit.FOREVER, 719163L);

        private final String name;
        private final TemporalUnit baseUnit;
        private final TemporalUnit rangeUnit;
        private final ValueRange range;
        private final long offset;

        private Field(String name, TemporalUnit baseUnit, TemporalUnit rangeUnit, long offset) {
            this.name = name;
            this.baseUnit = baseUnit;
            this.rangeUnit = rangeUnit;
            this.range = ValueRange.of(-365243219162L + offset, 365241780471L + offset);
            this.offset = offset;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TemporalUnit getBaseUnit() {
            return this.baseUnit;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return this.rangeUnit;
        }

        @Override
        public ValueRange range() {
            return this.range;
        }

        @Override
        public int compare(TemporalAccessor temporal1, TemporalAccessor temporal2) {
            return Long.compare(temporal1.getLong(this), temporal2.getLong(this));
        }

        @Override
        public boolean doIsSupported(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.EPOCH_DAY);
        }

        @Override
        public ValueRange doRange(TemporalAccessor temporal) {
            if (!this.doIsSupported(temporal)) {
                throw new DateTimeException("Unsupported field: " + this);
            }
            return this.range();
        }

        @Override
        public long doGet(TemporalAccessor temporal) {
            return temporal.getLong(ChronoField.EPOCH_DAY) + this.offset;
        }

        @Override
        public <R extends Temporal> R doWith(R dateTime, long newValue) {
            if (!this.range().isValidValue(newValue)) {
                throw new DateTimeException("Invalid value: " + this.name + " " + newValue);
            }
            return (R)dateTime.with(ChronoField.EPOCH_DAY, Jdk8Methods.safeSubtract(newValue, this.offset));
        }

        @Override
        public boolean resolve(DateTimeBuilder builder, long value) {
            boolean changed = false;
            changed = this.resolve0(JULIAN_DAY, builder, changed);
            changed = this.resolve0(MODIFIED_JULIAN_DAY, builder, changed);
            changed = this.resolve0(RATA_DIE, builder, changed);
            return changed;
        }

        private boolean resolve0(Field field, DateTimeBuilder builder, boolean changed) {
            if (builder.containsFieldValue(field)) {
                builder.addCalendrical(LocalDate.ofEpochDay(Jdk8Methods.safeSubtract(builder.getFieldValue(JULIAN_DAY), Field.JULIAN_DAY.offset)));
                builder.removeFieldValue(JULIAN_DAY);
                changed = true;
            }
            return changed;
        }

        public String toString() {
            return this.getName();
        }
    }
}

