/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.calendar;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.calendar.ChronoDateImpl;
import org.threeten.bp.calendar.JapaneseChrono;
import org.threeten.bp.calendar.JapaneseEra;
import org.threeten.bp.calendar.Ser;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.ValueRange;
import sun.util.calendar.Era;
import sun.util.calendar.LocalGregorianCalendar;

final class JapaneseDate
extends ChronoDateImpl<JapaneseChrono>
implements Serializable {
    private static final long serialVersionUID = -305327627230580483L;
    private final LocalDate isoDate;
    private transient JapaneseEra era;
    private transient int yearOfEra;

    static JapaneseDate of(JapaneseEra era, int yearOfEra, int month, int dayOfMonth) {
        Objects.requireNonNull(era, "era");
        LocalGregorianCalendar.Date jdate = JapaneseChrono.JCAL.newCalendarDate(null);
        jdate.setEra(era.getPrivateEra()).setDate(yearOfEra, month, dayOfMonth);
        if (!JapaneseChrono.JCAL.validate(jdate)) {
            throw new IllegalArgumentException();
        }
        LocalDate date = LocalDate.of(jdate.getNormalizedYear(), month, dayOfMonth);
        return new JapaneseDate(era, yearOfEra, date);
    }

    JapaneseDate(LocalDate isoDate) {
        LocalGregorianCalendar.Date jdate = JapaneseDate.toPrivateJapaneseDate(isoDate);
        this.era = JapaneseEra.toJapaneseEra(jdate.getEra());
        this.yearOfEra = jdate.getYear();
        this.isoDate = isoDate;
    }

    JapaneseDate(JapaneseEra era, int year, LocalDate isoDate) {
        this.era = era;
        this.yearOfEra = year;
        this.isoDate = isoDate;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        LocalGregorianCalendar.Date jdate = JapaneseDate.toPrivateJapaneseDate(this.isoDate);
        this.era = JapaneseEra.toJapaneseEra(jdate.getEra());
        this.yearOfEra = jdate.getYear();
    }

    @Override
    public JapaneseChrono getChrono() {
        return JapaneseChrono.INSTANCE;
    }

    @Override
    public int lengthOfMonth() {
        return this.isoDate.lengthOfMonth();
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                ChronoField f = (ChronoField)field;
                switch (f) {
                    case DAY_OF_YEAR: {
                        return this.actualRange(6);
                    }
                    case YEAR_OF_ERA: {
                        return this.actualRange(1);
                    }
                }
                return this.getChrono().range(f);
            }
            throw new DateTimeException("Unsupported field: " + field.getName());
        }
        return field.doRange(this);
    }

    private ValueRange actualRange(int calendarField) {
        Calendar jcal = Calendar.getInstance(JapaneseChrono.LOCALE);
        jcal.set(0, this.era.getValue() + 2);
        jcal.set(this.yearOfEra, this.isoDate.getMonthValue() - 1, this.isoDate.getDayOfMonth());
        return ValueRange.of(jcal.getActualMinimum(calendarField), jcal.getActualMaximum(calendarField));
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case YEAR_OF_ERA: {
                    return this.yearOfEra;
                }
                case ERA: {
                    return this.era.getValue();
                }
                case DAY_OF_YEAR: {
                    LocalGregorianCalendar.Date jdate = JapaneseDate.toPrivateJapaneseDate(this.isoDate);
                    return JapaneseChrono.JCAL.getDayOfYear(jdate);
                }
            }
            return this.isoDate.getLong(field);
        }
        return field.doGet(this);
    }

    private static LocalGregorianCalendar.Date toPrivateJapaneseDate(LocalDate isoDate) {
        LocalGregorianCalendar.Date jdate = JapaneseChrono.JCAL.newCalendarDate(null);
        Era sunEra = JapaneseEra.privateEraFrom(isoDate);
        int year = isoDate.getYear();
        if (sunEra != null) {
            year -= sunEra.getSinceDate().getYear() - 1;
        }
        jdate.setEra(sunEra).setYear(year).setMonth(isoDate.getMonthValue()).setDayOfMonth(isoDate.getDayOfMonth());
        JapaneseChrono.JCAL.normalize(jdate);
        return jdate;
    }

    @Override
    public JapaneseDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            if (this.getLong(f) == newValue) {
                return this;
            }
            switch (f) {
                case YEAR_OF_ERA: 
                case ERA: 
                case YEAR: {
                    f.checkValidValue(newValue);
                    int nvalue = (int)newValue;
                    switch (f) {
                        case YEAR_OF_ERA: {
                            return this.withYear(nvalue);
                        }
                        case YEAR: {
                            return this.with(this.isoDate.withYear(nvalue));
                        }
                        case ERA: {
                            return this.withYear(JapaneseEra.of(nvalue), this.yearOfEra);
                        }
                    }
                }
            }
            return this.with(this.isoDate.with(field, newValue));
        }
        return field.doWith(this, newValue);
    }

    private JapaneseDate withYear(JapaneseEra era, int yearOfEra) {
        int year = JapaneseChrono.INSTANCE.prolepticYear(era, yearOfEra);
        return this.with(this.isoDate.withYear(year));
    }

    private JapaneseDate withYear(int year) {
        return this.withYear((JapaneseEra)this.getEra(), year);
    }

    JapaneseDate plusYears(long years) {
        return this.with(this.isoDate.plusYears(years));
    }

    JapaneseDate plusMonths(long months) {
        return this.with(this.isoDate.plusMonths(months));
    }

    JapaneseDate plusDays(long days) {
        return this.with(this.isoDate.plusDays(days));
    }

    private JapaneseDate with(LocalDate newDate) {
        return newDate.equals(this.isoDate) ? this : new JapaneseDate(newDate);
    }

    @Override
    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JapaneseDate) {
            JapaneseDate otherDate = (JapaneseDate)obj;
            return this.isoDate.equals(otherDate.isoDate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getChrono().getId().hashCode() ^ this.isoDate.hashCode();
    }

    @Override
    public String toString() {
        if (this.era == JapaneseEra.SEIREKI) {
            return this.getChrono().getId() + " " + this.isoDate.toString();
        }
        return super.toString();
    }

    private Object writeReplace() {
        return new Ser(1, this);
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.get(ChronoField.YEAR));
        out.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        out.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static ChronoLocalDate<JapaneseChrono> readExternal(DataInput in) throws IOException {
        int year = in.readInt();
        byte month = in.readByte();
        byte dayOfMonth = in.readByte();
        return JapaneseChrono.INSTANCE.date(year, month, dayOfMonth);
    }
}

