/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.calendar;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.calendar.HijrahDate;
import org.threeten.bp.calendar.HijrahEra;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.Era;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.ValueRange;

public final class HijrahChrono
extends Chrono<HijrahChrono>
implements Serializable {
    public static final HijrahChrono INSTANCE = new HijrahChrono();
    public static final Era<HijrahChrono> ERA_BEFORE_AH = HijrahEra.BEFORE_AH;
    public static final Era<HijrahChrono> ERA_AH = HijrahEra.AH;
    private static final long serialVersionUID = 3127340209035924785L;
    private static final HashMap<String, String[]> ERA_NARROW_NAMES = new HashMap();
    private static final HashMap<String, String[]> ERA_SHORT_NAMES = new HashMap();
    private static final HashMap<String, String[]> ERA_FULL_NAMES = new HashMap();
    private static final String FALLBACK_LANGUAGE = "en";

    private HijrahChrono() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "Hijrah";
    }

    @Override
    public String getCalendarType() {
        return "islamicc";
    }

    @Override
    public ChronoLocalDate<HijrahChrono> date(int prolepticYear, int month, int dayOfMonth) {
        return HijrahDate.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public ChronoLocalDate<HijrahChrono> dateYearDay(int prolepticYear, int dayOfYear) {
        return HijrahDate.of(prolepticYear, 1, 1).plusDays(dayOfYear - 1);
    }

    @Override
    public ChronoLocalDate<HijrahChrono> date(TemporalAccessor temporal) {
        if (temporal instanceof HijrahDate) {
            return (HijrahDate)temporal;
        }
        return HijrahDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return HijrahDate.isLeapYear(prolepticYear);
    }

    @Override
    public int prolepticYear(Era<HijrahChrono> era, int yearOfEra) {
        if (!(era instanceof HijrahEra)) {
            throw new DateTimeException("Era must be HijrahEra");
        }
        return era == HijrahEra.AH ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public Era<HijrahChrono> eraOf(int eraValue) {
        switch (eraValue) {
            case 0: {
                return HijrahEra.BEFORE_AH;
            }
            case 1: {
                return HijrahEra.AH;
            }
        }
        throw new DateTimeException("invalid Hijrah era");
    }

    @Override
    public List<Era<HijrahChrono>> eras() {
        return Arrays.asList(HijrahEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        return field.range();
    }

    static {
        ERA_NARROW_NAMES.put(FALLBACK_LANGUAGE, new String[]{"BH", "HE"});
        ERA_SHORT_NAMES.put(FALLBACK_LANGUAGE, new String[]{"B.H.", "H.E."});
        ERA_FULL_NAMES.put(FALLBACK_LANGUAGE, new String[]{"Before Hijrah", "Hijrah Era"});
    }
}

