/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Era;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.threeten.extra.chrono.CopticDate;
import org.threeten.extra.chrono.CopticEra;

public final class CopticChronology
extends AbstractChronology
implements Serializable {
    public static final CopticChronology INSTANCE = new CopticChronology();
    private static final long serialVersionUID = 7291205177830286973L;
    static final ValueRange YEAR_RANGE = ValueRange.of(-999998L, 999999L);
    static final ValueRange YOE_RANGE = ValueRange.of(1L, 999999L);
    static final ValueRange PROLEPTIC_MONTH_RANGE = ValueRange.of(-12999974L, 12999999L);
    static final ValueRange MOY_RANGE = ValueRange.of(1L, 13L);
    static final ValueRange ALIGNED_WOM_RANGE = ValueRange.of(1L, 1L, 5L);
    static final ValueRange DOM_RANGE = ValueRange.of(1L, 5L, 30L);
    static final ValueRange DOM_RANGE_NONLEAP = ValueRange.of(1L, 5L);
    static final ValueRange DOM_RANGE_LEAP = ValueRange.of(1L, 6L);

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "Coptic";
    }

    @Override
    public String getCalendarType() {
        return "coptic";
    }

    @Override
    public CopticDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public CopticDate date(int prolepticYear, int month, int dayOfMonth) {
        return CopticDate.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public CopticDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public CopticDate dateYearDay(int prolepticYear, int dayOfYear) {
        return CopticDate.ofYearDay(prolepticYear, dayOfYear);
    }

    @Override
    public CopticDate dateEpochDay(long epochDay) {
        return CopticDate.ofEpochDay(epochDay);
    }

    @Override
    public CopticDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    @Override
    public CopticDate dateNow(ZoneId zone) {
        return this.dateNow(Clock.system(zone));
    }

    @Override
    public CopticDate dateNow(Clock clock) {
        return this.date(LocalDate.now(clock));
    }

    @Override
    public CopticDate date(TemporalAccessor temporal) {
        return CopticDate.from(temporal);
    }

    public ChronoLocalDateTime<CopticDate> localDateTime(TemporalAccessor temporal) {
        return super.localDateTime(temporal);
    }

    public ChronoZonedDateTime<CopticDate> zonedDateTime(TemporalAccessor temporal) {
        return super.zonedDateTime(temporal);
    }

    public ChronoZonedDateTime<CopticDate> zonedDateTime(Instant instant, ZoneId zone) {
        return super.zonedDateTime(instant, zone);
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return Math.floorMod(prolepticYear, 4L) == 3L;
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof CopticEra)) {
            throw new ClassCastException("Era must be CopticEra");
        }
        return era == CopticEra.AM ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public CopticEra eraOf(int eraValue) {
        return CopticEra.of(eraValue);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(CopticEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        switch (field) {
            case DAY_OF_MONTH: {
                return DOM_RANGE;
            }
            case ALIGNED_WEEK_OF_MONTH: {
                return ALIGNED_WOM_RANGE;
            }
            case MONTH_OF_YEAR: {
                return MOY_RANGE;
            }
            case PROLEPTIC_MONTH: {
                return PROLEPTIC_MONTH_RANGE;
            }
            case YEAR_OF_ERA: {
                return YOE_RANGE;
            }
            case YEAR: {
                return YEAR_RANGE;
            }
        }
        return field.range();
    }

    @Override
    public CopticDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        return (CopticDate)super.resolveDate(fieldValues, resolverStyle);
    }
}

