/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.framework.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.testfx.framework.junit5.TestFx;
import org.testfx.framework.junit5.utils.FXUtils;

public class JavaFXInterceptorUtils {

    public static class SelectiveJavaFxInterceptor
    implements InvocationInterceptor {
        public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
            AtomicReference throwable = new AtomicReference();
            boolean isFxAnnotation = false;
            Optional element = extensionContext.getElement();
            if (element.isPresent()) {
                for (Annotation annotation : ((AnnotatedElement)element.get()).getAnnotations()) {
                    if (!annotation.annotationType().equals(TestFx.class)) continue;
                    isFxAnnotation = true;
                }
            }
            Runnable testToBeExecuted = () -> {
                try {
                    invocation.proceed();
                }
                catch (Throwable t) {
                    throwable.set(t);
                }
            };
            if (isFxAnnotation) {
                FXUtils.runAndWait(testToBeExecuted);
            } else {
                testToBeExecuted.run();
            }
            Throwable t = (Throwable)throwable.get();
            if (t != null) {
                throw t;
            }
        }
    }

    public static class JavaFxInterceptor
    implements InvocationInterceptor {
        public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
            AtomicReference throwable = new AtomicReference();
            FXUtils.runAndWait(() -> {
                try {
                    invocation.proceed();
                }
                catch (Throwable t) {
                    throwable.set(t);
                }
            });
            Throwable t = (Throwable)throwable.get();
            if (t != null) {
                throw t;
            }
        }
    }
}

