/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.toolkit.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.testfx.api.FxToolkit;
import org.testfx.toolkit.ApplicationLauncher;
import org.testfx.toolkit.ApplicationService;
import org.testfx.toolkit.ToolkitService;
import org.testfx.util.WaitForAsyncUtils;

public class ToolkitServiceImpl
implements ToolkitService {
    private final ApplicationLauncher applicationLauncher;
    private final ApplicationService applicationService;

    public ToolkitServiceImpl(ApplicationLauncher applicationLauncher, ApplicationService applicationService) {
        this.applicationLauncher = applicationLauncher;
        this.applicationService = applicationService;
    }

    @Override
    public Future<Stage> setupPrimaryStage(CompletableFuture<Stage> primaryStageFuture, Class<? extends Application> applicationClass, String ... applicationArgs) {
        if (!primaryStageFuture.isDone()) {
            WaitForAsyncUtils.async(() -> {
                try {
                    this.applicationLauncher.launch(applicationClass, applicationArgs);
                }
                catch (Throwable exception) {
                    primaryStageFuture.completeExceptionally(exception);
                }
            });
        }
        return primaryStageFuture;
    }

    @Override
    public Future<Void> setupFixture(Runnable runnable) {
        return WaitForAsyncUtils.asyncFx(runnable);
    }

    @Override
    public <T> Future<T> setupFixture(Callable<T> callable) {
        return WaitForAsyncUtils.asyncFx(callable);
    }

    @Override
    public Future<Stage> setupStage(Stage stage, Consumer<Stage> stageConsumer) {
        return WaitForAsyncUtils.asyncFx(() -> {
            stageConsumer.accept(stage);
            return stage;
        });
    }

    @Override
    public Future<Scene> setupScene(Stage stage, Supplier<? extends Scene> sceneSupplier) {
        return WaitForAsyncUtils.asyncFx(() -> {
            Scene scene = (Scene)sceneSupplier.get();
            stage.setScene(scene);
            return scene;
        });
    }

    @Override
    public Future<Parent> setupSceneRoot(Stage stage, Supplier<? extends Parent> sceneRootSupplier) {
        return WaitForAsyncUtils.asyncFx(() -> {
            Parent rootNode = (Parent)sceneRootSupplier.get();
            stage.setScene(new Scene(rootNode));
            return rootNode;
        });
    }

    @Override
    public Future<Application> setupApplication(Supplier<Stage> stageSupplier, Class<? extends Application> applicationClass, String ... applicationArgs) {
        return WaitForAsyncUtils.async(() -> {
            Application application = WaitForAsyncUtils.asyncFx(() -> this.createApplication(applicationClass)).get();
            this.registerApplicationParameters(application, applicationArgs);
            this.applicationService.init(application).get();
            this.applicationService.start(application, (Stage)stageSupplier.get()).get();
            return application;
        });
    }

    @Override
    public Future<Application> setupApplication(Supplier<Stage> stageSupplier, Supplier<Application> applicationSupplier, String ... applicationArgs) {
        return WaitForAsyncUtils.async(() -> {
            Application application = WaitForAsyncUtils.asyncFx(((Supplier)applicationSupplier)::get).get();
            this.registerApplicationParameters(application, applicationArgs);
            this.applicationService.init(application).get();
            this.applicationService.start(application, (Stage)stageSupplier.get()).get();
            return application;
        });
    }

    @Override
    public Future<Void> cleanupApplication(Application application) {
        ToolkitServiceImpl.cleanupParameters(application);
        return this.applicationService.stop(application);
    }

    private Application createApplication(Class<? extends Application> applicationClass) throws Exception {
        return applicationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private void registerApplicationParameters(Application application, String ... applicationArgs) {
        String type = "com.sun.javafx.application.ParametersImpl";
        String methodName = "registerParameters";
        try {
            Class<?> parametersImpl = this.getClass().getClassLoader().loadClass(type);
            Constructor<?> constructor = parametersImpl.getDeclaredConstructor(List.class);
            Method method = parametersImpl.getDeclaredMethod(methodName, Application.class, Application.Parameters.class);
            Application.Parameters parameters = (Application.Parameters)constructor.newInstance(Arrays.asList(applicationArgs));
            method.invoke(parametersImpl, application, parameters);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void cleanupParameters(Application application) {
        try {
            String type = "com.sun.javafx.application.ParametersImpl";
            String fieldName = "params";
            Class<?> parametersImpl = FxToolkit.class.getClassLoader().loadClass(type);
            Field field = parametersImpl.getDeclaredField(fieldName);
            field.setAccessible(true);
            Map params = (Map)field.get(null);
            params.remove(application);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

